/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.swift;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import java.util.Arrays;

public class SwiftShallowParser
extends ShallowParserBase<EGenericParserStates> {
    private static final ITokenMatcher VISIBILITY_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.PUBLIC, ETokenType.INTERNAL, ETokenType.PRIVATE, ETokenType.FILEPRIVATE, ETokenType.STATIC, ETokenType.PACKAGE});
    private static final ITokenMatcher STATEMENT_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.RETURN, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.THROW, ETokenType.SUPER, ETokenType.SELF, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.STRING_LITERAL, ETokenType.FLOATING_POINT_LITERAL});
    private static final ITokenMatcher STATEMENT_SEPARATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON, ETokenType.RBRACE});
    private static final ITokenMatcher VALID_TYPE_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.QUESTION, ETokenType.DOT, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.ARROW, ETokenType.COMMA, ETokenType.LT, ETokenType.GT, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.EXCLAMATION, ETokenType.EOL, ETokenType.COLON, ETokenType.SELF, ETokenType.REPEAT});
    private static final ITokenMatcher TYPE_KEYWORDS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.ACTOR, ETokenType.PROTOCOL, ETokenType.STRUCT, ETokenType.EXTENSION});
    public static final ITokenMatcher CONTINUES_SIMPLE_STATEMENTS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.ANDAND, ETokenType.OROR, ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.GT, ETokenType.LT, ETokenType.LTEQ, ETokenType.GTEQ, ETokenType.QUESTION, ETokenType.COLON});

    public SwiftShallowParser() {
        super(EGenericParserStates.class, EGenericParserStates.TOP_LEVEL);
        this.createMetaRules();
        this.createTypeRules();
        this.createMethodRules();
        this.createStatementRules();
        this.createSubExpressionRules();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.EOL});
    }

    private void createMetaRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).markStart().skipBefore(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.META, "import", INameResolver.ofRange(0, -1)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).optional(VISIBILITY_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.TYPEALIAS}).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).createNode(EShallowEntityType.META, "type alias").endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT, ETokenType.IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, "annotation", INameResolver.ofRange(1, -1)).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PREPROCESSOR_DIRECTIVE}).createNode(EShallowEntityType.META, "preprocessor directive", INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    private void createSubExpressionRules() {
        SwiftShallowParser.finishLambdaRule(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IN, ETokenType.RBRACE}), Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE)).sequence(new ITokenMatcher[]{ETokenType.IN}));
        SwiftShallowParser.finishLambdaRule(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}));
    }

    private static void finishLambdaRule(RecognizerBase<EGenericParserStates> lambdaRule) {
        lambdaRule.createNode(EShallowEntityType.METHOD, "lambda").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createStatementRules() {
        this.createLoopRules();
        this.createConditionalRules();
        this.createDoCatchRule("do", new ITokenMatcher[]{ETokenType.DO});
        this.createDoCatchRule("catch", new ITokenMatcher[]{ETokenType.CATCH});
        this.createDeferStatementRule();
        this.createLocalVariableRule(ETokenType.VAR);
        this.createLocalVariableRule(ETokenType.LET);
        this.createPackExpansionStatementRule();
        this.createSimpleStatementRule();
        this.createSwitchStatementRule();
        this.createImplicitMemberTypeRule();
    }

    private void createLocalVariableRule(ETokenType keyword) {
        this.finishVariableRule(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{keyword}).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.secondMatchedTokenText()));
    }

    private void createPackExpansionStatementRule() {
        this.finishStatementRule(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.REPEAT}).createNode(EShallowEntityType.STATEMENT, "repeat"));
    }

    private void finishVariableRule(RecognizerBase<EGenericParserStates> variableRule) {
        RecognizerBase multilineRecognizer = this.createRecognizer(start -> start.skipAfterWithNesting((ITokenMatcher)ETokenType.EOL, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK), this.createSubExpressionRecognizer()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.DOT}));
        variableRule.repeatedSubRecognizer(multilineRecognizer).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON, ETokenType.RBRACE}), Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK)).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON})).endNode();
    }

    private void createSwitchStatementRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch").skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createSubExpressionRecognizer()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.META, "case").skipAfterWithNesting((ITokenMatcher)ETokenType.COLON, ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT}).createNode(EShallowEntityType.META, "default").skipAfter(new ITokenMatcher[]{ETokenType.COLON}).endNode();
    }

    private void createSimpleStatementRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
        RecognizerBase statementRule = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD});
        this.finishSimpleStatementRule(statementRule.sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}));
        this.finishSimpleStatementRule(statementRule.sequence(STATEMENT_START_TOKENS));
    }

    private void createImplicitMemberTypeRule() {
        RecognizerBase implicitMemberStart = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DOT, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DEFAULT, ETokenType.IDENTIFIER})});
        RecognizerBase<EGenericParserStates> implicitMember = implicitMemberStart.markStart().createNode(EShallowEntityType.STATEMENT, "implicit member", INameResolver.previousTokenText());
        this.finishStatementRule(implicitMember);
    }

    private void finishSimpleStatementRule(RecognizerBase<EGenericParserStates> statementRule) {
        this.finishStatementRule(statementRule.createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()));
    }

    private void finishStatementRule(RecognizerBase<EGenericParserStates> statementRule) {
        RecognizerBase multilineRecognizer = this.createRecognizer(start -> start.skipBeforeWithNesting(STATEMENT_SEPARATORS, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE), this.createSubExpressionRecognizer()).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(CONTINUES_SIMPLE_STATEMENTS));
        statementRule.repeatedSubRecognizer(multilineRecognizer).skipBeforeWithNesting(STATEMENT_SEPARATORS, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE)).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOL})).endNode();
    }

    private void createConditionalRules() {
        this.createConditionalRule("if let", new ITokenMatcher[]{ETokenType.IF, ETokenType.LET});
        this.createConditionalRule("if var", new ITokenMatcher[]{ETokenType.IF, ETokenType.VAR});
        this.createConditionalRule("if", new ITokenMatcher[]{ETokenType.IF});
        this.createConditionalRule("else if", new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF});
        this.createConditionalRule("else", new ITokenMatcher[]{ETokenType.ELSE});
        this.createConditionalRule("guard", new ITokenMatcher[]{ETokenType.GUARD});
    }

    private void createConditionalRule(String subtype, ITokenMatcher ... matchTerms) {
        this.endWithPossibleContinuation(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(matchTerms).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, subtype).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), (ITokenMatcher)ETokenType.ELSE);
    }

    private void createDoCatchRule(String subtype, ITokenMatcher ... matchTerms) {
        this.endWithPossibleContinuation(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(matchTerms).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, subtype).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), (ITokenMatcher)ETokenType.CATCH);
    }

    private void createDeferStatementRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFER}).createNode(EShallowEntityType.STATEMENT, "defer").skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createLoopRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.REPEAT}).peekAhead(ETokenType.LBRACE).createNode(EShallowEntityType.STATEMENT, "repeat while").skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
        this.createWhileRule(INameResolver.ofString("while let"), new ITokenMatcher[]{ETokenType.WHILE, ETokenType.LET});
        this.createWhileRule(INameResolver.firstMatchedTokenText(), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FOR, ETokenType.WHILE}));
    }

    private void createWhileRule(INameResolver subtype, ITokenMatcher ... matchTerms) {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(matchTerms).createNode(EShallowEntityType.STATEMENT, subtype).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    public void createTypeRules() {
        this.createTypeRule();
        this.createEnumRule();
        this.createAttributeRule(ETokenType.VAR);
        this.createAttributeRule(ETokenType.LET);
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(VISIBILITY_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.CASE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.secondMatchedTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.RBRACE}), ETokenType.LBRACE, ETokenType.RBRACE).endNode();
    }

    private void createAttributeRule(ETokenType propertyKeyword) {
        this.finishVariableRule(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(VISIBILITY_MODIFIERS).optional(new ITokenMatcher[]{ETokenType.LPAREN, ETokenType.SET, ETokenType.RPAREN}).markStart().sequence(new ITokenMatcher[]{propertyKeyword, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.secondMatchedTokenText()));
    }

    private void createTypeRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).repeated(VISIBILITY_MODIFIERS).markStart().optional(new ITokenMatcher[]{ETokenType.DISTRIBUTED}).sequence(TYPE_KEYWORDS).optional(new ITokenMatcher[]{ETokenType.LBRACK}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.RBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEnumRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE, EGenericParserStates.IN_METHOD}).repeated(VISIBILITY_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.ENUM, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createMethodRules() {
        RecognizerBase methodSubRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.OVERRIDE}).repeated(VISIBILITY_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.FUNC, ETokenType.IDENTIFIER}));
        this.finishMethodRule(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).subRecognizer(methodSubRecognizer).sequence(new ITokenMatcher[]{ETokenType.LT}).skipBefore(new ITokenMatcher[]{ETokenType.GT}).sequence(new ITokenMatcher[]{ETokenType.GT}), "method", 1);
        this.finishMethodRule(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).subRecognizer(methodSubRecognizer), "method", -1);
        this.finishMethodRule(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).repeated(VISIBILITY_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.FUNC, ETokenType.EQEQ}), "method", -1);
        this.createConstructorDestructorRule(ETokenType.INIT, "constructor");
        this.createConstructorDestructorRule(ETokenType.DEINIT, "destructor");
    }

    private void createConstructorDestructorRule(ETokenType keywordToken, String subtype) {
        this.finishMethodRule(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(VISIBILITY_MODIFIERS).sequence(new ITokenMatcher[]{keywordToken}), subtype, -1);
    }

    private void finishMethodRule(RecognizerBase<EGenericParserStates> rule, String subtype, int nameOffset) {
        RecognizerBase<EGenericParserStates> methodHeaderRule = rule.createNode(EShallowEntityType.METHOD, subtype, INameResolver.ofIndex(nameOffset)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASYNC, ETokenType.THROWS})).optionalSubRecognizer(this.createReturnTypeRecognizer());
        methodHeaderRule.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        methodHeaderRule.endNode();
    }

    private RecognizerBase<EGenericParserStates> createReturnTypeRecognizer() {
        return this.createRecognizer(start -> start.repeated(new ITokenMatcher[]{ETokenType.EOL}).sequence(new ITokenMatcher[]{ETokenType.ARROW}).optionalSubRecognizer(this.createIteratorRecognizer()).repeated(VALID_TYPE_TOKEN_TYPES));
    }

    private RecognizerBase<EGenericParserStates> createIteratorRecognizer() {
        return this.createRecognizer(start -> start.repeated(VALID_TYPE_TOKEN_TYPES).sequence(new ITokenMatcher[]{ETokenType.WHERE}).repeated(VALID_TYPE_TOKEN_TYPES).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ})).repeated(VALID_TYPE_TOKEN_TYPES));
    }

    private RecognizerBase<EGenericParserStates> createSubExpressionRecognizer() {
        return this.createRecognizer(start -> start.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).parseOnce(EGenericParserStates.IN_EXPRESSION));
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return super.isFilteredToken(token, previousToken) || previousToken != null && ETokenType.EOL.matches(previousToken) && ETokenType.EOL.matches(token);
    }
}

