/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ConnectedEntityCollector
extends ShallowEntityTraversalUtils.ShallowEntityVisitorBase {
    private final EShallowEntityType entityType;
    private final Predicate<ShallowEntity> entitySelector;
    private final List<LinkedHashSet<ShallowEntity>> connectionGroups = new ArrayList<LinkedHashSet<ShallowEntity>>();
    private final Stack<LinkedHashSet<ShallowEntity>> groupStack = new Stack();

    public ConnectedEntityCollector(EShallowEntityType entityType) {
        this(entityType, entity -> true);
    }

    public ConnectedEntityCollector(EShallowEntityType entityType, Predicate<ShallowEntity> entitySelector) {
        this.entityType = entityType;
        this.entitySelector = entitySelector;
    }

    public boolean visit(ShallowEntity entity) {
        if (entity.getType() == this.entityType && this.entitySelector.test(entity)) {
            this.groupStack.peek().add(entity);
        }
        if (entity.hasChildren()) {
            this.pushGroup();
        }
        return true;
    }

    public void endVisit(ShallowEntity entity) {
        if (entity.hasChildren()) {
            this.popGroup();
        }
    }

    private void pushGroup() {
        this.groupStack.push(new LinkedHashSet());
    }

    private void popGroup() {
        LinkedHashSet<ShallowEntity> group = this.groupStack.pop();
        if (!group.isEmpty()) {
            this.connectionGroups.add(group);
        }
    }

    public List<List<ShallowEntity>> getConnectedGroups(List<ShallowEntity> entities) {
        this.pushGroup();
        ShallowEntity.traverse(entities, (IShallowEntityVisitor)this);
        this.popGroup();
        return CollectionUtils.map(this.connectionGroups, set -> set.stream().collect(Collectors.toList()));
    }
}

