/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class TypeNameTokenCollection {
    private static final EnumSet<ETokenType> NON_SEPARATED_TOKENS = EnumSet.of(ETokenType.MULT, ETokenType.AND, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.QUESTION);
    private final List<IToken> typeNameTokens = new ArrayList<IToken>();
    private String separator = "";

    public void markPrimitive() {
        this.separator = " ";
    }

    public void addToken(IToken typeNameToken) {
        this.typeNameTokens.add(typeNameToken);
    }

    public String formatTypeName() {
        StringBuilder builder = new StringBuilder();
        for (int i = this.typeNameTokens.size() - 1; i >= 0; --i) {
            IToken token = this.typeNameTokens.get(i);
            if (i < this.typeNameTokens.size() - 1 && TypeNameTokenCollection.isSeparatedToken(token)) {
                builder.append(this.separator);
            }
            builder.append(token.getText());
        }
        return builder.toString();
    }

    public List<IToken> getTypeNameTokens() {
        return this.typeNameTokens;
    }

    private static boolean isSeparatedToken(IToken token) {
        return !NON_SEPARATED_TOKENS.contains(token.getType());
    }
}

