/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import com.google.common.collect.ImmutableSet;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TokenStreamTransformationPattern {
    private static final String VARIABLE_PREFIX = "$";
    private final List<IMatcher> matchers = new ArrayList<IMatcher>();
    private final List<IToken> replacementPatternTokens;
    private final ELanguage language;
    public static final int NO_MATCH = -1;
    private static final int NO_MATCH_UNTIL_END = -2;

    public TokenStreamTransformationPattern(String searchPatternString, String replacementPatternString, ELanguage language) throws ConQATException {
        List<IToken> searchPatternTokens = ScannerUtils.getTokens(searchPatternString, language, "##token stream transformation pattern##");
        this.createMatchers(searchPatternTokens);
        this.replacementPatternTokens = ScannerUtils.getTokens(replacementPatternString, language, "##token stream transformation pattern##");
        this.language = language;
    }

    private void createMatchers(List<IToken> searchPatternTokens) throws ConQATException {
        for (int i = 0; i < searchPatternTokens.size(); ++i) {
            IToken token = searchPatternTokens.get(i);
            String text = token.getText();
            ETokenType type = token.getType();
            if (type == ETokenType.IDENTIFIER && text.startsWith(VARIABLE_PREFIX)) {
                if (i + 1 < searchPatternTokens.size()) {
                    ETokenType endTokenType = searchPatternTokens.get(i + 1).getType();
                    this.matchers.add(new VariableMatcher(text, EnumSet.of(endTokenType, ETokenType.SEMICOLON)));
                    continue;
                }
                throw new ConQATException("The last token in the search pattern may not be a variable!");
            }
            this.matchers.add(new TokenTypeMatcher(type, text));
        }
    }

    private @Nullable Result apply(List<IToken> tokens, int position, Set<TokenStreamTransformationPattern> exhaustedPatterns) {
        HashMap<String, List<IToken>> variables = new HashMap<String, List<IToken>>();
        int matchedTokens = this.matchSearchPattern(tokens, position, variables);
        if (matchedTokens == -2) {
            exhaustedPatterns.add(this);
            return null;
        }
        if (matchedTokens == -1) {
            return null;
        }
        List<IToken> result = this.createResult(tokens.get(position), variables);
        return TokenStreamTransformationPattern.removeBlockIfCSharpOutIntroducesVariable(result, variables, matchedTokens);
    }

    private static @NonNull Result removeBlockIfCSharpOutIntroducesVariable(List<IToken> result, Map<String, List<IToken>> variables, int matchedTokens) {
        if (result.getFirst().getLanguage() == ELanguage.CS && TokenStreamTransformationPattern.surroundedWithBlock(result) && TokenStreamTransformationPattern.containsCSharpOutVariableIntroduction(variables.values())) {
            return new Result(result.subList(1, result.size() - 1), matchedTokens);
        }
        return new Result(result, matchedTokens);
    }

    private static boolean surroundedWithBlock(List<IToken> result) {
        return !result.isEmpty() && result.getFirst().getType() == ETokenType.LBRACE && result.getLast().getType() == ETokenType.RBRACE;
    }

    private static boolean containsCSharpOutVariableIntroduction(Collection<List<IToken>> variables) {
        return variables.stream().anyMatch(t -> IntStream.range(0, t.size() - 2).anyMatch(i -> ((IToken)t.get(i)).getType() == ETokenType.OUT && ((IToken)t.get(i + 2)).getType().getTokenClass() == ETokenType.ETokenClass.IDENTIFIER));
    }

    public static List<IToken> applyPatterns(List<IToken> tokens, List<TokenStreamTransformationPattern> patterns) {
        if (tokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ELanguage language = tokens.getFirst().getLanguage();
        ArrayList<IToken> transformedTokens = new ArrayList<IToken>();
        int position = 0;
        List<TokenStreamTransformationPattern> filteredPatterns = patterns.stream().filter(p -> p.checkIfTypeMatcherMatches(tokens)).toList();
        HashSet<TokenStreamTransformationPattern> exhaustedPatterns = new HashSet<TokenStreamTransformationPattern>();
        while (position < tokens.size()) {
            Result result = TokenStreamTransformationPattern.applyPatterns(language, tokens, filteredPatterns, position, exhaustedPatterns);
            if (result == null) {
                transformedTokens.add(tokens.get(position));
                ++position;
                continue;
            }
            transformedTokens.addAll(result.transformedTokens());
            position += result.matchedTokens();
        }
        return transformedTokens;
    }

    private static @Nullable Result applyPatterns(ELanguage language, List<IToken> tokens, List<TokenStreamTransformationPattern> patterns, int position, Set<TokenStreamTransformationPattern> exhaustedPatterns) {
        for (TokenStreamTransformationPattern pattern : patterns) {
            Result result;
            if (pattern.language != language || exhaustedPatterns.contains(pattern) || (result = pattern.apply(tokens, position, exhaustedPatterns)) == null) continue;
            return result;
        }
        return null;
    }

    private boolean checkIfTypeMatcherMatches(List<IToken> tokens) {
        for (IMatcher matcher : this.matchers) {
            TokenTypeMatcher tokenTypeMatcher;
            boolean matches;
            if (!(matcher instanceof TokenTypeMatcher) || (matches = (tokenTypeMatcher = (TokenTypeMatcher)matcher).hasAnyMatch(tokens))) continue;
            return false;
        }
        return true;
    }

    private int matchSearchPattern(List<IToken> tokens, int startPosition, Map<String, List<IToken>> variables) {
        int tokenPosition = startPosition;
        for (IMatcher matcher : this.matchers) {
            if (tokenPosition >= tokens.size()) {
                return -1;
            }
            int nextPosition = matcher.apply(tokens, tokenPosition, variables);
            if (nextPosition == -1) {
                return -1;
            }
            if (nextPosition == -2) {
                return -2;
            }
            CCSMAssert.isTrue((nextPosition > tokenPosition ? 1 : 0) != 0, (String)"Matcher did not advance token stream.");
            tokenPosition = nextPosition;
        }
        return tokenPosition - startPosition;
    }

    private List<IToken> createResult(IToken baseToken, Map<String, List<IToken>> variables) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (IToken token : this.replacementPatternTokens) {
            String text = token.getText();
            if (token.getType() == ETokenType.IDENTIFIER && text.startsWith(VARIABLE_PREFIX)) {
                List<IToken> variableMatch = variables.get(text);
                CCSMAssert.isNotNull(variableMatch, (String)("Variable " + text + " was not matched"));
                result.addAll(variableMatch);
                continue;
            }
            result.add(token.newToken(token.getType(), baseToken.getOffset(), baseToken.getLineNumber(), token.getText(), baseToken.getOriginId()));
        }
        return result;
    }

    public ELanguage getLanguage() {
        return this.language;
    }

    private static class VariableMatcher
    implements IMatcher {
        private static final Pattern MATCH_LENGTH_PATTERN = Pattern.compile("\\$[a-zA-Z]+([0-9]+)");
        private final String variableName;
        private final ImmutableSet<ETokenType> endTokenType;
        private final int numberOfTokensToMatch;
        private static final int NO_TOKEN_COUNT_LIMIT = -1;

        private VariableMatcher(String variableName, Set<ETokenType> endTokenType) {
            this.variableName = variableName;
            this.endTokenType = ImmutableSet.copyOf(endTokenType);
            Matcher matcher = MATCH_LENGTH_PATTERN.matcher(variableName);
            this.numberOfTokensToMatch = matcher.matches() ? Integer.parseInt(matcher.group(1)) : -1;
        }

        @Override
        public int apply(List<IToken> tokens, int position, Map<String, List<IToken>> variables) {
            int endIndex = TokenStreamUtils.findFirstTopLevel(tokens, position, ITokenMatcher.anyOfType(this.endTokenType), List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN));
            if (endIndex == -1) {
                return -2;
            }
            if (position == endIndex) {
                return -1;
            }
            if (this.numberOfTokensToMatch != -1 && endIndex > position + this.numberOfTokensToMatch) {
                endIndex = position + this.numberOfTokensToMatch;
            }
            variables.put(this.variableName, tokens.subList(position, endIndex));
            return endIndex;
        }

        public String toString() {
            return "VariableMatcher[variableName=" + this.variableName + ",endTokenType=" + String.valueOf(this.endTokenType) + "]";
        }
    }

    private record TokenTypeMatcher(ETokenType type, String text) implements IMatcher
    {
        @Override
        public int apply(List<IToken> tokens, int position, Map<String, List<IToken>> variables) {
            IToken token = tokens.get(position);
            if (token.getType() == this.type && token.getText().equals(this.text)) {
                return position + 1;
            }
            return -1;
        }

        private boolean hasAnyMatch(List<IToken> tokens) {
            IToken tokenByTypeAndText = TokenStreamUtils.getTokenByTypeAndText(tokens, this.text, Collections.singleton(this.type));
            return tokenByTypeAndText != null;
        }

        @Override
        public String toString() {
            return "TokenTypeMatcher[type=" + String.valueOf(this.type) + ",text=" + this.text + "]";
        }
    }

    private record Result(List<IToken> transformedTokens, int matchedTokens) {
    }

    private static interface IMatcher {
        public int apply(List<IToken> var1, int var2, Map<String, List<IToken>> var3);
    }
}

