/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.lang;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ToStringHelpers {
    public static MoreObjects.ToStringHelper toReflectiveStringHelper(Object self) {
        if (self == null) {
            return MoreObjects.toStringHelper((String)"null");
        }
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)self);
        Class<?> clazz = self.getClass();
        if (clazz.isArray()) {
            return ToStringHelpers.addArrayElements(helper, self);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            Object[] array = Iterables.toArray((Iterable)((Iterable)self), Object.class);
            return ToStringHelpers.addArrayElements(helper, array);
        }
        return ToStringHelpers.addInstanceFields(helper, self);
    }

    private static MoreObjects.ToStringHelper addArrayElements(MoreObjects.ToStringHelper helper, Object array) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            helper.addValue(element);
        }
        return helper;
    }

    private static MoreObjects.ToStringHelper addInstanceFields(MoreObjects.ToStringHelper helper, Object instance) {
        List<Field> allDeclaredFields = ToStringHelpers.getAllProperInstanceFields(instance);
        allDeclaredFields.sort(Comparator.comparing(Field::getName));
        for (Field field : allDeclaredFields) {
            try {
                field.setAccessible(true);
                String name = field.getName();
                Object value = field.get(instance);
                helper.add(name, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {}
        }
        return helper;
    }

    private static List<Field> getAllProperInstanceFields(Object instance) {
        ArrayList<Field> declaredFields = new ArrayList<Field>();
        Class<?> clazz = instance.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers())) continue;
                declaredFields.add(field);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return declaredFields;
    }
}

