/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class SimpleStatementCoverageProbe
extends CoverageProbeBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="executionCount")
    private int executionCount;

    @JsonCreator
    public SimpleStatementCoverageProbe(@JsonProperty(value="line") int line, @JsonProperty(value="executionCount") int executionCount) {
        super(line);
        this.executionCount = executionCount;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public String toString() {
        return "line " + this.getLine() + " executed " + this.executionCount + " times";
    }

    @Override
    @JsonIgnore
    public int getCoverableCount() {
        return 1;
    }

    @Override
    @JsonIgnore
    public int getCoveredCount() {
        if (this.executionCount > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean mergeWith(CoverageProbeBase otherProbe) {
        CCSMAssert.isInstanceOf((Object)otherProbe, SimpleStatementCoverageProbe.class);
        this.executionCount += ((SimpleStatementCoverageProbe)otherProbe).executionCount;
        return true;
    }
}

