/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.AbstractLongList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongSpliterators;

public interface LongList
extends LongCollection,
Comparable<List<? extends Long>>,
List<Long> {
    @Override
    public LongListIterator iterator();

    @Override
    default public LongSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractLongList.IndexBasedSpliterator(this, 0);
        }
        return LongSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public LongListIterator listIterator();

    public LongListIterator listIterator(int var1);

    public LongList subList(int var1, int var2);

    public void getElements(int var1, long[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(long[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, long[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, long[] a, int offset, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        LongArrays.ensureOffsetLength(a, offset, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        LongListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextLong();
            iter.set(a[offset + i++]);
        }
    }

    @Override
    public boolean add(long var1);

    @Override
    public void add(int var1, long var2);

    @Override
    @Deprecated
    default public void add(int index2, Long key) {
        this.add(index2, (long)key);
    }

    @Override
    public long set(int var1, long var2);

    default public void replaceAll(LongUnaryOperator operator) {
        LongListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            iter.set(operator.applyAsLong(iter.nextLong()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Long> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof LongUnaryOperator ? (LongUnaryOperator)((Object)operator) : operator::apply);
    }

    public long getLong(int var1);

    public int indexOf(long var1);

    public int lastIndexOf(long var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return LongCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Long get(int index2) {
        return this.getLong(index2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Long)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Long)o);
    }

    @Override
    @Deprecated
    default public boolean add(Long k) {
        return this.add((long)k);
    }

    public long removeLong(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return LongCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Long remove(int index2) {
        return this.removeLong(index2);
    }

    @Override
    @Deprecated
    default public Long set(int index2, Long k) {
        return this.set(index2, (long)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Long> comparator) {
        this.sort(LongComparators.asLongComparator(comparator));
    }

    default public void sort(LongComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            long[] elements = this.toLongArray();
            LongArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(LongComparator comparator) {
        long[] elements = this.toLongArray();
        if (comparator == null) {
            LongArrays.unstableSort(elements);
        } else {
            LongArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

