/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.naming.JsNameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "nameSuggestion", "Lorg/jetbrains/kotlin/js/naming/JsNameSuggestion;", "(Lorg/jetbrains/kotlin/js/naming/JsNameSuggestion;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Companion", "js.frontend"})
public final class JsBuiltinNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsNameSuggestion nameSuggestion;
    @JvmField
    @NotNull
    public static final Set<String> PROHIBITED_STATIC_NAMES;
    @JvmField
    @NotNull
    public static final Set<String> PROHIBITED_MEMBER_NAMES;

    public JsBuiltinNameClashChecker(@NotNull JsNameSuggestion nameSuggestion) {
        Intrinsics.checkNotNullParameter(nameSuggestion, "nameSuggestion");
        this.nameSuggestion = nameSuggestion;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return;
        }
        BindingContext bindingContext2 = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
        SuggestedName suggestedName = this.nameSuggestion.suggest(descriptor2, bindingContext2);
        Intrinsics.checkNotNull(suggestedName);
        SuggestedName suggestedName2 = suggestedName;
        if (!suggestedName2.getStable()) {
            return;
        }
        String simpleName2 = CollectionsKt.single(suggestedName2.getNames());
        if (descriptor2 instanceof ClassDescriptor) {
            if (PROHIBITED_STATIC_NAMES.contains(simpleName2)) {
                context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Function." + simpleName2));
            }
        } else if (descriptor2 instanceof CallableMemberDescriptor && PROHIBITED_MEMBER_NAMES.contains(simpleName2)) {
            context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Object.prototype." + simpleName2));
        }
    }

    static {
        String[] stringArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf(stringArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker$Companion;", "", "()V", "PROHIBITED_MEMBER_NAMES", "", "", "PROHIBITED_STATIC_NAMES", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

