/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client.utils;

import com.microsoft.alm.client.Messages;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.UUID;

public abstract class ArgumentUtility {
    public static final String EMPTY_UUID_STRING = "00000000-0000-0000-0000-000000000000";
    public static final UUID EMPTY_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static void checkForNull(Object var, String varName) {
        if (var == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ArgumentUtil.NullNotAllowedFormat"), varName));
        }
    }

    public static void checkStringForNullOrEmpty(String stringVar, String stringVarName) {
        ArgumentUtility.checkStringForNullOrEmpty(stringVar, stringVarName, false);
    }

    public static void checkStringForNullOrEmpty(String stringVar, String stringVarName, boolean trim) {
        ArgumentUtility.checkForNull(stringVar, stringVarName);
        if (trim) {
            stringVar = stringVar.trim();
        }
        if (stringVar.length() == 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ArgumentUtil.EmptyStringNotAllowedFormat"), stringVarName));
        }
    }

    public static void checkCollectionForNullOrEmpty(Collection<?> collection, String collectionName) {
        ArgumentUtility.checkForNull(collection, collectionName);
        if (collection.size() == 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ArgumentUtil.EmptyCollectionNotAllowedFormat"), collectionName));
        }
    }

    public static void checkForEmptyGuid(UUID guid, String varName) {
        ArgumentUtility.checkForNull(guid, varName);
        if (guid.equals(EMPTY_UUID)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ArgumentUtil.EmptyGuidNotAllowedFormat"), varName, EMPTY_UUID_STRING));
        }
    }
}

