/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.microsoft.alm.client.model.VssServiceException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;

public class JsonHelper {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final SimpleDateFormat dateFormat;

    public static DateFormat getDateFormat() {
        return dateFormat;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static Map<String, String> toQueryParametersMap(Object model) {
        ObjectMapper objectMapper = JsonHelper.getObjectMapper();
        try {
            return (Map)objectMapper.readValue(objectMapper.writeValueAsString(model), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw new VssServiceException(e.getMessage(), e);
        }
    }

    static {
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        objectMapper.setDateFormat((DateFormat)dateFormat);
    }
}

