/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.distributedtask.webapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskOrchestrationContainer;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskOrchestrationItem;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskOrchestrationItemType;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskOrchestrationJob;
import java.io.IOException;

public class TaskOrchestrationItemDeserializer
extends JsonDeserializer<TaskOrchestrationItem> {
    public TaskOrchestrationItem deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode itemTypeNode = rootNode.findValue("ItemType");
        if (itemTypeNode != null) {
            TaskOrchestrationItemType itemType = null;
            if (itemTypeNode.isInt() && itemTypeNode.asInt() == TaskOrchestrationItemType.CONTAINER.getValue()) {
                itemType = TaskOrchestrationItemType.CONTAINER;
            } else if (itemTypeNode.isInt() && itemTypeNode.asInt() == TaskOrchestrationItemType.JOB.getValue()) {
                itemType = TaskOrchestrationItemType.JOB;
            } else if (itemTypeNode.isTextual() && TaskOrchestrationItemType.CONTAINER.toString().equalsIgnoreCase(itemTypeNode.asText())) {
                itemType = TaskOrchestrationItemType.CONTAINER;
            } else if (itemTypeNode.isTextual() && TaskOrchestrationItemType.JOB.toString().equalsIgnoreCase(itemTypeNode.asText())) {
                itemType = TaskOrchestrationItemType.JOB;
            }
            if (TaskOrchestrationItemType.JOB == itemType) {
                return (TaskOrchestrationItem)rootNode.traverse((ObjectCodec)mapper).readValueAs(TaskOrchestrationJob.class);
            }
            if (TaskOrchestrationItemType.CONTAINER == itemType) {
                return (TaskOrchestrationItem)rootNode.traverse((ObjectCodec)mapper).readValueAs(TaskOrchestrationContainer.class);
            }
        }
        return null;
    }
}

