/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.testmanagement.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.AggregatedDataForResultTrend;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.BuildCoverage;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.BuildReference;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.CloneOperationInformation;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.CodeCoverageData;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.CodeCoverageSummary;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.CustomTestFieldDefinition;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.CustomTestFieldScope;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.PlanUpdateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.PointUpdateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.ReleaseReference;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.ResultDetails;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.ResultRetentionSettings;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.ResultsFilter;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.RunCreateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.RunUpdateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.SuiteCreateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.SuiteEntry;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.SuiteEntryUpdateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.SuiteTestCase;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.SuiteUpdateModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestActionResultModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestAttachment;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestAttachmentReference;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestAttachmentRequestModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestCaseResult;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestConfiguration;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestIterationDetailsModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestMessageLogDetails;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestPlan;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestPlanCloneRequest;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestPoint;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultHistory;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultParameterModel;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultSummary;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultTrendFilter;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultsContext;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultsDetails;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestResultsQuery;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestRun;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestRunCoverage;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestRunStatistic;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestSession;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestSessionSource;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestSettings;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestSuite;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestSuiteCloneRequest;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestSummaryForWorkItem;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestToWorkItemLinks;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.TestVariable;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.WorkItemReference;
import com.microsoft.alm.teamfoundation.testmanagement.webapi.WorkItemToTestLinks;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class TestHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TestHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ArrayList<TestActionResultModel> getActionResults(String project, int runId, int testCaseResultId, int iterationId, String actionPath) {
        UUID locationId = UUID.fromString("eaf40c31-ff84-4062-aafd-d5664be11a37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("actionPath", actionPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestActionResultModel>>(){});
    }

    public ArrayList<TestActionResultModel> getActionResults(UUID project, int runId, int testCaseResultId, int iterationId, String actionPath) {
        UUID locationId = UUID.fromString("eaf40c31-ff84-4062-aafd-d5664be11a37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("iterationId", iterationId);
        routeValues.put("actionPath", actionPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestActionResultModel>>(){});
    }

    public TestAttachmentReference createTestIterationResultAttachment(TestAttachmentRequestModel attachmentRequestModel, String project, int runId, int testCaseResultId, int iterationId, String actionPath) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("iterationId", String.valueOf(iterationId));
        queryParameters.addIfNotEmpty("actionPath", actionPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, attachmentRequestModel, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestAttachmentReference.class);
    }

    public TestAttachmentReference createTestIterationResultAttachment(TestAttachmentRequestModel attachmentRequestModel, UUID project, int runId, int testCaseResultId, int iterationId, String actionPath) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("iterationId", String.valueOf(iterationId));
        queryParameters.addIfNotEmpty("actionPath", actionPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, attachmentRequestModel, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestAttachmentReference.class);
    }

    public TestAttachmentReference createTestResultAttachment(TestAttachmentRequestModel attachmentRequestModel, String project, int runId, int testCaseResultId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, attachmentRequestModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestAttachmentReference.class);
    }

    public TestAttachmentReference createTestResultAttachment(TestAttachmentRequestModel attachmentRequestModel, UUID project, int runId, int testCaseResultId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, attachmentRequestModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestAttachmentReference.class);
    }

    public InputStream getTestResultAttachmentContent(String project, int runId, int testCaseResultId, int attachmentId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTestResultAttachmentContent(UUID project, int runId, int testCaseResultId, int attachmentId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<TestAttachment> getTestResultAttachments(String project, int runId, int testCaseResultId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestAttachment>>(){});
    }

    public ArrayList<TestAttachment> getTestResultAttachments(UUID project, int runId, int testCaseResultId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestAttachment>>(){});
    }

    public InputStream getTestResultAttachmentZip(String project, int runId, int testCaseResultId, int attachmentId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTestResultAttachmentZip(UUID project, int runId, int testCaseResultId, int attachmentId) {
        UUID locationId = UUID.fromString("2bffebe9-2f0f-4639-9af8-56129e9fed2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public TestAttachmentReference createTestRunAttachment(TestAttachmentRequestModel attachmentRequestModel, String project, int runId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, attachmentRequestModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestAttachmentReference.class);
    }

    public TestAttachmentReference createTestRunAttachment(TestAttachmentRequestModel attachmentRequestModel, UUID project, int runId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, attachmentRequestModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestAttachmentReference.class);
    }

    public InputStream getTestRunAttachmentContent(String project, int runId, int attachmentId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTestRunAttachmentContent(UUID project, int runId, int attachmentId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<TestAttachment> getTestRunAttachments(String project, int runId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestAttachment>>(){});
    }

    public ArrayList<TestAttachment> getTestRunAttachments(UUID project, int runId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestAttachment>>(){});
    }

    public InputStream getTestRunAttachmentZip(String project, int runId, int attachmentId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getTestRunAttachmentZip(UUID project, int runId, int attachmentId) {
        UUID locationId = UUID.fromString("4f004af4-a507-489c-9b13-cb62060beb11");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("attachmentId", attachmentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<WorkItemReference> getBugsLinkedToTestResult(String project, int runId, int testCaseResultId) {
        UUID locationId = UUID.fromString("6de20ca2-67de-4faf-97fa-38c5d585eb00");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemReference>>(){});
    }

    public ArrayList<WorkItemReference> getBugsLinkedToTestResult(UUID project, int runId, int testCaseResultId) {
        UUID locationId = UUID.fromString("6de20ca2-67de-4faf-97fa-38c5d585eb00");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemReference>>(){});
    }

    public CloneOperationInformation getCloneInformation(String project, int cloneOperationId, Boolean includeDetails) {
        UUID locationId = UUID.fromString("5b9d6320-abed-47a5-a151-cd6dc3798be6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("cloneOperationId", cloneOperationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$includeDetails", includeDetails);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, CloneOperationInformation.class);
    }

    public CloneOperationInformation getCloneInformation(UUID project, int cloneOperationId, Boolean includeDetails) {
        UUID locationId = UUID.fromString("5b9d6320-abed-47a5-a151-cd6dc3798be6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("cloneOperationId", cloneOperationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$includeDetails", includeDetails);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, CloneOperationInformation.class);
    }

    public CloneOperationInformation cloneTestPlan(TestPlanCloneRequest cloneRequestBody, String project, int planId) {
        UUID locationId = UUID.fromString("edc3ef4b-8460-4e86-86fa-8e4f5e9be831");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cloneRequestBody, "application/json", "application/json");
        return super.sendRequest(httpRequest, CloneOperationInformation.class);
    }

    public CloneOperationInformation cloneTestPlan(TestPlanCloneRequest cloneRequestBody, UUID project, int planId) {
        UUID locationId = UUID.fromString("edc3ef4b-8460-4e86-86fa-8e4f5e9be831");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cloneRequestBody, "application/json", "application/json");
        return super.sendRequest(httpRequest, CloneOperationInformation.class);
    }

    public CloneOperationInformation cloneTestSuite(TestSuiteCloneRequest cloneRequestBody, String project, int planId, int sourceSuiteId) {
        UUID locationId = UUID.fromString("751e4ab5-5bf6-4fb5-9d5d-19ef347662dd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("sourceSuiteId", sourceSuiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cloneRequestBody, "application/json", "application/json");
        return super.sendRequest(httpRequest, CloneOperationInformation.class);
    }

    public CloneOperationInformation cloneTestSuite(TestSuiteCloneRequest cloneRequestBody, UUID project, int planId, int sourceSuiteId) {
        UUID locationId = UUID.fromString("751e4ab5-5bf6-4fb5-9d5d-19ef347662dd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("sourceSuiteId", sourceSuiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, cloneRequestBody, "application/json", "application/json");
        return super.sendRequest(httpRequest, CloneOperationInformation.class);
    }

    public ArrayList<BuildCoverage> getBuildCodeCoverage(String project, int buildId, int flags) {
        UUID locationId = UUID.fromString("77560e8a-4e8c-4d59-894e-a5f264c24444");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.put("flags", String.valueOf(flags));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildCoverage>>(){});
    }

    public ArrayList<BuildCoverage> getBuildCodeCoverage(UUID project, int buildId, int flags) {
        UUID locationId = UUID.fromString("77560e8a-4e8c-4d59-894e-a5f264c24444");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.put("flags", String.valueOf(flags));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildCoverage>>(){});
    }

    public CodeCoverageSummary getCodeCoverageSummary(String project, int buildId, Integer deltaBuildId) {
        UUID locationId = UUID.fromString("77560e8a-4e8c-4d59-894e-a5f264c24444");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.addIfNotNull("deltaBuildId", deltaBuildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, CodeCoverageSummary.class);
    }

    public CodeCoverageSummary getCodeCoverageSummary(UUID project, int buildId, Integer deltaBuildId) {
        UUID locationId = UUID.fromString("77560e8a-4e8c-4d59-894e-a5f264c24444");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.addIfNotNull("deltaBuildId", deltaBuildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, CodeCoverageSummary.class);
    }

    public void updateCodeCoverageSummary(CodeCoverageData coverageData, String project, int buildId) {
        UUID locationId = UUID.fromString("77560e8a-4e8c-4d59-894e-a5f264c24444");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, coverageData, "application/json", queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void updateCodeCoverageSummary(CodeCoverageData coverageData, UUID project, int buildId) {
        UUID locationId = UUID.fromString("77560e8a-4e8c-4d59-894e-a5f264c24444");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, coverageData, "application/json", queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<TestRunCoverage> getTestRunCodeCoverage(String project, int runId, int flags) {
        UUID locationId = UUID.fromString("9629116f-3b89-4ed8-b358-d4694efda160");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("flags", String.valueOf(flags));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestRunCoverage>>(){});
    }

    public ArrayList<TestRunCoverage> getTestRunCodeCoverage(UUID project, int runId, int flags) {
        UUID locationId = UUID.fromString("9629116f-3b89-4ed8-b358-d4694efda160");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("flags", String.valueOf(flags));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestRunCoverage>>(){});
    }

    public TestConfiguration createTestConfiguration(TestConfiguration testConfiguration, String project) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testConfiguration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestConfiguration.class);
    }

    public TestConfiguration createTestConfiguration(TestConfiguration testConfiguration, UUID project) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testConfiguration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestConfiguration.class);
    }

    public void deleteTestConfiguration(String project, int testConfigurationId) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testConfigurationId", testConfigurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTestConfiguration(UUID project, int testConfigurationId) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testConfigurationId", testConfigurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TestConfiguration getTestConfigurationById(String project, int testConfigurationId) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testConfigurationId", testConfigurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestConfiguration.class);
    }

    public TestConfiguration getTestConfigurationById(UUID project, int testConfigurationId) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testConfigurationId", testConfigurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestConfiguration.class);
    }

    public ArrayList<TestConfiguration> getTestConfigurations(String project, Integer skip, Integer top, Boolean includeAllProperties) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeAllProperties", includeAllProperties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestConfiguration>>(){});
    }

    public ArrayList<TestConfiguration> getTestConfigurations(UUID project, Integer skip, Integer top, Boolean includeAllProperties) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeAllProperties", includeAllProperties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestConfiguration>>(){});
    }

    public TestConfiguration updateTestConfiguration(TestConfiguration testConfiguration, String project, int testConfigurationId) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testConfigurationId", testConfigurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testConfiguration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestConfiguration.class);
    }

    public TestConfiguration updateTestConfiguration(TestConfiguration testConfiguration, UUID project, int testConfigurationId) {
        UUID locationId = UUID.fromString("d667591b-b9fd-4263-997a-9a084cca848f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testConfigurationId", testConfigurationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testConfiguration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestConfiguration.class);
    }

    public ArrayList<CustomTestFieldDefinition> addCustomFields(CustomTestFieldDefinition[] newFields, String project) {
        UUID locationId = UUID.fromString("8ce1923b-f4c7-4e22-b93b-f6284e525ec2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, newFields, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<CustomTestFieldDefinition>>(){});
    }

    public ArrayList<CustomTestFieldDefinition> addCustomFields(CustomTestFieldDefinition[] newFields, UUID project) {
        UUID locationId = UUID.fromString("8ce1923b-f4c7-4e22-b93b-f6284e525ec2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, newFields, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<CustomTestFieldDefinition>>(){});
    }

    public ArrayList<CustomTestFieldDefinition> queryCustomFields(String project, CustomTestFieldScope scopeFilter) {
        UUID locationId = UUID.fromString("8ce1923b-f4c7-4e22-b93b-f6284e525ec2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("scopeFilter", scopeFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<CustomTestFieldDefinition>>(){});
    }

    public ArrayList<CustomTestFieldDefinition> queryCustomFields(UUID project, CustomTestFieldScope scopeFilter) {
        UUID locationId = UUID.fromString("8ce1923b-f4c7-4e22-b93b-f6284e525ec2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("scopeFilter", scopeFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<CustomTestFieldDefinition>>(){});
    }

    public TestResultHistory queryTestResultHistory(ResultsFilter filter, String project) {
        UUID locationId = UUID.fromString("234616f5-429c-4e7b-9192-affd76731dfd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, filter, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestResultHistory.class);
    }

    public TestResultHistory queryTestResultHistory(ResultsFilter filter, UUID project) {
        UUID locationId = UUID.fromString("234616f5-429c-4e7b-9192-affd76731dfd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, filter, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestResultHistory.class);
    }

    public TestIterationDetailsModel getTestIteration(String project, int runId, int testCaseResultId, int iterationId, Boolean includeActionResults) {
        UUID locationId = UUID.fromString("73eb9074-3446-4c44-8296-2f811950ff8d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeActionResults", includeActionResults);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestIterationDetailsModel.class);
    }

    public TestIterationDetailsModel getTestIteration(UUID project, int runId, int testCaseResultId, int iterationId, Boolean includeActionResults) {
        UUID locationId = UUID.fromString("73eb9074-3446-4c44-8296-2f811950ff8d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeActionResults", includeActionResults);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestIterationDetailsModel.class);
    }

    public ArrayList<TestIterationDetailsModel> getTestIterations(String project, int runId, int testCaseResultId, Boolean includeActionResults) {
        UUID locationId = UUID.fromString("73eb9074-3446-4c44-8296-2f811950ff8d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeActionResults", includeActionResults);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestIterationDetailsModel>>(){});
    }

    public ArrayList<TestIterationDetailsModel> getTestIterations(UUID project, int runId, int testCaseResultId, Boolean includeActionResults) {
        UUID locationId = UUID.fromString("73eb9074-3446-4c44-8296-2f811950ff8d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeActionResults", includeActionResults);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestIterationDetailsModel>>(){});
    }

    public ArrayList<TestMessageLogDetails> getTestRunLogs(String project, int runId) {
        UUID locationId = UUID.fromString("a1e55200-637e-42e9-a7c0-7e5bfdedb1b3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestMessageLogDetails>>(){});
    }

    public ArrayList<TestMessageLogDetails> getTestRunLogs(UUID project, int runId) {
        UUID locationId = UUID.fromString("a1e55200-637e-42e9-a7c0-7e5bfdedb1b3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestMessageLogDetails>>(){});
    }

    public ArrayList<TestResultParameterModel> getResultParameters(String project, int runId, int testCaseResultId, int iterationId, String paramName) {
        UUID locationId = UUID.fromString("7c69810d-3354-4af3-844a-180bd25db08a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("paramName", paramName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestResultParameterModel>>(){});
    }

    public ArrayList<TestResultParameterModel> getResultParameters(UUID project, int runId, int testCaseResultId, int iterationId, String paramName) {
        UUID locationId = UUID.fromString("7c69810d-3354-4af3-844a-180bd25db08a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        routeValues.put("iterationId", iterationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("paramName", paramName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestResultParameterModel>>(){});
    }

    public TestPlan createTestPlan(PlanUpdateModel testPlan, String project) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testPlan, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestPlan.class);
    }

    public TestPlan createTestPlan(PlanUpdateModel testPlan, UUID project) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testPlan, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestPlan.class);
    }

    public void deleteTestPlan(String project, int planId) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTestPlan(UUID project, int planId) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TestPlan getPlanById(String project, int planId) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestPlan.class);
    }

    public TestPlan getPlanById(UUID project, int planId) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestPlan.class);
    }

    public ArrayList<TestPlan> getPlans(String project, String owner, Integer skip, Integer top, Boolean includePlanDetails, Boolean filterActivePlans) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("owner", owner);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includePlanDetails", includePlanDetails);
        queryParameters.addIfNotNull("filterActivePlans", filterActivePlans);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestPlan>>(){});
    }

    public ArrayList<TestPlan> getPlans(UUID project, String owner, Integer skip, Integer top, Boolean includePlanDetails, Boolean filterActivePlans) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("owner", owner);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includePlanDetails", includePlanDetails);
        queryParameters.addIfNotNull("filterActivePlans", filterActivePlans);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestPlan>>(){});
    }

    public TestPlan updateTestPlan(PlanUpdateModel planUpdateModel, String project, int planId) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, planUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestPlan.class);
    }

    public TestPlan updateTestPlan(PlanUpdateModel planUpdateModel, UUID project, int planId) {
        UUID locationId = UUID.fromString("51712106-7278-4208-8563-1c96f40cf5e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, planUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestPlan.class);
    }

    public TestPoint getPoint(String project, int planId, int suiteId, int pointIds, String witFields) {
        UUID locationId = UUID.fromString("3bcfd5c8-be62-488e-b1da-b8289ce9299c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("pointIds", pointIds);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("witFields", witFields);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestPoint.class);
    }

    public TestPoint getPoint(UUID project, int planId, int suiteId, int pointIds, String witFields) {
        UUID locationId = UUID.fromString("3bcfd5c8-be62-488e-b1da-b8289ce9299c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("pointIds", pointIds);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("witFields", witFields);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestPoint.class);
    }

    public ArrayList<TestPoint> getPoints(String project, int planId, int suiteId, String witFields, String configurationId, String testCaseId, String testPointIds, Boolean includePointDetails, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("3bcfd5c8-be62-488e-b1da-b8289ce9299c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("witFields", witFields);
        queryParameters.addIfNotEmpty("configurationId", configurationId);
        queryParameters.addIfNotEmpty("testCaseId", testCaseId);
        queryParameters.addIfNotEmpty("testPointIds", testPointIds);
        queryParameters.addIfNotNull("includePointDetails", includePointDetails);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestPoint>>(){});
    }

    public ArrayList<TestPoint> getPoints(UUID project, int planId, int suiteId, String witFields, String configurationId, String testCaseId, String testPointIds, Boolean includePointDetails, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("3bcfd5c8-be62-488e-b1da-b8289ce9299c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("witFields", witFields);
        queryParameters.addIfNotEmpty("configurationId", configurationId);
        queryParameters.addIfNotEmpty("testCaseId", testCaseId);
        queryParameters.addIfNotEmpty("testPointIds", testPointIds);
        queryParameters.addIfNotNull("includePointDetails", includePointDetails);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestPoint>>(){});
    }

    public ArrayList<TestPoint> updateTestPoints(PointUpdateModel pointUpdateModel, String project, int planId, int suiteId, String pointIds) {
        UUID locationId = UUID.fromString("3bcfd5c8-be62-488e-b1da-b8289ce9299c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("pointIds", pointIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, pointUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestPoint>>(){});
    }

    public ArrayList<TestPoint> updateTestPoints(PointUpdateModel pointUpdateModel, UUID project, int planId, int suiteId, String pointIds) {
        UUID locationId = UUID.fromString("3bcfd5c8-be62-488e-b1da-b8289ce9299c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("pointIds", pointIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, pointUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestPoint>>(){});
    }

    public TestResultsDetails getTestResultDetailsForBuild(String project, int buildId, String publishContext, String groupBy, String filter, String orderby) {
        UUID locationId = UUID.fromString("efb387b0-10d5-42e7-be40-95e06ee9430f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotEmpty("groupBy", groupBy);
        queryParameters.addIfNotEmpty("$filter", filter);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultsDetails.class);
    }

    public TestResultsDetails getTestResultDetailsForBuild(UUID project, int buildId, String publishContext, String groupBy, String filter, String orderby) {
        UUID locationId = UUID.fromString("efb387b0-10d5-42e7-be40-95e06ee9430f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotEmpty("groupBy", groupBy);
        queryParameters.addIfNotEmpty("$filter", filter);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultsDetails.class);
    }

    public TestResultsDetails getTestResultDetailsForRelease(String project, int releaseId, int releaseEnvId, String publishContext, String groupBy, String filter, String orderby) {
        UUID locationId = UUID.fromString("b834ec7e-35bb-450f-a3c8-802e70ca40dd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("releaseId", String.valueOf(releaseId));
        queryParameters.put("releaseEnvId", String.valueOf(releaseEnvId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotEmpty("groupBy", groupBy);
        queryParameters.addIfNotEmpty("$filter", filter);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultsDetails.class);
    }

    public TestResultsDetails getTestResultDetailsForRelease(UUID project, int releaseId, int releaseEnvId, String publishContext, String groupBy, String filter, String orderby) {
        UUID locationId = UUID.fromString("b834ec7e-35bb-450f-a3c8-802e70ca40dd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("releaseId", String.valueOf(releaseId));
        queryParameters.put("releaseEnvId", String.valueOf(releaseEnvId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotEmpty("groupBy", groupBy);
        queryParameters.addIfNotEmpty("$filter", filter);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultsDetails.class);
    }

    public ResultRetentionSettings getResultRetentionSettings(String project) {
        UUID locationId = UUID.fromString("a3206d9e-fa8d-42d3-88cb-f75c51e69cde");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ResultRetentionSettings.class);
    }

    public ResultRetentionSettings getResultRetentionSettings(UUID project) {
        UUID locationId = UUID.fromString("a3206d9e-fa8d-42d3-88cb-f75c51e69cde");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ResultRetentionSettings.class);
    }

    public ResultRetentionSettings updateResultRetentionSettings(ResultRetentionSettings retentionSettings, String project) {
        UUID locationId = UUID.fromString("a3206d9e-fa8d-42d3-88cb-f75c51e69cde");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, retentionSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, ResultRetentionSettings.class);
    }

    public ResultRetentionSettings updateResultRetentionSettings(ResultRetentionSettings retentionSettings, UUID project) {
        UUID locationId = UUID.fromString("a3206d9e-fa8d-42d3-88cb-f75c51e69cde");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, retentionSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, ResultRetentionSettings.class);
    }

    public ArrayList<TestCaseResult> addTestResultsToTestRun(TestCaseResult[] results, String project, int runId) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, results, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestCaseResult>>(){});
    }

    public ArrayList<TestCaseResult> addTestResultsToTestRun(TestCaseResult[] results, UUID project, int runId) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, results, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestCaseResult>>(){});
    }

    public TestCaseResult getTestResultById(String project, int runId, int testCaseResultId, ResultDetails detailsToInclude) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("detailsToInclude", detailsToInclude);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestCaseResult.class);
    }

    public TestCaseResult getTestResultById(UUID project, int runId, int testCaseResultId, ResultDetails detailsToInclude) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        routeValues.put("testCaseResultId", testCaseResultId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("detailsToInclude", detailsToInclude);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestCaseResult.class);
    }

    public ArrayList<TestCaseResult> getTestResults(String project, int runId, ResultDetails detailsToInclude, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("detailsToInclude", detailsToInclude);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestCaseResult>>(){});
    }

    public ArrayList<TestCaseResult> getTestResults(UUID project, int runId, ResultDetails detailsToInclude, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("detailsToInclude", detailsToInclude);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestCaseResult>>(){});
    }

    public ArrayList<TestCaseResult> updateTestResults(TestCaseResult[] results, String project, int runId) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, results, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestCaseResult>>(){});
    }

    public ArrayList<TestCaseResult> updateTestResults(TestCaseResult[] results, UUID project, int runId) {
        UUID locationId = UUID.fromString("4637d869-3a76-4468-8057-0bb02aa385cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, results, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestCaseResult>>(){});
    }

    public TestResultsQuery getTestResultsByQuery(TestResultsQuery query, String project) {
        UUID locationId = UUID.fromString("6711da49-8e6f-4d35-9f73-cef7a3c81a5b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, query, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestResultsQuery.class);
    }

    public TestResultsQuery getTestResultsByQuery(TestResultsQuery query, UUID project) {
        UUID locationId = UUID.fromString("6711da49-8e6f-4d35-9f73-cef7a3c81a5b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.4");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, query, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestResultsQuery.class);
    }

    public TestResultSummary queryTestResultsReportForBuild(String project, int buildId, String publishContext, Boolean includeFailureDetails, BuildReference buildToCompare) {
        UUID locationId = UUID.fromString("000ef77b-fea2-498d-a10d-ad1a037f559f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotNull("includeFailureDetails", includeFailureDetails);
        this.addModelAsQueryParams(queryParameters, buildToCompare);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultSummary.class);
    }

    public TestResultSummary queryTestResultsReportForBuild(UUID project, int buildId, String publishContext, Boolean includeFailureDetails, BuildReference buildToCompare) {
        UUID locationId = UUID.fromString("000ef77b-fea2-498d-a10d-ad1a037f559f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("buildId", String.valueOf(buildId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotNull("includeFailureDetails", includeFailureDetails);
        this.addModelAsQueryParams(queryParameters, buildToCompare);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultSummary.class);
    }

    public TestResultSummary queryTestResultsReportForRelease(String project, int releaseId, int releaseEnvId, String publishContext, Boolean includeFailureDetails, ReleaseReference releaseToCompare) {
        UUID locationId = UUID.fromString("85765790-ac68-494e-b268-af36c3929744");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("releaseId", String.valueOf(releaseId));
        queryParameters.put("releaseEnvId", String.valueOf(releaseEnvId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotNull("includeFailureDetails", includeFailureDetails);
        this.addModelAsQueryParams(queryParameters, releaseToCompare);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultSummary.class);
    }

    public TestResultSummary queryTestResultsReportForRelease(UUID project, int releaseId, int releaseEnvId, String publishContext, Boolean includeFailureDetails, ReleaseReference releaseToCompare) {
        UUID locationId = UUID.fromString("85765790-ac68-494e-b268-af36c3929744");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("releaseId", String.valueOf(releaseId));
        queryParameters.put("releaseEnvId", String.valueOf(releaseEnvId));
        queryParameters.addIfNotEmpty("publishContext", publishContext);
        queryParameters.addIfNotNull("includeFailureDetails", includeFailureDetails);
        this.addModelAsQueryParams(queryParameters, releaseToCompare);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestResultSummary.class);
    }

    public ArrayList<TestResultSummary> queryTestResultsSummaryForReleases(List<ReleaseReference> releases, String project) {
        UUID locationId = UUID.fromString("85765790-ac68-494e-b268-af36c3929744");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, releases, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestResultSummary>>(){});
    }

    public ArrayList<TestResultSummary> queryTestResultsSummaryForReleases(List<ReleaseReference> releases, UUID project) {
        UUID locationId = UUID.fromString("85765790-ac68-494e-b268-af36c3929744");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, releases, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestResultSummary>>(){});
    }

    public ArrayList<TestSummaryForWorkItem> queryTestSummaryByRequirement(TestResultsContext resultsContext, String project, List<Integer> workItemIds) {
        UUID locationId = UUID.fromString("cd08294e-308d-4460-a46e-4cfdefba0b4b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("workItemIds", workItemIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, resultsContext, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSummaryForWorkItem>>(){});
    }

    public ArrayList<TestSummaryForWorkItem> queryTestSummaryByRequirement(TestResultsContext resultsContext, UUID project, List<Integer> workItemIds) {
        UUID locationId = UUID.fromString("cd08294e-308d-4460-a46e-4cfdefba0b4b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("workItemIds", workItemIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, resultsContext, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSummaryForWorkItem>>(){});
    }

    public ArrayList<AggregatedDataForResultTrend> queryResultTrendForBuild(TestResultTrendFilter filter, String project) {
        UUID locationId = UUID.fromString("fbc82a85-0786-4442-88bb-eb0fda6b01b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, filter, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AggregatedDataForResultTrend>>(){});
    }

    public ArrayList<AggregatedDataForResultTrend> queryResultTrendForBuild(TestResultTrendFilter filter, UUID project) {
        UUID locationId = UUID.fromString("fbc82a85-0786-4442-88bb-eb0fda6b01b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, filter, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AggregatedDataForResultTrend>>(){});
    }

    public TestRunStatistic getTestRunStatistics(String project, int runId) {
        UUID locationId = UUID.fromString("0a42c424-d764-4a16-a2d5-5c85f87d0ae8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestRunStatistic.class);
    }

    public TestRunStatistic getTestRunStatistics(UUID project, int runId) {
        UUID locationId = UUID.fromString("0a42c424-d764-4a16-a2d5-5c85f87d0ae8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestRunStatistic.class);
    }

    public TestRun createTestRun(RunCreateModel testRun, String project) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testRun, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestRun.class);
    }

    public TestRun createTestRun(RunCreateModel testRun, UUID project) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testRun, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestRun.class);
    }

    public void deleteTestRun(String project, int runId) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTestRun(UUID project, int runId) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TestRun getTestRunById(String project, int runId) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestRun.class);
    }

    public TestRun getTestRunById(UUID project, int runId) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestRun.class);
    }

    public ArrayList<TestRun> getTestRuns(String project, String buildUri, String owner, String tmiRunId, Integer planId, Boolean includeRunDetails, Boolean automated, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("buildUri", buildUri);
        queryParameters.addIfNotEmpty("owner", owner);
        queryParameters.addIfNotEmpty("tmiRunId", tmiRunId);
        queryParameters.addIfNotNull("planId", planId);
        queryParameters.addIfNotNull("includeRunDetails", includeRunDetails);
        queryParameters.addIfNotNull("automated", automated);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestRun>>(){});
    }

    public ArrayList<TestRun> getTestRuns(UUID project, String buildUri, String owner, String tmiRunId, Integer planId, Boolean includeRunDetails, Boolean automated, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("buildUri", buildUri);
        queryParameters.addIfNotEmpty("owner", owner);
        queryParameters.addIfNotEmpty("tmiRunId", tmiRunId);
        queryParameters.addIfNotNull("planId", planId);
        queryParameters.addIfNotNull("includeRunDetails", includeRunDetails);
        queryParameters.addIfNotNull("automated", automated);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestRun>>(){});
    }

    public TestRun updateTestRun(RunUpdateModel runUpdateModel, String project, int runId) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, runUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestRun.class);
    }

    public TestRun updateTestRun(RunUpdateModel runUpdateModel, UUID project, int runId) {
        UUID locationId = UUID.fromString("cadb3810-d47d-4a3c-a234-fe5f3be50138");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("runId", runId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, runUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestRun.class);
    }

    public TestSession createTestSession(TestSession testSession, String project) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public TestSession createTestSession(TestSession testSession, UUID project) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public TestSession createTestSession(TestSession testSession, String project, String team) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public TestSession createTestSession(TestSession testSession, UUID project, UUID team) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public ArrayList<TestSession> getTestSessions(String project, String team, Integer period, Boolean allSessions, Boolean includeAllProperties, TestSessionSource source, Boolean includeOnlyCompletedSessions) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("period", period);
        queryParameters.addIfNotNull("allSessions", allSessions);
        queryParameters.addIfNotNull("includeAllProperties", includeAllProperties);
        queryParameters.addIfNotNull("source", source);
        queryParameters.addIfNotNull("includeOnlyCompletedSessions", includeOnlyCompletedSessions);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSession>>(){});
    }

    public ArrayList<TestSession> getTestSessions(UUID project, UUID team, Integer period, Boolean allSessions, Boolean includeAllProperties, TestSessionSource source, Boolean includeOnlyCompletedSessions) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("period", period);
        queryParameters.addIfNotNull("allSessions", allSessions);
        queryParameters.addIfNotNull("includeAllProperties", includeAllProperties);
        queryParameters.addIfNotNull("source", source);
        queryParameters.addIfNotNull("includeOnlyCompletedSessions", includeOnlyCompletedSessions);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSession>>(){});
    }

    public ArrayList<TestSession> getTestSessions(String project, Integer period, Boolean allSessions, Boolean includeAllProperties, TestSessionSource source, Boolean includeOnlyCompletedSessions) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("period", period);
        queryParameters.addIfNotNull("allSessions", allSessions);
        queryParameters.addIfNotNull("includeAllProperties", includeAllProperties);
        queryParameters.addIfNotNull("source", source);
        queryParameters.addIfNotNull("includeOnlyCompletedSessions", includeOnlyCompletedSessions);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSession>>(){});
    }

    public ArrayList<TestSession> getTestSessions(UUID project, Integer period, Boolean allSessions, Boolean includeAllProperties, TestSessionSource source, Boolean includeOnlyCompletedSessions) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("period", period);
        queryParameters.addIfNotNull("allSessions", allSessions);
        queryParameters.addIfNotNull("includeAllProperties", includeAllProperties);
        queryParameters.addIfNotNull("source", source);
        queryParameters.addIfNotNull("includeOnlyCompletedSessions", includeOnlyCompletedSessions);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSession>>(){});
    }

    public TestSession updateTestSession(TestSession testSession, String project) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public TestSession updateTestSession(TestSession testSession, UUID project) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public TestSession updateTestSession(TestSession testSession, String project, String team) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public TestSession updateTestSession(TestSession testSession, UUID project, UUID team) {
        UUID locationId = UUID.fromString("1500b4b4-6c69-4ca6-9b18-35e9e97fe2ac");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testSession, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSession.class);
    }

    public ArrayList<SuiteEntry> getSuiteEntries(String project, int suiteId) {
        UUID locationId = UUID.fromString("bf8b7f78-0c1f-49cb-89e9-d1a17bcaaad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteEntry>>(){});
    }

    public ArrayList<SuiteEntry> getSuiteEntries(UUID project, int suiteId) {
        UUID locationId = UUID.fromString("bf8b7f78-0c1f-49cb-89e9-d1a17bcaaad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteEntry>>(){});
    }

    public ArrayList<SuiteEntry> reorderSuiteEntries(List<SuiteEntryUpdateModel> suiteEntries, String project, int suiteId) {
        UUID locationId = UUID.fromString("bf8b7f78-0c1f-49cb-89e9-d1a17bcaaad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, suiteEntries, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteEntry>>(){});
    }

    public ArrayList<SuiteEntry> reorderSuiteEntries(List<SuiteEntryUpdateModel> suiteEntries, UUID project, int suiteId) {
        UUID locationId = UUID.fromString("bf8b7f78-0c1f-49cb-89e9-d1a17bcaaad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, suiteEntries, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteEntry>>(){});
    }

    public ArrayList<SuiteTestCase> addTestCasesToSuite(String project, int planId, int suiteId, String testCaseIds) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("testCaseIds", testCaseIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteTestCase>>(){});
    }

    public ArrayList<SuiteTestCase> addTestCasesToSuite(UUID project, int planId, int suiteId, String testCaseIds) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("testCaseIds", testCaseIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteTestCase>>(){});
    }

    public SuiteTestCase getTestCaseById(String project, int planId, int suiteId, int testCaseIds) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("testCaseIds", testCaseIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, SuiteTestCase.class);
    }

    public SuiteTestCase getTestCaseById(UUID project, int planId, int suiteId, int testCaseIds) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("testCaseIds", testCaseIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, SuiteTestCase.class);
    }

    public ArrayList<SuiteTestCase> getTestCases(String project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteTestCase>>(){});
    }

    public ArrayList<SuiteTestCase> getTestCases(UUID project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SuiteTestCase>>(){});
    }

    public void removeTestCasesFromSuiteUrl(String project, int planId, int suiteId, String testCaseIds) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("testCaseIds", testCaseIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void removeTestCasesFromSuiteUrl(UUID project, int planId, int suiteId, String testCaseIds) {
        UUID locationId = UUID.fromString("a4a1ec1c-b03f-41ca-8857-704594ecf58e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        routeValues.put("testCaseIds", testCaseIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<TestSuite> createTestSuite(SuiteCreateModel testSuite, String project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSuite, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSuite>>(){});
    }

    public ArrayList<TestSuite> createTestSuite(SuiteCreateModel testSuite, UUID project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSuite, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSuite>>(){});
    }

    public void deleteTestSuite(String project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTestSuite(UUID project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TestSuite getTestSuiteById(String project, int planId, int suiteId, Boolean includeChildSuites) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeChildSuites", includeChildSuites);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestSuite.class);
    }

    public TestSuite getTestSuiteById(UUID project, int planId, int suiteId, Boolean includeChildSuites) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeChildSuites", includeChildSuites);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestSuite.class);
    }

    public ArrayList<TestSuite> getTestSuitesForPlan(String project, int planId, Boolean includeSuites, Integer skip, Integer top, Boolean asTreeView) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeSuites", includeSuites);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$asTreeView", asTreeView);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSuite>>(){});
    }

    public ArrayList<TestSuite> getTestSuitesForPlan(UUID project, int planId, Boolean includeSuites, Integer skip, Integer top, Boolean asTreeView) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeSuites", includeSuites);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$asTreeView", asTreeView);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSuite>>(){});
    }

    public TestSuite updateTestSuite(SuiteUpdateModel suiteUpdateModel, String project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, suiteUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSuite.class);
    }

    public TestSuite updateTestSuite(SuiteUpdateModel suiteUpdateModel, UUID project, int planId, int suiteId) {
        UUID locationId = UUID.fromString("7b7619a0-cb54-4ab3-bf22-194056f45dd1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("planId", planId);
        routeValues.put("suiteId", suiteId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, suiteUpdateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestSuite.class);
    }

    public ArrayList<TestSuite> getSuitesByTestCaseId(int testCaseId) {
        UUID locationId = UUID.fromString("09a6167b-e969-4775-9247-b94cf3819caf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("testCaseId", String.valueOf(testCaseId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestSuite>>(){});
    }

    public int createTestSettings(TestSettings testSettings, String project) {
        UUID locationId = UUID.fromString("8133ce14-962f-42af-a5f9-6aa9defcb9c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, Integer.TYPE);
    }

    public int createTestSettings(TestSettings testSettings, UUID project) {
        UUID locationId = UUID.fromString("8133ce14-962f-42af-a5f9-6aa9defcb9c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, Integer.TYPE);
    }

    public void deleteTestSettings(String project, int testSettingsId) {
        UUID locationId = UUID.fromString("8133ce14-962f-42af-a5f9-6aa9defcb9c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testSettingsId", testSettingsId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTestSettings(UUID project, int testSettingsId) {
        UUID locationId = UUID.fromString("8133ce14-962f-42af-a5f9-6aa9defcb9c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testSettingsId", testSettingsId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TestSettings getTestSettingsById(String project, int testSettingsId) {
        UUID locationId = UUID.fromString("8133ce14-962f-42af-a5f9-6aa9defcb9c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testSettingsId", testSettingsId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestSettings.class);
    }

    public TestSettings getTestSettingsById(UUID project, int testSettingsId) {
        UUID locationId = UUID.fromString("8133ce14-962f-42af-a5f9-6aa9defcb9c8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testSettingsId", testSettingsId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestSettings.class);
    }

    public TestVariable createTestVariable(TestVariable testVariable, String project) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testVariable, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestVariable.class);
    }

    public TestVariable createTestVariable(TestVariable testVariable, UUID project) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, testVariable, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestVariable.class);
    }

    public void deleteTestVariable(String project, int testVariableId) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testVariableId", testVariableId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTestVariable(UUID project, int testVariableId) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testVariableId", testVariableId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TestVariable getTestVariableById(String project, int testVariableId) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testVariableId", testVariableId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestVariable.class);
    }

    public TestVariable getTestVariableById(UUID project, int testVariableId) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testVariableId", testVariableId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TestVariable.class);
    }

    public ArrayList<TestVariable> getTestVariables(String project, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestVariable>>(){});
    }

    public ArrayList<TestVariable> getTestVariables(UUID project, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TestVariable>>(){});
    }

    public TestVariable updateTestVariable(TestVariable testVariable, String project, int testVariableId) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testVariableId", testVariableId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testVariable, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestVariable.class);
    }

    public TestVariable updateTestVariable(TestVariable testVariable, UUID project, int testVariableId) {
        UUID locationId = UUID.fromString("be3fcb2b-995b-47bf-90e5-ca3cf9980912");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("testVariableId", testVariableId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, testVariable, "application/json", "application/json");
        return super.sendRequest(httpRequest, TestVariable.class);
    }

    public WorkItemToTestLinks addWorkItemToTestLinks(WorkItemToTestLinks workItemToTestLinks, String project) {
        UUID locationId = UUID.fromString("371b1655-ce05-412e-a113-64cc77bb78d2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, workItemToTestLinks, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemToTestLinks.class);
    }

    public WorkItemToTestLinks addWorkItemToTestLinks(WorkItemToTestLinks workItemToTestLinks, UUID project) {
        UUID locationId = UUID.fromString("371b1655-ce05-412e-a113-64cc77bb78d2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, workItemToTestLinks, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemToTestLinks.class);
    }

    public boolean deleteTestMethodToWorkItemLink(String project, String testName, int workItemId) {
        UUID locationId = UUID.fromString("7b0bdee3-a354-47f9-a42c-89018d7808d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("testName", testName);
        queryParameters.put("workItemId", String.valueOf(workItemId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Boolean.TYPE);
    }

    public boolean deleteTestMethodToWorkItemLink(UUID project, String testName, int workItemId) {
        UUID locationId = UUID.fromString("7b0bdee3-a354-47f9-a42c-89018d7808d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("testName", testName);
        queryParameters.put("workItemId", String.valueOf(workItemId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Boolean.TYPE);
    }

    public TestToWorkItemLinks queryTestMethodLinkedWorkItems(String project, String testName) {
        UUID locationId = UUID.fromString("7b0bdee3-a354-47f9-a42c-89018d7808d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("testName", testName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestToWorkItemLinks.class);
    }

    public TestToWorkItemLinks queryTestMethodLinkedWorkItems(UUID project, String testName) {
        UUID locationId = UUID.fromString("7b0bdee3-a354-47f9-a42c-89018d7808d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("testName", testName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TestToWorkItemLinks.class);
    }

    public ArrayList<WorkItemReference> queryTestResultWorkItems(String project, String workItemCategory, String automatedTestName, Integer testCaseId, Date maxCompleteDate, Integer days, Integer workItemCount) {
        UUID locationId = UUID.fromString("926ff5dc-137f-45f0-bd51-9412fa9810ce");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("workItemCategory", workItemCategory);
        queryParameters.addIfNotEmpty("automatedTestName", automatedTestName);
        queryParameters.addIfNotNull("testCaseId", testCaseId);
        queryParameters.addIfNotNull("maxCompleteDate", maxCompleteDate);
        queryParameters.addIfNotNull("days", days);
        queryParameters.addIfNotNull("$workItemCount", workItemCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemReference>>(){});
    }

    public ArrayList<WorkItemReference> queryTestResultWorkItems(UUID project, String workItemCategory, String automatedTestName, Integer testCaseId, Date maxCompleteDate, Integer days, Integer workItemCount) {
        UUID locationId = UUID.fromString("926ff5dc-137f-45f0-bd51-9412fa9810ce");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("workItemCategory", workItemCategory);
        queryParameters.addIfNotEmpty("automatedTestName", automatedTestName);
        queryParameters.addIfNotNull("testCaseId", testCaseId);
        queryParameters.addIfNotNull("maxCompleteDate", maxCompleteDate);
        queryParameters.addIfNotNull("days", days);
        queryParameters.addIfNotNull("$workItemCount", workItemCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemReference>>(){});
    }
}

