/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core;

import com.microsoft.alm.client.TeeClientHandler;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocation;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocationCollection;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.tfs.core.ConnectivityFailureRequestHandler;
import com.microsoft.tfs.core.ConnectivityFailureStatusChangeListener;
import com.microsoft.tfs.core.ServerCapabilities;
import com.microsoft.tfs.core.TFProxyServerSettings;
import com.microsoft.tfs.core.TFSConnectionClosedException;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogQueryOptions;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResource;
import com.microsoft.tfs.core.clients.framework.catalog.ICatalogService;
import com.microsoft.tfs.core.clients.framework.location.ConnectOptions;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.sharepoint.WSSClient;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.IllegalConfigurationException;
import com.microsoft.tfs.core.config.client.ClientFactory;
import com.microsoft.tfs.core.config.client.UnknownClientException;
import com.microsoft.tfs.core.config.httpclient.HTTPClientFactory;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.config.serveruri.ServerURIProvider;
import com.microsoft.tfs.core.config.tfproxy.DefaultTFProxyServerSettings;
import com.microsoft.tfs.core.config.tfproxy.TFProxyServerSettingsFactory;
import com.microsoft.tfs.core.config.webservice.UnknownWebServiceException;
import com.microsoft.tfs.core.config.webservice.WebServiceFactory;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.product.ProductInformation;
import com.microsoft.tfs.core.product.ProductName;
import com.microsoft.tfs.core.util.TFSUser;
import com.microsoft.tfs.core.util.TFSUsernameParseException;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.CollatorFactory;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.URLEncode;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import com.microsoft.tfs.util.shutdown.ShutdownEventListener;
import com.microsoft.tfs.util.shutdown.ShutdownManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ms.tfs.services.linking._03._IntegrationServiceSoap;
import ms.tfs.services.registration._03._RegistrationSoap;
import ms.ws._LocationWebServiceSoap;
import ms.wss._ListsSoap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TFSConnection
implements Closable {
    private static final Log log = LogFactory.getLog(TFSConnection.class);
    private final ConnectionAdvisor advisor;
    private final GUID sessionId;
    private final ConnectionInstanceData instanceData;
    private final ShutdownEventListener shutdownEventListener;
    private final Map<String, WSSClient> wssClients = new HashMap<String, WSSClient>();
    private final Object wssClientsLock = new Object();
    private final Map<Class<?>, Object> clients = new HashMap();
    private final Object clientsLock = new Object();
    private HTTPClientReference httpClientReference;
    private HTTPClientFactory httpClientFactory;
    private final Object httpClientLock = new Object();
    private final String locationServiceRelativePath;
    private URI baseURI;
    private final Object baseURILock = new Object();
    private String displayName;
    private final Object displayNameLock = new Object();
    private URI locationServiceURI;
    private final Object locationServiceURILock = new Object();
    private CatalogNode catalogNode;
    private final Object catalogNodeLock = new Object();
    private TFProxyServerSettings tfProxyServerSettings;
    private TFProxyServerSettingsFactory tfProxyServerSettingsFactory;
    private final Object tfProxyServerSettingsLock = new Object();
    private boolean needToDisposeTfProxyServerSettings;
    private TimeZone timeZone;
    private final Object timeZoneLock = new Object();
    private Locale locale;
    private final Object localeLock = new Object();
    private Collator caseSensitiveCollator;
    private Collator caseInsensitiveCollator;
    private final Object collatorLock = new Object();
    private PersistenceStoreProvider persistenceStoreProvider;
    private final Object persistenceStoreProviderLock = new Object();
    private WebServiceFactory webServiceFactory;
    private final Object webServiceFactoryLock = new Object();
    private ClientFactory clientFactory;
    private final Object clientFactoryLock = new Object();
    private final AtomicBoolean connectivityFailureOnLastWebServiceCall = new AtomicBoolean(false);
    private final SingleListenerFacade connectivityFailureListeners = new SingleListenerFacade(ConnectivityFailureStatusChangeListener.class);
    private boolean connectionClosed = false;
    private ApiResourceVersion.Version serverApiVersion = null;
    private final Object serverApiVersionLock = new Object();

    protected TFSConnection(URI serverURI, AtomicReference<Credentials> credentialsHolder, ConnectionAdvisor advisor, String locationServiceRelativePath) {
        Check.notNull(serverURI, "serverURI");
        Check.notNull(advisor, "advisor");
        Check.notNullOrEmpty(locationServiceRelativePath, "locationServiceRelativePath");
        this.locationServiceRelativePath = locationServiceRelativePath;
        String serverURIShortFormat = serverURI.toString();
        if (serverURIShortFormat != null && serverURIShortFormat.toLowerCase().endsWith(this.locationServiceRelativePath.toLowerCase())) {
            try {
                serverURI = new URI(serverURIShortFormat.substring(0, serverURIShortFormat.length() - this.locationServiceRelativePath.length()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage(), e);
            }
        }
        this.advisor = advisor;
        this.sessionId = GUID.newGUID();
        this.instanceData = new ConnectionInstanceData(serverURI, credentialsHolder, this.sessionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Created a new TFSConnection, sessionId: [{0}], server URI: [{1}]", this.sessionId, serverURI));
        }
        this.shutdownEventListener = new ShutdownEventListener(){
            final Throwable creationStack = TFSConnection.access$000() ? new Throwable("The TFSConnection was closed during JVM shutdown because it was not properly closed by the creator.  The creator of the TFSConnection should close the connection when finished with it.") : null;

            @Override
            public void onShutdown() {
                if (TFSConnection.this.isClosed()) {
                    return;
                }
                if (this.creationStack != null) {
                    log.warn((Object)this.creationStack.getMessage(), this.creationStack);
                }
                log.debug((Object)"Shutdown: close TFSConnection.");
                TFSConnection.this.close();
                log.debug((Object)"Shutdown: TFSCconnection closed.");
            }
        };
        ShutdownManager.getInstance().addShutdownEventListener(this.shutdownEventListener, ShutdownManager.Priority.MIDDLE);
    }

    private static boolean isSDK() {
        return ProductInformation.getCurrent() == ProductName.SDK;
    }

    public GUID getSessionID() {
        this.checkNotClosed();
        return this.sessionId;
    }

    public GUID getCatalogResourceID() {
        this.checkNotClosed();
        return this.getServerDataProvider().getCatalogResourceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatalogNode getCatalogNode() {
        this.checkNotClosed();
        Object object = this.catalogNodeLock;
        synchronized (object) {
            if (this.catalogNode == null && this.getCatalogResourceID() != GUID.EMPTY) {
                ICatalogService catalogService = this.getCatalogService();
                CatalogResource[] resources = catalogService.queryResources(new GUID[]{this.getCatalogResourceID()}, CatalogQueryOptions.NONE);
                if (resources.length > 1) {
                    log.error((Object)MessageFormat.format("Found multiple catalog resources with the ID {0}", this.getCatalogResourceID()));
                } else {
                    CatalogNode[] references = resources[0].getNodeReferences();
                    for (int i = 0; i < references.length; ++i) {
                        CatalogNode node = references[i];
                        if (node.getFullPath() == null || !node.getFullPath().startsWith("3eYRYkJOok6GHrKam0AcAA==")) continue;
                        this.catalogNode = node;
                    }
                }
                if (this.catalogNode == null) {
                    log.error((Object)"Found a catalog resource ID but no node under the organizational tree");
                }
            }
            return this.catalogNode;
        }
    }

    protected abstract ICatalogService getCatalogService();

    public GUID getInstanceID() {
        this.checkNotClosed();
        return this.getServerDataProvider().getInstanceID();
    }

    protected abstract ServerDataProvider getServerDataProvider();

    public abstract boolean hasAuthenticated();

    protected void checkNotClosed() {
        if (this.connectionClosed) {
            throw new TFSConnectionClosedException();
        }
    }

    protected void warnClosed() {
        TFSConnectionClosedException stack = new TFSConnectionClosedException();
        log.warn((Object)stack.getMessage(), (Throwable)stack);
    }

    public boolean isClosed() {
        return this.connectionClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            this.warnClosed();
            return;
        }
        log.debug((Object)"closing connection.");
        log.debug((Object)"Removing connection's shutdown listener from the ShutdownManager.");
        ShutdownManager.getInstance().removeShutdownEventListener(this.shutdownEventListener, ShutdownManager.Priority.MIDDLE);
        Object object = this.clientsLock;
        synchronized (object) {
            log.debug((Object)"Close all clients.");
            for (Object object2 : this.clients.values()) {
                if (!(object2 instanceof Closable)) continue;
                ((Closable)object2).close();
            }
            this.clients.clear();
        }
        object = this.wssClientsLock;
        synchronized (object) {
            log.debug((Object)"Close all SharePoint clients.");
            for (Object object3 : this.wssClients.values()) {
                if (!(object3 instanceof Closable)) continue;
                ((Closable)object3).close();
            }
            this.wssClients.clear();
        }
        object = this.httpClientLock;
        synchronized (object) {
            log.debug((Object)"Close HTTP client.");
            if (this.httpClientReference != null) {
                if (this.httpClientReference.decrementUseCount() == 0) {
                    log.debug((Object)"Disposing HTTP factory and client for the TFS connection.");
                    this.httpClientReference.getFactory().dispose(this.httpClientReference.getHTTPClient());
                    this.httpClientReference = null;
                    this.httpClientFactory = null;
                    log.debug((Object)"Has disposed HTTP factory and client for the TFS connection.");
                } else {
                    log.debug((Object)"httpClientReference.useCount > 0");
                }
            } else {
                log.warn((Object)"httpClientReference is null");
            }
        }
        object = this.tfProxyServerSettingsLock;
        synchronized (object) {
            if (this.needToDisposeTfProxyServerSettings) {
                this.tfProxyServerSettingsFactory.dispose(this.tfProxyServerSettings);
            }
            this.tfProxyServerSettings = null;
            this.tfProxyServerSettingsFactory = null;
        }
        this.connectionClosed = true;
    }

    public TeamFoundationIdentity getAuthenticatedIdentity() {
        this.checkNotClosed();
        return this.getServerDataProvider().getAuthenticatedIdentity();
    }

    public TeamFoundationIdentity getAuthorizedIdentity() {
        this.checkNotClosed();
        return this.getServerDataProvider().getAuthorizedIdentity();
    }

    public TFSUser getAuthorizedTFSUser() {
        this.checkNotClosed();
        TeamFoundationIdentity identity = this.getAuthorizedIdentity();
        try {
            return new TFSUser(identity.getAttribute("Account", null), identity.getAttribute("Domain", null));
        }
        catch (TFSUsernameParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAuthorizedAccountName() {
        this.checkNotClosed();
        return this.getAuthorizedIdentity().getAttribute("Account", null);
    }

    public String getAuthorizedDomainName() {
        this.checkNotClosed();
        return this.getAuthorizedIdentity().getAttribute("Domain", null);
    }

    public void ensureAuthenticated() {
        this.checkNotClosed();
        this.getServerDataProvider().ensureAuthenticated();
    }

    public void authenticate() {
        this.checkNotClosed();
        this.getServerDataProvider().authenticate();
    }

    public void connect(ConnectOptions connectOptions) {
        this.checkNotClosed();
        this.getServerDataProvider().connect(connectOptions);
    }

    public URI getWebServiceURI(Object webService) {
        this.checkNotClosed();
        try {
            return this.getWebServiceFactory().getWebServiceURI(webService);
        }
        catch (URISyntaxException e) {
            throw new IllegalConfigurationException(MessageFormat.format("uri syntax error getting web service uri for: {0}", webService));
        }
    }

    public Object getWebService(Class<?> webServiceType) throws UnknownWebServiceException {
        Object webService;
        this.checkNotClosed();
        Check.notNull(webServiceType, "webServiceType");
        if (_ListsSoap.class.equals(webServiceType)) {
            throw new IllegalArgumentException("To get a _ListsSoap web service, call getWssWebService()");
        }
        if (_IntegrationServiceSoap.class.equals(webServiceType)) {
            throw new IllegalArgumentException("To get a _LinkingService web service, call getLinkingWebService()");
        }
        WebServiceFactory factory = this.getWebServiceFactory();
        if (_RegistrationSoap.class.equals(webServiceType)) {
            try {
                webService = factory.newRegistrationWebService(this.getBaseURI(), this.getHTTPClient());
            }
            catch (URISyntaxException e) {
                throw new IllegalConfigurationException("uri syntax error when creating the registration web service", e);
            }
            if (webService == null) {
                throw new IllegalConfigurationException("WebServiceFactory returned null from newRegistrationWebService()");
            }
        } else if (_LocationWebServiceSoap.class.equals(webServiceType)) {
            try {
                webService = factory.newLocationWebService(this.getLocationServiceURI(), this.getHTTPClient());
            }
            catch (URISyntaxException e) {
                throw new IllegalConfigurationException("uri syntax error when creating the location web service", e);
            }
            if (webService == null) {
                throw new IllegalConfigurationException("WebServiceFactory returned null from newLocationWebService()");
            }
        } else {
            try {
                webService = factory.newWebService(this, webServiceType, this.getBaseURI(), this.getHTTPClient(), this.getServerDataProvider(), this.getRegistrationClient());
            }
            catch (URISyntaxException e) {
                throw new IllegalConfigurationException(MessageFormat.format("uri syntax error when creating the [{0}] web service", webServiceType.getName()), e);
            }
        }
        if (webService != null && webService instanceof SOAPService) {
            ((SOAPService)webService).addTransportRequestHandler(new ConnectivityFailureRequestHandler(this));
        }
        return webService;
    }

    public _ListsSoap getWSSWebService(ProjectInfo projectInfo) {
        _ListsSoap webService;
        this.checkNotClosed();
        Check.notNull(projectInfo, "projectInfo");
        WebServiceFactory factory = this.getWebServiceFactory();
        try {
            webService = factory.newWSSWebService(this, projectInfo, this.getBaseURI(), this.getHTTPClient(), this.getRegistrationClient());
        }
        catch (URISyntaxException e) {
            throw new IllegalConfigurationException("uri syntax error when creating the WSS web service", e);
        }
        if (webService == null) {
            throw new IllegalConfigurationException("WebServiceFactory returned null from newWssWebService");
        }
        return webService;
    }

    public _IntegrationServiceSoap getLinkingWebService(String endpoint) {
        _IntegrationServiceSoap webService;
        this.checkNotClosed();
        Check.notNull(endpoint, "endpoint");
        WebServiceFactory factory = this.getWebServiceFactory();
        try {
            webService = factory.newLinkingWebService(this, URLEncode.encode(endpoint), this.getBaseURI(), this.getHTTPClient(), this.getRegistrationClient());
        }
        catch (URISyntaxException e) {
            throw new IllegalConfigurationException("uri syntax error when creating the linking web service", e);
        }
        if (webService == null) {
            throw new IllegalConfigurationException("WebServiceFactory returned null from newLinkingWebService");
        }
        return webService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHTTPClientReference(HTTPClientReference httpClientReference) {
        this.checkNotClosed();
        Object object = this.httpClientLock;
        synchronized (object) {
            this.httpClientReference = httpClientReference;
        }
        if (httpClientReference != null) {
            httpClientReference.incrementUseCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPClientReference getHTTPClientReference() {
        this.checkNotClosed();
        Object object = this.httpClientLock;
        synchronized (object) {
            return this.httpClientReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHTTPClient() {
        this.checkNotClosed();
        Object object = this.httpClientLock;
        synchronized (object) {
            if (this.httpClientReference != null) {
                return this.httpClientReference.getHTTPClient();
            }
            this.httpClientFactory = this.advisor.getHTTPClientFactory(this.instanceData);
            if (this.httpClientFactory == null) {
                throw new IllegalStateException(MessageFormat.format("TFSConnectionSettings [{0}] provided a null HttpClientFactory", this.advisor.getClass().getName()));
            }
            HttpClient httpClient = this.httpClientFactory.newHTTPClient();
            if (httpClient == null) {
                throw new IllegalStateException(MessageFormat.format("HttpClientFactory [{0}] provided a null HttpClient", this.httpClientFactory.getClass().getName()));
            }
            this.httpClientReference = new HTTPClientReference(httpClient, this.httpClientFactory);
            return httpClient;
        }
    }

    public HttpClient newHTTPClient(URI proxyScopeURI) {
        this.checkNotClosed();
        Check.notNull(proxyScopeURI, "proxySettingsURI");
        ConnectionInstanceData proxyInstanceData = new ConnectionInstanceData(proxyScopeURI, GUID.newGUID());
        return this.getConnectionAdvisor().getHTTPClientFactory(proxyInstanceData).newHTTPClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFProxyServerSettings getTFProxyServerSettings() {
        this.checkNotClosed();
        Object object = this.tfProxyServerSettingsLock;
        synchronized (object) {
            if (this.tfProxyServerSettings != null) {
                return this.tfProxyServerSettings;
            }
            this.tfProxyServerSettingsFactory = this.advisor.getTFProxyServerSettingsFactory(this.instanceData);
            if (this.tfProxyServerSettingsFactory != null) {
                this.tfProxyServerSettings = this.tfProxyServerSettingsFactory.newProxyServerSettings();
            }
            boolean bl = this.needToDisposeTfProxyServerSettings = this.tfProxyServerSettings != null;
            if (this.tfProxyServerSettings == null) {
                this.tfProxyServerSettings = new DefaultTFProxyServerSettings(null);
            }
            return this.tfProxyServerSettings;
        }
    }

    @Deprecated
    public URL getURL() {
        this.checkNotClosed();
        try {
            return this.getBaseURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.checkNotClosed();
        Object object = this.displayNameLock;
        synchronized (object) {
            if (this.displayName == null) {
                this.displayName = URIUtils.decodeForDisplay(this.getBaseURI());
            }
            return this.displayName;
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return super.toString();
        }
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getBaseURI() {
        this.checkNotClosed();
        Object object = this.baseURILock;
        synchronized (object) {
            if (this.baseURI == null) {
                ServerURIProvider provider = this.advisor.getServerURIProvider(this.instanceData);
                if (provider == null) {
                    throw new IllegalConfigurationException("ConnectionAdvisor returned a null ServerURIProvider");
                }
                try {
                    this.baseURI = provider.getServerURI();
                }
                catch (URISyntaxException e) {
                    throw new IllegalConfigurationException("Unable to produce a server URI", e);
                }
                if (this.baseURI == null) {
                    throw new IllegalConfigurationException("ServerURIProvider returned a null URI");
                }
                if (!this.baseURI.isAbsolute() || this.baseURI.isOpaque()) {
                    throw new IllegalConfigurationException(MessageFormat.format("ServerURIProvider returned an invalid URI: [{0}]", this.baseURI.toString()));
                }
                if (this.baseURI.toString().toLowerCase().endsWith(this.locationServiceRelativePath.toLowerCase())) {
                    this.baseURI = URI.create(this.baseURI.toString().substring(0, this.baseURI.toString().length() - this.locationServiceRelativePath.length()));
                }
                this.baseURI = URIUtils.ensurePathHasTrailingSlash(this.baseURI);
            }
        }
        return this.baseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getLocationServiceURI() {
        this.checkNotClosed();
        Object object = this.locationServiceURILock;
        synchronized (object) {
            if (this.locationServiceURI == null) {
                this.locationServiceURI = URI.create(URIUtils.combinePaths(this.getBaseURI().toString(), this.locationServiceRelativePath));
            }
            return this.locationServiceURI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeZone getTimeZone() {
        this.checkNotClosed();
        Object object = this.timeZoneLock;
        synchronized (object) {
            if (this.timeZone == null) {
                this.timeZone = this.advisor.getTimeZone(this.instanceData);
                Check.notNull(this.timeZone, "timeZone");
            }
            return this.timeZone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        this.checkNotClosed();
        Object object = this.localeLock;
        synchronized (object) {
            if (this.locale == null) {
                this.locale = this.advisor.getLocale(this.instanceData);
                Check.notNull(this.locale, "locale");
            }
            return this.locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collator getCaseSensitiveCollator() {
        this.checkNotClosed();
        Object object = this.collatorLock;
        synchronized (object) {
            if (this.caseSensitiveCollator == null) {
                this.caseSensitiveCollator = CollatorFactory.getCaseSensitiveCollator(this.getLocale());
            }
            return this.caseSensitiveCollator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collator getCaseInsensitiveCollator() {
        this.checkNotClosed();
        Object object = this.collatorLock;
        synchronized (object) {
            if (this.caseInsensitiveCollator == null) {
                this.caseInsensitiveCollator = CollatorFactory.getCaseInsensitiveCollator(this.getLocale());
            }
            return this.caseInsensitiveCollator;
        }
    }

    public ServerCapabilities getServerCapabilities() {
        this.checkNotClosed();
        return this.getServerDataProvider().getServerCapabilities();
    }

    public boolean isHosted() {
        this.checkNotClosed();
        return this.getServerCapabilities().contains(ServerCapabilities.HOSTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResourceVersion.Version getServerApiVersion() {
        Object object = this.serverApiVersionLock;
        synchronized (object) {
            if (this.serverApiVersion == null) {
                TeeClientHandler clientHandler = new TeeClientHandler(this.getHTTPClient());
                clientHandler.init(true, null, this.getBaseURI());
                ApiResourceLocationCollection locations = clientHandler.getLocations();
                this.serverApiVersion = new ApiResourceVersion.Version(0, 0);
                for (ApiResourceLocation location : locations.getLocations()) {
                    ApiResourceVersion.Version v = location.getReleasedVersion();
                    if (this.serverApiVersion.compareTo(v) >= 0) continue;
                    this.serverApiVersion = v;
                }
            }
        }
        return this.serverApiVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceStoreProvider getPersistenceStoreProvider() {
        this.checkNotClosed();
        Object object = this.persistenceStoreProviderLock;
        synchronized (object) {
            if (this.persistenceStoreProvider != null) {
                return this.persistenceStoreProvider;
            }
            this.persistenceStoreProvider = this.advisor.getPersistenceStoreProvider(this.instanceData);
            return this.persistenceStoreProvider;
        }
    }

    public Credentials getCredentials() {
        this.checkNotClosed();
        return this.instanceData.getCredentials();
    }

    public AtomicReference<Credentials> getCredentialsHolder() {
        this.checkNotClosed();
        return this.instanceData.getCredentialsHolder();
    }

    public ConnectionAdvisor getConnectionAdvisor() {
        this.checkNotClosed();
        return this.advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebServiceFactory getWebServiceFactory() {
        this.checkNotClosed();
        Object object = this.webServiceFactoryLock;
        synchronized (object) {
            if (this.webServiceFactory != null) {
                return this.webServiceFactory;
            }
            this.webServiceFactory = this.advisor.getWebServiceFactory(this.instanceData);
            if (this.webServiceFactory == null) {
                throw new IllegalConfigurationException("ConnectionAdvisor returned a null WebServiceFactory");
            }
            return this.webServiceFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientFactory getClientFactory() {
        this.checkNotClosed();
        Object object = this.clientFactoryLock;
        synchronized (object) {
            if (this.clientFactory != null) {
                return this.clientFactory;
            }
            this.clientFactory = this.advisor.getClientFactory(this.instanceData);
            if (this.clientFactory == null) {
                throw new IllegalConfigurationException("ConnectionAdvisor returned a null ClientFactory");
            }
            return this.clientFactory;
        }
    }

    public abstract RegistrationClient getRegistrationClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getClient(Class<?> clientType) {
        this.checkNotClosed();
        Check.notNull(clientType, "clientType");
        if (WSSClient.class.equals(clientType)) {
            throw new IllegalArgumentException(MessageFormat.format("To get a {0}, call getWssClient()", WSSClient.class.getName()));
        }
        Object object = this.clientsLock;
        synchronized (object) {
            Object client = this.clients.get(clientType);
            if (client != null) {
                return client;
            }
            ClientFactory factory = this.getClientFactory();
            client = factory.newClient(clientType, this);
            if (client == null) {
                throw new UnknownClientException(clientType);
            }
            this.clients.put(clientType, client);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSSClient getWSSClient(ProjectInfo projectInfo) {
        this.checkNotClosed();
        Check.isTrue(this instanceof TFSTeamProjectCollection, "connection is TeamProjectCollection");
        Check.notNull(projectInfo, "projectInfo");
        Object object = this.wssClientsLock;
        synchronized (object) {
            WSSClient client = this.wssClients.get(projectInfo.getGUID());
            if (client != null) {
                return client;
            }
            ClientFactory factory = this.getClientFactory();
            client = factory.newWSSClient((TFSTeamProjectCollection)this, projectInfo);
            if (client == null) {
                throw new IllegalConfigurationException(MessageFormat.format("ClientFactory returned a null WssClient for project name [{0}]", projectInfo.getName()));
            }
            this.wssClients.put(projectInfo.getGUID(), client);
            return client;
        }
    }

    public void setConnectivityFailureOnLastWebServiceCall(boolean failure) {
        boolean lastFailure = this.connectivityFailureOnLastWebServiceCall.getAndSet(failure);
        if (lastFailure != failure) {
            ((ConnectivityFailureStatusChangeListener)this.connectivityFailureListeners.getListener()).onConnectivityFailureStatusChange();
        }
    }

    public boolean getConnectivityFailureOnLastWebServiceCall() {
        return this.connectivityFailureOnLastWebServiceCall.get();
    }

    public void addConnectivityFailureStatusChangeListener(ConnectivityFailureStatusChangeListener listener) {
        this.connectivityFailureListeners.addListener(listener);
    }

    public void removeConnectivityFailureStatusChangeListener(ConnectivityFailureStatusChangeListener listener) {
        this.connectivityFailureListeners.removeListener(listener);
    }

    static /* synthetic */ boolean access$000() {
        return TFSConnection.isSDK();
    }

    protected static final class HTTPClientReference {
        private final HttpClient httpClient;
        private final HTTPClientFactory factory;
        private final Object lock = new Object();
        private int useCount = 1;

        public HTTPClientReference(HttpClient httpClient, HTTPClientFactory factory) {
            Check.notNull(httpClient, "httpClient");
            Check.notNull(factory, "factory");
            this.httpClient = httpClient;
            this.factory = factory;
        }

        public HttpClient getHTTPClient() {
            return this.httpClient;
        }

        public HTTPClientFactory getFactory() {
            return this.factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int incrementUseCount() {
            Object object = this.lock;
            synchronized (object) {
                ++this.useCount;
                return this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int decrementUseCount() {
            Object object = this.lock;
            synchronized (object) {
                --this.useCount;
                return this.useCount;
            }
        }
    }
}

