/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies.loaders.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.checkinpolicies.loaders.internal.PolicyInstancePropertiesParseException;
import com.microsoft.tfs.util.Check;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;

public class PolicyInstanceProperties {
    private static final String ID_PROPERTY = "id";
    private static final String CLASS_NAME_PROPERTY = "class-name";
    private final String id;
    private final String className;

    public PolicyInstanceProperties(String id, String className) {
        Check.notNull(id, ID_PROPERTY);
        Check.notNull(className, "className");
        this.id = id;
        this.className = className;
    }

    public String getID() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public static PolicyInstanceProperties load(InputStream inputStream) {
        Check.notNull(inputStream, "inputStream");
        Properties p = new Properties();
        try {
            p.load(inputStream);
        }
        catch (IOException e) {
            throw new PolicyInstancePropertiesParseException("Could not read the input stream as a properties file", e);
        }
        String id = p.getProperty(ID_PROPERTY);
        if (id == null || id.length() == 0) {
            throw new PolicyInstancePropertiesParseException(MessageFormat.format(Messages.getString("PolicyInstanceProperties.IDPropertyNotFoundInInstanceFileFormat"), ID_PROPERTY));
        }
        String className = p.getProperty(CLASS_NAME_PROPERTY);
        if (className == null || className.length() == 0) {
            throw new PolicyInstancePropertiesParseException(MessageFormat.format(Messages.getString("PolicyInstanceProperties.ClassNamePropertyNotFoundInInstanceFileFormat"), CLASS_NAME_PROPERTY));
        }
        return new PolicyInstanceProperties(id, className);
    }
}

