/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDeletionResult;
import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.IBuildQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.clients.build.soapextensions.ProcessTemplateType;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.GUID;
import ms.tfs.build.buildservice._04._BuildDefinition;
import ms.tfs.build.buildservice._04._BuildDefinitionQueryResult;
import ms.tfs.build.buildservice._04._BuildDefinitionSpec;
import ms.tfs.build.buildservice._04._BuildDeletionResult;
import ms.tfs.build.buildservice._04._BuildDetail;
import ms.tfs.build.buildservice._04._BuildDetailSpec;
import ms.tfs.build.buildservice._04._BuildInformationNode;
import ms.tfs.build.buildservice._04._BuildQueryResult;
import ms.tfs.build.buildservice._04._BuildServiceSoap;
import ms.tfs.build.buildservice._04._BuildUpdateOptions;
import ms.tfs.build.buildservice._04._DefinitionTriggerType;
import ms.tfs.build.buildservice._04._DeleteOptions;
import ms.tfs.build.buildservice._04._InformationChangeRequest;
import ms.tfs.build.buildservice._04._ProcessTemplate;
import ms.tfs.build.buildservice._04._ProcessTemplateType;
import ms.tfs.build.buildservice._04._QueryDeletedOption;
import ms.tfs.build.buildservice._04._QueryOptions;

public class BuildWebService4 {
    private final _BuildServiceSoap webService;
    private final IBuildServer buildServer;

    public BuildWebService4(TFSTeamProjectCollection tfs) {
        this.webService = (_BuildServiceSoap)tfs.getWebService(_BuildServiceSoap.class);
        this.buildServer = tfs.getBuildServer();
    }

    public BuildDetail notifyBuildCompleted(String uri) {
        _BuildDetail result = this.webService.notifyBuildCompleted(uri);
        return new BuildDetail(this.buildServer, result);
    }

    public BuildInformationNode[] updateBuildInformation(InformationChangeRequest[] changeRequests) {
        _InformationChangeRequest[] changes = (_InformationChangeRequest[])WrapperUtils.unwrap(_InformationChangeRequest.class, changeRequests);
        _BuildInformationNode[] _results = this.webService.updateBuildInformation(changes);
        return BuildTypeConvertor.toBuildInformationNodeArray(_results);
    }

    public GUID requestIntermediateLogs(String uri) {
        String result = this.webService.requestIntermediateLogs(uri);
        return new GUID(result);
    }

    public BuildDetail[] updateBuilds(BuildUpdateOptions[] buildUpdateOptions) {
        _BuildUpdateOptions[] updateOptions = (_BuildUpdateOptions[])WrapperUtils.unwrap(_BuildUpdateOptions.class, buildUpdateOptions);
        _BuildDetail[] results = this.webService.updateBuilds(updateOptions);
        return BuildTypeConvertor.toBuildDetailArray(this.buildServer, results);
    }

    public IBuildDefinition[] getAffectedBuildDefinitions(String[] serverItems, DefinitionTriggerType triggerType) {
        _DefinitionTriggerType trigger = triggerType.getWebServiceObject();
        _BuildDefinition[] results = this.webService.getAffectedBuildDefinitions(serverItems, trigger);
        return BuildTypeConvertor.toBuildDefinitionArray(this.buildServer, results);
    }

    public IBuildQueryResult queryBuildsByUri(String[] buildUris, String[] informationTypes, QueryOptions queryOptions, QueryDeletedOption queryDeletedOption) {
        _QueryOptions options = queryOptions.getWebServiceObject();
        _QueryDeletedOption deletedOption = queryDeletedOption.getWebServiceObject();
        _BuildQueryResult result = this.webService.queryBuildsByUri(buildUris, informationTypes, options, deletedOption);
        return new BuildQueryResult(this.buildServer, result);
    }

    public BuildQueryResult[] queryBuilds(IBuildDetailSpec[] buildDetailSpecs) {
        _BuildDetailSpec[] specs = (_BuildDetailSpec[])WrapperUtils.unwrap(_BuildDetailSpec.class, buildDetailSpecs);
        _BuildQueryResult[] results = this.webService.queryBuilds(specs);
        return BuildTypeConvertor.toBuildQueryResults(this.buildServer, results);
    }

    public IBuildDeletionResult[] deleteBuilds(String[] uris, DeleteOptions options) {
        _DeleteOptions deleteOptions = options.getWebServiceObject();
        _BuildDeletionResult[] results = this.webService.deleteBuilds(uris, deleteOptions);
        return BuildTypeConvertor.toBuildDeletionResultAray(results);
    }

    public void destroyBuilds(String[] buildUris) {
        this.webService.destroyBuilds(buildUris);
    }

    public IBuildDefinitionQueryResult queryBuildDefinitionsByUri(String[] buildDefinitionUris, String[] propertyNameFilters, QueryOptions queryOptions) {
        _QueryOptions options = queryOptions.getWebServiceObject();
        _BuildDefinitionQueryResult result = this.webService.queryBuildDefinitionsByUri(buildDefinitionUris, propertyNameFilters, options);
        return new BuildDefinitionQueryResult(this.buildServer, result);
    }

    public IBuildDefinitionQueryResult[] queryBuildDefinitions(IBuildDefinitionSpec[] buildDefinitionSpecs) {
        _BuildDefinitionSpec[] specs = (_BuildDefinitionSpec[])WrapperUtils.unwrap(_BuildDefinitionSpec.class, buildDefinitionSpecs);
        _BuildDefinitionQueryResult[] results = this.webService.queryBuildDefinitions(specs, false);
        return BuildTypeConvertor.toBuildDefinitionQueryResultArray(this.buildServer, results);
    }

    public void deleteBuildDefinitions(String[] definitionUris) {
        this.webService.deleteBuildDefinitions(definitionUris);
    }

    public IBuildDefinition[] addBuildDefinitions(IBuildDefinition[] toAdd) {
        _BuildDefinition[] definitions = (_BuildDefinition[])WrapperUtils.unwrap(_BuildDefinition.class, toAdd);
        _BuildDefinition[] results = this.webService.addBuildDefinitions(definitions);
        return BuildTypeConvertor.toBuildDefinitionArray(this.buildServer, results);
    }

    public IBuildDefinition[] updateBuildDefinitions(IBuildDefinition[] toUpdate) {
        _BuildDefinition[] definitions = (_BuildDefinition[])WrapperUtils.unwrap(_BuildDefinition.class, toUpdate);
        _BuildDefinition[] results = this.webService.updateBuildDefinitions(definitions);
        return BuildTypeConvertor.toBuildDefinitionArray(this.buildServer, results);
    }

    public void stopBuilds(String[] uris) {
        this.webService.stopBuilds(uris);
    }

    public void addBuildQualities(String teamProject, String[] qualities) {
        this.webService.addBuildQualities(teamProject, qualities);
    }

    public void deleteBuildQualities(String teamProject, String[] qualities) {
        this.webService.deleteBuildQualities(teamProject, qualities);
    }

    public String[] getBuildQualities(String teamProject) {
        return this.webService.getBuildQualities(teamProject);
    }

    public ProcessTemplate[] queryProcessTemplates(String teamProject, ProcessTemplateType[] types) {
        _ProcessTemplateType[] queryTypes = (_ProcessTemplateType[])WrapperUtils.unwrap(_ProcessTemplateType.class, types);
        _ProcessTemplate[] results = this.webService.queryProcessTemplates(teamProject, queryTypes);
        return BuildTypeConvertor.toProcessTemplateArray(this.buildServer, results);
    }

    public void deleteProcessTemplates(int[] templateIds) {
        this.webService.deleteProcessTemplates(templateIds);
    }

    public ProcessTemplate[] addProcessTemplates(ProcessTemplate[] processTemplates) {
        _ProcessTemplate[] templates = (_ProcessTemplate[])WrapperUtils.unwrap(_ProcessTemplate.class, processTemplates);
        _ProcessTemplate[] results = this.webService.addProcessTemplates(templates);
        return BuildTypeConvertor.toProcessTemplateArray(this.buildServer, results);
    }

    public ProcessTemplate[] updateProcessTemplates(ProcessTemplate[] toUpdate) {
        _ProcessTemplate[] templates = (_ProcessTemplate[])WrapperUtils.unwrap(_ProcessTemplate.class, toUpdate);
        _ProcessTemplate[] results = this.webService.updateProcessTemplates(templates);
        return BuildTypeConvertor.toProcessTemplateArray(this.buildServer, results);
    }
}

