/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.flags.BuildQueryOrder2010;
import com.microsoft.tfs.core.clients.build.flags.BuildReason2010;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus2010;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption2010;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionSpec2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import java.util.Calendar;
import ms.tfs.build.buildservice._03._BuildDetailSpec;

public class BuildDetailSpec2010
extends WebServiceObjectWrapper {
    private BuildDetailSpec2010() {
        this(new _BuildDetailSpec());
    }

    public BuildDetailSpec2010(_BuildDetailSpec value) {
        super(value);
    }

    public BuildDetailSpec2010(IBuildServer buildServer, IBuildDetailSpec spec) {
        this();
        this.setBuildNumber(spec.getBuildNumber());
        if (spec.getDefinitionSpec() != null) {
            this.setDefinitionSpec(TFS2010Helper.convert(spec.getDefinitionSpec()));
            this.setDefinitionPath(spec.getDefinitionSpec().getFullPath());
        } else if (spec.getDefinitionURIs() != null) {
            this.setDefinitionURIs(spec.getDefinitionURIs());
        }
        this.setInformationTypes(spec.getInformationTypes());
        this.setMaxBuildsPerDefinition(spec.getMaxBuildsPerDefinition());
        this.setMaxFinishTime(spec.getMaxFinishTime());
        this.setMinChangedTime(spec.getMinChangedTime());
        this.setMinFinishTime(spec.getMinFinishTime());
        this.setQuality(spec.getQuality());
        this.setQueryDeletedOption(TFS2010Helper.convert(spec.getQueryDeletedOption()));
        this.setQueryOptions(TFS2010Helper.convert(spec.getQueryOptions()));
        this.setQueryOrder(TFS2010Helper.convert(spec.getQueryOrder()));
        this.setReason(TFS2010Helper.convert(spec.getReason()));
        this.setRequestedFor(spec.getRequestedFor());
        this.setStatus(TFS2010Helper.convert(spec.getStatus()));
    }

    public _BuildDetailSpec getWebServiceObject() {
        return (_BuildDetailSpec)this.webServiceObject;
    }

    public String getBuildNumber() {
        return this.getWebServiceObject().getBuildNumber();
    }

    public String[] getInformationTypes() {
        return this.getWebServiceObject().getInformationTypes();
    }

    public int getMaxBuildsPerDefinition() {
        return this.getWebServiceObject().getMaxBuildsPerDefinition();
    }

    public Calendar getMaxFinishTime() {
        return this.getWebServiceObject().getMaxFinishTime();
    }

    public Calendar getMinChangedTime() {
        return this.getWebServiceObject().getMinChangedTime();
    }

    public Calendar getMinFinishTime() {
        return this.getWebServiceObject().getMinFinishTime();
    }

    public String getQuality() {
        return this.getWebServiceObject().getQuality();
    }

    public QueryDeletedOption2010 getQueryDeletedOption() {
        return QueryDeletedOption2010.fromWebServiceObject(this.getWebServiceObject().getQueryDeletedOption());
    }

    public QueryOptions2010 getQueryOptions() {
        return QueryOptions2010.fromWebServiceObject(this.getWebServiceObject().getQueryOptions());
    }

    public BuildQueryOrder2010 getQueryOrder() {
        return BuildQueryOrder2010.fromWebServiceObject(this.getWebServiceObject().getQueryOrder());
    }

    public BuildReason2010 getReason() {
        return BuildReason2010.fromWebServiceObject(this.getWebServiceObject().getReason());
    }

    public String getRequestedFor() {
        return this.getWebServiceObject().getRequestedFor();
    }

    public BuildStatus2010 getStatus() {
        return BuildStatus2010.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    public void setBuildNumber(String value) {
        this.getWebServiceObject().setBuildNumber(value);
    }

    public void setInformationTypes(String[] value) {
        this.getWebServiceObject().setInformationTypes(value);
    }

    public void setMaxBuildsPerDefinition(int value) {
        this.getWebServiceObject().setMaxBuildsPerDefinition(value);
    }

    public void setMaxFinishTime(Calendar value) {
        this.getWebServiceObject().setMaxFinishTime(value);
    }

    public void setMinChangedTime(Calendar value) {
        this.getWebServiceObject().setMinChangedTime(value);
    }

    public void setMinFinishTime(Calendar value) {
        this.getWebServiceObject().setMinFinishTime(value);
    }

    public void setDefinitionURIs(String[] value) {
        this.getWebServiceObject().setDefinitionUris(value);
        this.getWebServiceObject().setDefinitionSpec(null);
    }

    public void setDefinitionSpec(BuildDefinitionSpec2010 value) {
        this.getWebServiceObject().setDefinitionSpec(value.getWebServiceObject());
        this.getWebServiceObject().setDefinitionUris(null);
    }

    public void setDefinitionPath(String value) {
        this.getWebServiceObject().setDefinitionPath(value);
    }

    public void setQuality(String value) {
        this.getWebServiceObject().setQuality(value);
    }

    public void setQueryDeletedOption(QueryDeletedOption2010 value) {
        this.getWebServiceObject().setQueryDeletedOption(value.getWebServiceObject());
    }

    public void setQueryOptions(QueryOptions2010 value) {
        this.getWebServiceObject().setQueryOptions(value.getWebServiceObject());
    }

    public void setQueryOrder(BuildQueryOrder2010 value) {
        this.getWebServiceObject().setQueryOrder(value.getWebServiceObject());
    }

    public void setReason(BuildReason2010 value) {
        this.getWebServiceObject().setReason(value.getWebServiceObject());
    }

    public void setRequestedFor(String value) {
        this.getWebServiceObject().setRequestedFor(value);
    }

    public void setStatus(BuildStatus2010 value) {
        this.getWebServiceObject().setStatus(value.getWebServiceObject());
    }
}

