/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntityDataProvider;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public class TeamProjectCompatibilityEntityDataProvider
extends TFSCompatibilityEntityDataProvider {
    private final ProjectInfo projectInfo;

    public TeamProjectCompatibilityEntityDataProvider(TFSTeamProjectCollection connection, ProjectInfo projectInfo) {
        super(connection);
        Check.notNull(projectInfo, "projectInfo");
        this.projectInfo = projectInfo;
    }

    @Override
    public GUID getResourceTypeID() {
        return CatalogResourceTypes.TEAM_PROJECT;
    }

    @Override
    public String getDisplayName() {
        return this.projectInfo.getName();
    }

    @Override
    public String getDescription() {
        return this.projectInfo.getName();
    }

    @Override
    public String getProperty(String propertyName) {
        if (propertyName.equals("ProjectId")) {
            return this.projectInfo.getGUID();
        }
        if (propertyName.equals("ProjectName")) {
            return this.projectInfo.getName();
        }
        if (propertyName.equals("ProjectUri")) {
            return this.projectInfo.getURI();
        }
        return null;
    }

    @Override
    public ServiceDefinition getServiceReference(String serviceName) {
        return null;
    }
}

