/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.location.internal;

import com.microsoft.tfs.core.clients.framework.location.AccessMapping;
import com.microsoft.tfs.core.clients.framework.location.LocationMapping;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.core.clients.framework.location.internal.LocationServiceCacheData;
import com.microsoft.tfs.core.internal.persistence.StaxSerializer;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import ms.ws._AccessMapping;
import ms.ws._LocationMapping;
import ms.ws._ServiceDefinition;

public class LocationDataSerializer
extends StaxSerializer {
    private static final int SCHEMA_VERSION = 1;
    private static final String LOCATION_DATA_ELEMENT_NAME = "LocationServiceConfiguration";
    private static final String LAST_CHANGE_ELEMENT_NAME = "LastChangeId";
    private static final String DEFAULT_MAPPING_MONIKER_ELEMENT_NAME = "DefaultAccessMappingMoniker";
    private static final String VIRTUAL_DIRECTORY_ELEMENT_NAME = "VirtualDirectory";
    private static final String ACCESS_MAPPINGS_ELEMENT_NAME = "AcessMappings";
    private static final String ACCESS_MAPPING_ELEMENT_NAME = "AcessMapping";
    private static final String MONIKER_ELEMENT_NAME = "Moniker";
    private static final String ACCESS_POINT_ELEMENT_NAME = "AccessPoint";
    private static final String DISPLAY_NAME_ELEMENT_NAME = "DisplayName";
    private static final String DESCRIPTION_ELEMENT_NAME = "Description";
    private static final String SERVICES_ELEMENT_NAME = "Services";
    private static final String SERVICE_DEFINITION_ELEMENT_NAME = "ServiceDefinition";
    private static final String SERVICE_TYPE_ELEMENT_NAME = "ServiceType";
    private static final String IDENTIFIER_ELEMENT_NAME = "Identifier";
    private static final String TOOL_ID_ELEMENT_NAME = "ToolId";
    private static final String RELATIVE_PATH_ELEMENT_NAME = "RelativePath";
    private static final String LOCATION_MAPPINGS_ELEMENT_NAME = "LocationMappings";
    private static final String LOCATION_MAPPING_ELEMENT_NAME = "LocationMapping";
    private static final String LOCATION_ELEMENT_NAME = "Location";
    private static final String ACCESS_MAPPING_MONIKER_ELEMENT_NAME = "AcessMappingMoniker";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String RELATIVE_TO_ATTRIBUTE_NAME = "relativeTo";

    @Override
    protected Object deserialize(XMLStreamReader reader) throws XMLStreamException, IOException, InterruptedException {
        int lastChangeId = -1;
        String defaultMappingMoniker = "";
        String virtualDirectoryName = "";
        _AccessMapping accessMapping = null;
        _ServiceDefinition serviceDefinition = null;
        _LocationMapping locationMapping = null;
        ArrayList<AccessMapping> accessMappings = new ArrayList<AccessMapping>();
        ArrayList<ServiceDefinition> serviceDefinitions = new ArrayList<ServiceDefinition>();
        ArrayList<_LocationMapping> locationMappings = new ArrayList<_LocationMapping>();
        try {
            int event;
            while ((event = reader.next()) != 8) {
                String localName;
                if (event == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(LAST_CHANGE_ELEMENT_NAME)) {
                        lastChangeId = Integer.valueOf(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(DEFAULT_MAPPING_MONIKER_ELEMENT_NAME)) {
                        defaultMappingMoniker = this.readTextToElementEnd(reader);
                        continue;
                    }
                    if (localName.equals(VIRTUAL_DIRECTORY_ELEMENT_NAME)) {
                        virtualDirectoryName = this.readTextToElementEnd(reader);
                        continue;
                    }
                    if (localName.equals(MONIKER_ELEMENT_NAME)) {
                        accessMapping.setMoniker(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(ACCESS_POINT_ELEMENT_NAME)) {
                        accessMapping.setAccessPoint(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(DISPLAY_NAME_ELEMENT_NAME)) {
                        if (accessMapping != null) {
                            accessMapping.setDisplayName(this.readTextToElementEnd(reader));
                            continue;
                        }
                        serviceDefinition.setDisplayName(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(DESCRIPTION_ELEMENT_NAME)) {
                        serviceDefinition.setDescription(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(SERVICE_TYPE_ELEMENT_NAME)) {
                        serviceDefinition.setServiceType(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(IDENTIFIER_ELEMENT_NAME)) {
                        serviceDefinition.setIdentifier(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(TOOL_ID_ELEMENT_NAME)) {
                        serviceDefinition.setToolId(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(RELATIVE_PATH_ELEMENT_NAME)) {
                        String relativeTo = reader.getAttributeValue(null, RELATIVE_TO_ATTRIBUTE_NAME);
                        serviceDefinition.setRelativeToSetting(Integer.valueOf(relativeTo));
                        serviceDefinition.setRelativePath(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(LOCATION_ELEMENT_NAME)) {
                        locationMapping.setLocation(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(ACCESS_MAPPING_MONIKER_ELEMENT_NAME)) {
                        locationMapping.setAccessMappingMoniker(this.readTextToElementEnd(reader));
                        continue;
                    }
                    if (localName.equals(ACCESS_MAPPING_ELEMENT_NAME)) {
                        accessMapping = new _AccessMapping();
                        continue;
                    }
                    if (localName.equals(SERVICE_DEFINITION_ELEMENT_NAME)) {
                        serviceDefinition = new _ServiceDefinition();
                        continue;
                    }
                    if (!localName.equals(LOCATION_MAPPING_ELEMENT_NAME)) continue;
                    locationMapping = new _LocationMapping();
                    continue;
                }
                if (event != 2) continue;
                localName = reader.getLocalName();
                if (localName.equals(ACCESS_MAPPING_ELEMENT_NAME)) {
                    accessMappings.add(new AccessMapping(accessMapping));
                    accessMapping = null;
                    continue;
                }
                if (localName.equals(SERVICE_DEFINITION_ELEMENT_NAME)) {
                    _LocationMapping[] mappings = locationMappings.toArray(new _LocationMapping[0]);
                    locationMappings.clear();
                    serviceDefinition.setLocationMappings(mappings);
                    serviceDefinitions.add(new ServiceDefinition(serviceDefinition));
                    serviceDefinition = null;
                    continue;
                }
                if (!localName.equals(LOCATION_MAPPING_ELEMENT_NAME)) continue;
                locationMappings.add(locationMapping);
                locationMapping = null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new LocationServiceCacheData(lastChangeId, defaultMappingMoniker, virtualDirectoryName, accessMappings.toArray(new AccessMapping[accessMappings.size()]), serviceDefinitions.toArray(new ServiceDefinition[serviceDefinitions.size()]));
    }

    @Override
    protected void serialize(Object component, XMLStreamWriter writer) throws XMLStreamException, IOException, InterruptedException {
        LocationServiceCacheData data = (LocationServiceCacheData)component;
        writer.writeStartElement(LOCATION_DATA_ELEMENT_NAME);
        writer.writeAttribute(VERSION_ATTRIBUTE_NAME, String.valueOf(1));
        this.createChildTextElement(writer, LAST_CHANGE_ELEMENT_NAME, String.valueOf(data.getLastChangeID()));
        this.createChildTextElement(writer, DEFAULT_MAPPING_MONIKER_ELEMENT_NAME, data.getDefaultMappingMoniker());
        if (data.getVirtualDirectory() != null) {
            this.createChildTextElement(writer, VIRTUAL_DIRECTORY_ELEMENT_NAME, data.getVirtualDirectory());
        }
        writer.writeStartElement(ACCESS_MAPPINGS_ELEMENT_NAME);
        AccessMapping[] accessMappings = data.getAccessMappings();
        for (int i = 0; i < accessMappings.length; ++i) {
            AccessMapping mapping = accessMappings[i];
            writer.writeStartElement(ACCESS_MAPPING_ELEMENT_NAME);
            this.createChildTextElement(writer, MONIKER_ELEMENT_NAME, mapping.getMoniker());
            this.createChildTextElement(writer, ACCESS_POINT_ELEMENT_NAME, mapping.getAccessPoint());
            this.createChildTextElement(writer, DISPLAY_NAME_ELEMENT_NAME, mapping.getDisplayName());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement(SERVICES_ELEMENT_NAME);
        ServiceDefinition[] serviceDefinitions = data.getServiceDefinitions();
        for (int i = 0; i < serviceDefinitions.length; ++i) {
            ServiceDefinition definition = serviceDefinitions[i];
            writer.writeStartElement(SERVICE_DEFINITION_ELEMENT_NAME);
            this.createChildTextElement(writer, SERVICE_TYPE_ELEMENT_NAME, definition.getServiceType());
            this.createChildTextElement(writer, IDENTIFIER_ELEMENT_NAME, definition.getIdentifier().getGUIDString());
            if (definition.getDisplayName() != null) {
                this.createChildTextElement(writer, DISPLAY_NAME_ELEMENT_NAME, definition.getDisplayName());
            }
            if (definition.getDescription() != null) {
                this.createChildTextElement(writer, DESCRIPTION_ELEMENT_NAME, definition.getDescription());
            }
            if (definition.getToolID() != null) {
                this.createChildTextElement(writer, TOOL_ID_ELEMENT_NAME, definition.getToolID());
            }
            writer.writeStartElement(RELATIVE_PATH_ELEMENT_NAME);
            writer.writeAttribute(RELATIVE_TO_ATTRIBUTE_NAME, String.valueOf(definition.getRelativeToSetting().toInt()));
            if (definition.getRelativePath() != null) {
                writer.writeCharacters(definition.getRelativePath());
            }
            writer.writeEndElement();
            writer.writeStartElement(LOCATION_MAPPINGS_ELEMENT_NAME);
            LocationMapping[] locationMappings = definition.getLocationMappings();
            for (int j = 0; j < locationMappings.length; ++j) {
                LocationMapping mapping = locationMappings[j];
                writer.writeStartElement(LOCATION_MAPPING_ELEMENT_NAME);
                this.createChildTextElement(writer, ACCESS_MAPPING_MONIKER_ELEMENT_NAME, mapping.getAccessMappingMoniker());
                this.createChildTextElement(writer, LOCATION_ELEMENT_NAME, mapping.getLocation());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

