/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.sharepoint;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.core.util.Labelable;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSSDocumentLibrary
implements Hierarchical,
Labelable,
Comparable {
    private static final Log log = LogFactory.getLog(WSSDocumentLibrary.class);
    private final String guid;
    private String label;
    private boolean hidden;
    private Object parent;
    private final boolean isValid;
    private String asciiName;
    private final String EMPTY = "";
    private final ArrayList children = new ArrayList();
    private boolean childrenSorted = false;
    private String defaultViewURL;

    public WSSDocumentLibrary() {
        this.guid = "";
        this.label = "";
        this.isValid = false;
    }

    public WSSDocumentLibrary(TFSTeamProjectCollection connection, Element node) {
        this.guid = node.getAttribute("ID");
        this.label = node.getAttribute("Title");
        this.defaultViewURL = node.getAttribute("DefaultViewUrl");
        String isHidden = node.getAttribute("Hidden");
        if (isHidden != null) {
            this.hidden = Boolean.valueOf(isHidden);
        }
        this.asciiName = this.calculateASCIIName(connection, node);
        this.isValid = this.asciiName != null && this.guid != null && this.guid.length() > 0 && this.label != null && this.label.length() > 0;
    }

    private String calculateASCIIName(TFSTeamProjectCollection connection, Element node) {
        String name = null;
        String defaultViewUrl = "";
        if (node.hasAttribute("DefaultViewUrl")) {
            defaultViewUrl = node.getAttribute("DefaultViewUrl");
        }
        String webFullUrl = "";
        if (node.hasAttribute("WebFullUrl")) {
            webFullUrl = node.getAttribute("WebFullUrl");
        }
        if ((name = this.calculateASCIINameFromWebFullURL(defaultViewUrl, webFullUrl)) != null) {
            return name;
        }
        return this.label;
    }

    protected String calculateASCIINameFromWebFullURL(String defaultViewUrl, String webFullUrl) {
        if (defaultViewUrl == null || defaultViewUrl.length() == 0 || webFullUrl == null || webFullUrl.length() == 0) {
            return null;
        }
        if (defaultViewUrl.startsWith(webFullUrl) && webFullUrl.length() + 1 < defaultViewUrl.length()) {
            String value;
            int endPos;
            int startPos = webFullUrl.length();
            if (!webFullUrl.endsWith("/")) {
                ++startPos;
            }
            if ((endPos = (value = defaultViewUrl.substring(startPos).trim()).indexOf(47)) < 0) {
                return value;
            }
            return value.substring(0, endPos);
        }
        return null;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    @Override
    public Object[] getChildren() {
        if (!this.childrenSorted) {
            Collections.sort(this.children);
            this.childrenSorted = true;
        }
        return this.children.toArray();
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void addChild(Object child) {
        this.children.add(child);
        this.childrenSorted = false;
    }

    public void addChildren(Collection children) {
        this.children.addAll(children);
        this.childrenSorted = false;
    }

    public String getDefaultViewURL() {
        return this.defaultViewURL;
    }

    public void setDefaultViewURL(String defaultViewUrl) {
        this.defaultViewURL = defaultViewUrl;
    }

    public String getGUID() {
        return this.guid;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        Check.notNull(label, "label");
        this.label = label;
    }

    public String getASCIIName() {
        return this.asciiName;
    }

    public void setASCIIName(String asciiName) {
        this.asciiName = asciiName;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int compareTo(Object compare) {
        if (!(compare instanceof WSSDocumentLibrary)) {
            throw new ClassCastException(MessageFormat.format("A WssDocumentLibrary to compare against was expected, class passed was {0}", compare.getClass().getName()));
        }
        WSSDocumentLibrary anotherLib = (WSSDocumentLibrary)compare;
        return this.getLabel().compareTo(anotherLib.getLabel());
    }
}

