/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.teamsettings;

import com.microsoft.tfs.core.clients.teamsettings.TeamConfiguration;
import com.microsoft.tfs.core.clients.teamsettings.TeamSettings;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import ms.tfs.services.teamconfiguration._01._TeamConfigurationServiceSoap;

public class TeamSettingsConfigurationService {
    private final _TeamConfigurationServiceSoap internalService;

    public TeamSettingsConfigurationService(_TeamConfigurationServiceSoap webService) {
        Check.notNull(webService, "webService");
        this.internalService = webService;
    }

    public TeamConfiguration[] getTeamConfigurationsForUser(String[] projectUris) {
        if (projectUris == null) {
            projectUris = new String[]{};
        }
        return (TeamConfiguration[])WrapperUtils.wrap(TeamConfiguration.class, this.internalService.getTeamConfigurationsForUser(projectUris));
    }

    public void setTeamSettings(GUID teamId, TeamSettings settings) {
        Check.isTrue(!GUID.EMPTY.equals(teamId), "teamId must not be GUID.EMPTY");
        Check.notNull(settings, "settings");
        Check.notNullOrEmpty(settings.getBacklogIterationPath(), "settings.getBacklogIterationPath()");
        Check.notNull(settings.getTeamFieldValues(), "settings.getTeamFieldValues()");
        if (settings.getIterationPaths() == null) {
            settings.setIterationPaths(new String[0]);
        }
        this.internalService.setTeamSettings(teamId.getGUIDString(), settings.getWebServiceObject());
    }
}

