/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.IPopulatableLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.Calendar;

public class InitiallyDeletedLocalVersionUpdate
implements IPopulatableLocalVersionUpdate,
Closable {
    private final String sourceServerItem;
    private final int itemID;
    private final int versionLocal;
    private final int encoding;
    private long versionLocalDate = -1L;
    private byte[] baselineHashValue = null;
    private long baselineFileLength = -1L;
    private byte[] baselineFileGUID = null;
    private String pendingChangeTargetServerItem = null;
    private String downloadURL = null;

    public InitiallyDeletedLocalVersionUpdate(String sourceServerItem, int itemID, int versionLocal, Calendar versionLocalDate, int encoding, String pendingChangeTargetServerItem) {
        this.sourceServerItem = sourceServerItem;
        this.itemID = itemID;
        this.versionLocal = versionLocal;
        this.versionLocalDate = DotNETDate.MIN_CALENDAR.equals(versionLocalDate) ? -1L : DotNETDate.toWindowsFileTimeUTC(versionLocalDate);
        this.encoding = encoding;
        this.pendingChangeTargetServerItem = pendingChangeTargetServerItem;
    }

    @Override
    public boolean isSendToServer() {
        return false;
    }

    @Override
    public boolean isCommitted() {
        return 0 != this.versionLocal;
    }

    @Override
    public String getSourceServerItem() {
        return this.sourceServerItem;
    }

    @Override
    public int getItemID() {
        return this.itemID;
    }

    @Override
    public String getTargetLocalItem() {
        return null;
    }

    @Override
    public int getVersionLocal() {
        return this.versionLocal;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public long getVersionLocalDate() {
        return this.versionLocalDate;
    }

    @Override
    public byte[] getBaselineHashValue() {
        return this.baselineHashValue;
    }

    public long getBaselineFileLength() {
        return this.baselineFileLength;
    }

    @Override
    public byte[] getBaselineFileGUID() {
        return this.baselineFileGUID;
    }

    @Override
    public String getDownloadURL() {
        return this.downloadURL;
    }

    @Override
    public void setDownloadURL(String value) {
        this.downloadURL = value;
    }

    @Override
    public String getPendingChangeTargetServerItem() {
        return this.pendingChangeTargetServerItem;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isFullyPopulated(boolean requireVersionLocalDate) {
        return null != this.baselineHashValue && -1L != this.baselineFileLength && (!requireVersionLocalDate || -1L != this.versionLocalDate);
    }

    @Override
    public void updateFrom(Item item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFrom(WorkspaceLocalItem lvExisting) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFrom(PendingChange pendingChange) {
        this.baselineFileLength = pendingChange.getLength();
        this.baselineHashValue = pendingChange.getHashValue();
    }

    public void generateNewBaselineFileGuid() {
        this.baselineFileGUID = GUID.newGUID().getGUIDBytes();
    }
}

