/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.util.Check;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BinaryReader {
    private final InputStream is;
    private final String charsetName;

    public BinaryReader(InputStream is, String charsetName) {
        Check.isTrue(is.markSupported(), "is");
        this.is = is;
        this.charsetName = charsetName;
    }

    public boolean isEOF() throws IOException {
        this.is.mark(1);
        int value = this.is.read();
        if (value == -1) {
            return true;
        }
        this.is.reset();
        return false;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        int value = this.is.read();
        if (value == -1) {
            throw new EOFException();
        }
        return (byte)value;
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] bytes = new byte[count];
        int bytesRead = this.is.read(bytes);
        if (bytesRead == -1) {
            throw new EOFException();
        }
        if (bytesRead < count) {
            throw new IllegalStateException();
        }
        return bytes;
    }

    public short readInt16() throws IOException {
        byte[] bytes = this.readBytes(2);
        short value = (short)(bytes[1] & 0xFF);
        value = (short)(value << 8);
        value = (short)(value | bytes[0] & 0xFF);
        return value;
    }

    public int readInt32() throws IOException {
        byte[] bytes = this.readBytes(4);
        int value = bytes[3] & 0xFF;
        value <<= 8;
        value |= bytes[2] & 0xFF;
        value <<= 8;
        value |= bytes[1] & 0xFF;
        value <<= 8;
        return value |= bytes[0] & 0xFF;
    }

    public int readUInt32() throws IOException {
        return this.readInt32();
    }

    public long readInt64() throws IOException {
        byte[] bytes = this.readBytes(8);
        long value = bytes[7] & 0xFF;
        value <<= 8;
        value |= (long)(bytes[6] & 0xFF);
        value <<= 8;
        value |= (long)(bytes[5] & 0xFF);
        value <<= 8;
        value |= (long)(bytes[4] & 0xFF);
        value <<= 8;
        value |= (long)(bytes[3] & 0xFF);
        value <<= 8;
        value |= (long)(bytes[2] & 0xFF);
        value <<= 8;
        value |= (long)(bytes[1] & 0xFF);
        value <<= 8;
        return value |= (long)(bytes[0] & 0xFF);
    }

    public String readString() throws IOException {
        int multiplier = 1;
        int length = 0;
        while (true) {
            byte next = this.readByte();
            length += (next & 0x7F) * multiplier;
            if ((next & 0x80) == 0) break;
            multiplier *= 128;
        }
        byte[] bytes = this.readBytes(length);
        String s = new String(bytes, this.charsetName);
        return s;
    }

    public void close() throws IOException {
        this.is.close();
    }
}

