/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.EnumeratedLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalItemEnumerator;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class LocalItemEnumerable
implements Iterable<EnumeratedLocalItem> {
    private final File startPath;
    private final boolean recurse;
    private final List<String> excludedPaths;
    private final boolean enumerateHiddenAndSystem;

    public LocalItemEnumerable(String path, boolean recurse, List<String> excludedPaths) {
        this(path, recurse, false, excludedPaths);
    }

    public LocalItemEnumerable(String path, boolean recurse, boolean enumerateHiddenAndSystem, List<String> excludedPaths) {
        Check.notNullOrEmpty(path, "path");
        this.startPath = new File(path);
        this.recurse = recurse;
        this.excludedPaths = excludedPaths;
        this.enumerateHiddenAndSystem = enumerateHiddenAndSystem;
    }

    @Override
    public Iterator<EnumeratedLocalItem> iterator() {
        return new LocalItemEnumerator(this.startPath, this.recurse, this.enumerateHiddenAndSystem, this.excludedPaths, null);
    }

    public static Iterable<LocalItemEnumerator> getEnumeratorsForWorkingFolders(WorkingFolder[] folders) {
        Arrays.sort(folders, new Comparator<WorkingFolder>(){

            @Override
            public int compare(WorkingFolder x, WorkingFolder y) {
                return ServerPath.compareTopDown(x.getServerItem(), y.getServerItem());
            }
        });
        Stack<LocalItemEnumerator> enumStack = new Stack<LocalItemEnumerator>();
        LocalItemEnumerator current = null;
        ArrayList<LocalItemEnumerator> toReturn = new ArrayList<LocalItemEnumerator>();
        for (WorkingFolder wf : folders) {
            while (null != current && !ServerPath.isChild(((WorkingFolder)current.getTag()).getServerItem(), wf.getServerItem())) {
                toReturn.add(current);
                if (enumStack.size() > 0) {
                    current = (LocalItemEnumerator)enumStack.pop();
                    continue;
                }
                current = null;
            }
            if (!wf.isCloaked()) {
                if (null != current) {
                    enumStack.push(current);
                }
                current = new LocalItemEnumerator(new File(wf.getLocalItem()), RecursionType.FULL == wf.getDepth(), false, null, wf);
                continue;
            }
            if (null == current) continue;
            current.addExcludedPath(((WorkingFolder)current.getTag()).translateServerItemToLocalItem(wf.getServerItem()));
        }
        while (enumStack.size() > 0) {
            toReturn.add((LocalItemEnumerator)enumStack.pop());
        }
        if (null != current) {
            toReturn.add(current);
        }
        enumStack.clear();
        current = null;
        Collections.sort(toReturn, new Comparator<LocalItemEnumerator>(){

            @Override
            public int compare(LocalItemEnumerator x, LocalItemEnumerator y) {
                return LocalPath.compareTopDown(x.getStartPath(), y.getStartPath());
            }
        });
        for (LocalItemEnumerator lie : toReturn) {
            while (null != current && !LocalPath.isChild(current.getStartPath(), lie.getStartPath())) {
                if (enumStack.size() > 0) {
                    current = (LocalItemEnumerator)enumStack.pop();
                    continue;
                }
                current = null;
            }
            if (null != current) {
                current.addExcludedPath(lie.getStartPath());
                enumStack.push(current);
            }
            current = lie;
        }
        return toReturn;
    }
}

