/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.offline;

import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.util.TypesafeEnum;

public class OfflineChangeType
extends TypesafeEnum {
    public static final OfflineChangeType EDIT = new OfflineChangeType(1, "Edit");
    public static final OfflineChangeType ADD = new OfflineChangeType(2, "Add");
    public static final OfflineChangeType DELETE = new OfflineChangeType(3, "Delete");
    public static final OfflineChangeType UNDO = new OfflineChangeType(4, "Undo");
    public static final OfflineChangeType EXEC = new OfflineChangeType(5, "+x");
    public static final OfflineChangeType NOT_EXEC = new OfflineChangeType(6, "-x");
    public static final OfflineChangeType SYMLINK = new OfflineChangeType(7, "symlink");
    public static final OfflineChangeType NOT_SYMLINK = new OfflineChangeType(8, "-symlink");
    private final String text;

    private OfflineChangeType(int value, String text) {
        super(value);
        this.text = text;
    }

    @Override
    public String toString() {
        return this.text;
    }

    public boolean isPropertyChange() {
        return this.getValue() >= 5 && this.getValue() <= 8;
    }

    public PropertyValue getPropertyValue() {
        if (!this.isPropertyChange()) {
            return null;
        }
        if (this.equals(EXEC)) {
            return PropertyConstants.EXECUTABLE_ENABLED_VALUE;
        }
        if (this.equals(NOT_EXEC)) {
            return PropertyConstants.EXECUTABLE_DISABLED_VALUE;
        }
        if (this.equals(SYMLINK)) {
            return PropertyConstants.IS_SYMLINK;
        }
        if (this.equals(NOT_SYMLINK)) {
            return PropertyConstants.NOT_SYMLINK;
        }
        return null;
    }
}

