/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.path;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemValidationError;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ServerPath {
    public static final String ROOT_NAME_ONLY = "$";
    public static final String ROOT = "$/";
    public static final char[] SEPARATOR_CHARACTERS = new char[]{'/', '\\'};
    public static final char PREFERRED_SEPARATOR_CHARACTER = '/';
    public static final int MAXIMUM_COMPONENT_LENGTH = 256;
    public static final Comparator<String> TOP_DOWN_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String path1, String path2) {
            return ServerPath.compareTopDown(path1, path2);
        }
    };
    public static final Comparator<String> BOTTOM_UP_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String path1, String path2) {
            return ServerPath.compareBottomUp(path1, path2);
        }
    };

    public static final boolean equals(String path1, String path2) {
        return ServerPath.equals(path1, path2, true);
    }

    public static final int hashCode(String path) {
        return LocaleInvariantStringHelpers.caseInsensitiveHashCode(path);
    }

    public static final boolean equals(String path1, String path2, boolean ignoreCase) {
        if (path1 == path2) {
            return true;
        }
        if (ignoreCase) {
            return path1.equalsIgnoreCase(path2);
        }
        return path1.equals(path2);
    }

    public static ItemValidationError checkServerItem(AtomicReference<String> item, String parameterName, boolean allowNull, boolean allowWildcards, boolean allow8Dot3Paths, boolean checkReservedCharacters) {
        return ServerPath.checkServerItem(item, parameterName, allowNull, allowWildcards, allow8Dot3Paths, checkReservedCharacters, 259);
    }

    public static ItemValidationError checkServerItem(AtomicReference<String> item, String parameterName, boolean allowNull, boolean allowWildcards, boolean allow8Dot3Paths, boolean checkReservedCharacters, int maxServerPathLength) {
        String inItem = item.get();
        if (inItem == null || inItem.length() == 0) {
            if (!allowNull) {
                throw new IllegalArgumentException(parameterName);
            }
        } else {
            if (!allowWildcards && ServerPath.isWildcard(inItem)) {
                return ItemValidationError.WILDCARD_NOT_ALLOWED;
            }
            if (inItem.length() > maxServerPathLength) {
                return ItemValidationError.REPOSITORY_PATH_TOO_LONG;
            }
            item.set(ServerPath.canonicalize(inItem));
            if (!allow8Dot3Paths) {
                LocalPath.check8Dot3Aliases(inItem);
            }
        }
        return ItemValidationError.NONE;
    }

    public static final boolean isRootFolder(String path) {
        return ROOT.equals(path);
    }

    public static final boolean isChild(String parentPath, String possibleChild) throws ServerPathFormatException {
        Check.notNull(parentPath, "parentPath");
        Check.notNull(possibleChild, "possibleChild");
        parentPath = ServerPath.canonicalize(parentPath);
        possibleChild = ServerPath.canonicalize(possibleChild);
        if (parentPath.regionMatches(true, 0, possibleChild, 0, parentPath.length())) {
            if (parentPath.length() == possibleChild.length()) {
                return true;
            }
            if (ServerPath.isSeparator(parentPath.charAt(parentPath.length() - 1))) {
                return true;
            }
            if (ServerPath.isSeparator(possibleChild.charAt(parentPath.length()))) {
                return true;
            }
        }
        return false;
    }

    public static final boolean matchesWildcard(String firstItemPath, String secondItemFolderPath, String secondItemWildcardPattern, boolean recursive) throws ServerPathFormatException {
        Check.notNull(firstItemPath, "firstItemPath");
        Check.notNull(secondItemFolderPath, "secondItemFolderPath");
        firstItemPath = ServerPath.canonicalize(firstItemPath);
        secondItemFolderPath = ServerPath.canonicalize(secondItemFolderPath);
        String firstItemFolder = null;
        String firstItemName = null;
        if (secondItemWildcardPattern == null || secondItemWildcardPattern.length() == 0) {
            firstItemFolder = firstItemPath;
        } else {
            firstItemFolder = ServerPath.getParent(firstItemPath);
            if (!ServerPath.equals(firstItemFolder, firstItemPath)) {
                firstItemName = ServerPath.getFileName(firstItemPath);
            }
        }
        if (recursive ? !ServerPath.isChild(secondItemFolderPath, firstItemFolder) : !ServerPath.equals(firstItemFolder, secondItemFolderPath)) {
            return false;
        }
        if (firstItemName == null) {
            return true;
        }
        return ItemPath.matchesWildcardFile(firstItemName, 0, secondItemWildcardPattern, 0);
    }

    public static final String canonicalize(String serverPath) throws ServerPathFormatException {
        Check.notNull(serverPath, "serverPath");
        int serverPathLength = serverPath.length();
        if (serverPathLength == 0) {
            throw new ServerPathFormatException(Messages.getString("ServerPath.AServerPathCannotBeAnEmptyString"));
        }
        if (ServerPath.isCanonicalizedPath(serverPath, true)) {
            return serverPath;
        }
        ArrayList<String> newComponents = new ArrayList<String>();
        StringBuilder currentComponent = new StringBuilder(serverPathLength);
        int position = 0;
        if (serverPath.equals(ROOT_NAME_ONLY)) {
            serverPath = ROOT;
            serverPathLength = 2;
        }
        if (serverPath.charAt(0) == '$') {
            ++position;
        }
        newComponents.add(ROOT_NAME_ONLY);
        if (position >= serverPathLength || !ServerPath.isSeparator(serverPath.charAt(position))) {
            throw new ServerPathFormatException(MessageFormat.format(Messages.getString("ServerPath.AServerPathMustBeAbsoluteFormat"), serverPath));
        }
        boolean illegalDollarInPath = false;
        while (position <= serverPathLength) {
            if (position == serverPathLength || ServerPath.isSeparator(serverPath.charAt(position))) {
                if (currentComponent.length() != 0 && !currentComponent.toString().equals(".")) {
                    if (currentComponent.toString().equals("..")) {
                        if (newComponents.size() <= 1) {
                            throw new ServerPathFormatException(MessageFormat.format(Messages.getString("ServerPath.ServerPathRefersToInvalidPathOutsideFolderFormat"), serverPath, ROOT));
                        }
                        newComponents.remove(newComponents.size() - 1);
                    } else {
                        String cleaned = ServerPath.cleanupComponent(currentComponent).toString();
                        if (cleaned.length() != 0) {
                            if (cleaned.length() > 256) {
                                throw new ServerPathFormatException(MessageFormat.format(Messages.getString("ServerPath.ServerPathComponentIsLongerthanTheMaximumCharactersFormat"), cleaned, 256));
                            }
                            if (FileHelpers.isReservedName(cleaned)) {
                                throw new ServerPathFormatException(MessageFormat.format(Messages.getString("ServerPath.ServerPathContainsAnInvalidDirectoryComponentFormat"), serverPath, cleaned));
                            }
                            if (cleaned.charAt(0) == '$') {
                                illegalDollarInPath = true;
                            }
                            newComponents.add(cleaned);
                        }
                    }
                }
                currentComponent.setLength(0);
            } else if (ServerPath.isValidPathCharacter(serverPath.charAt(position))) {
                currentComponent.append(serverPath.charAt(position));
            } else {
                char c = serverPath.charAt(position);
                char c_safe = c < ' ' ? (char)'?' : (char)c;
                throw new ServerPathFormatException(MessageFormat.format(Messages.getString("ServerPath.TheCharacterIsNotPermittedInServerPathsFormat"), position + 1, String.format("%04x", c), Character.valueOf(c_safe), serverPath.replace(c, c_safe)));
            }
            ++position;
        }
        if (newComponents.size() == 1) {
            return ROOT;
        }
        StringBuilder newPath = new StringBuilder();
        for (int i = 0; i < newComponents.size(); ++i) {
            if (i > 0) {
                newPath.append('/');
            }
            newPath.append((String)newComponents.get(i));
        }
        if (illegalDollarInPath) {
            throw new ServerPathFormatException(MessageFormat.format(Messages.getString("ItemPath.InvalidPathDollarSignFormat"), newPath.toString()));
        }
        return newPath.toString();
    }

    public static boolean isCanonicalizedPath(String serverItem, boolean allowSemicolon) {
        if (serverItem.length() > 399) {
            return false;
        }
        if (!serverItem.startsWith(ROOT)) {
            return false;
        }
        if (2 == serverItem.length()) {
            return true;
        }
        if (serverItem.length() > 2 && serverItem.charAt(serverItem.length() - 1) == '/') {
            return false;
        }
        int pathPartLength = 0;
        for (int i = 2; i < serverItem.length(); ++i) {
            char c = serverItem.charAt(i);
            if (c == '/') {
                if (!ServerPath.isCanonicalizedPathPart(serverItem, i, pathPartLength)) {
                    return false;
                }
                pathPartLength = 0;
                continue;
            }
            if (0 == pathPartLength && c == ROOT.charAt(0)) {
                return false;
            }
            if (!FileHelpers.isValidNTFSFileNameCharacter(c)) {
                return false;
            }
            if (!allowSemicolon && c == ';') {
                return false;
            }
            if (c == '*' || c == '?') {
                return false;
            }
            ++pathPartLength;
        }
        return ServerPath.isCanonicalizedPathPart(serverItem, serverItem.length(), pathPartLength);
    }

    private static boolean isCanonicalizedPathPart(String serverItem, int i, int pathPartLength) {
        if (0 == pathPartLength) {
            return false;
        }
        if (2 == pathPartLength ? serverItem.charAt(i - 1) == '.' && serverItem.charAt(i - 2) == '.' : (3 == pathPartLength || 4 == pathPartLength ? FileHelpers.isReservedName(serverItem.substring(i - pathPartLength, i)) : pathPartLength > 256)) {
            return false;
        }
        return serverItem.charAt(i - 1) != '.' && !Character.isWhitespace(serverItem.charAt(i - 1));
    }

    public static String makeRelative(String serverPath, String relativeTo) {
        Check.notNull(serverPath, "serverPath");
        Check.notNull(relativeTo, "relativeTo");
        if (serverPath.regionMatches(true, 0, relativeTo, 0, relativeTo.length())) {
            if (serverPath.length() == relativeTo.length()) {
                return "";
            }
            if (relativeTo.length() > 0 && ServerPath.isSeparator(relativeTo.charAt(relativeTo.length() - 1))) {
                return serverPath.substring(relativeTo.length());
            }
            if (ServerPath.isSeparator(serverPath.charAt(relativeTo.length()))) {
                return serverPath.substring(relativeTo.length() + 1);
            }
        }
        return serverPath;
    }

    public static String makeLocal(String serverPath, String relativeToServerPath, String localRoot) {
        Check.notNull(serverPath, "serverPath");
        Check.notNull(relativeToServerPath, "relativeToServerPath");
        Check.notNull(localRoot, "localRoot");
        String relativePart = ServerPath.makeRelative(ServerPath.canonicalize(serverPath), relativeToServerPath);
        StringBuilder relativeBuffer = new StringBuilder(relativePart);
        for (int j = 0; j < SEPARATOR_CHARACTERS.length; ++j) {
            for (int k = 0; k < relativeBuffer.length(); ++k) {
                if (relativeBuffer.charAt(k) != SEPARATOR_CHARACTERS[j]) continue;
                relativeBuffer.setCharAt(k, File.separatorChar);
            }
        }
        return LocalPath.combine(localRoot, relativeBuffer.toString());
    }

    private static final StringBuilder cleanupComponent(StringBuilder s) {
        while (s.length() > 0 && (s.charAt(s.length() - 1) == '.' || Character.isWhitespace(s.charAt(s.length() - 1)))) {
            s.setLength(s.length() - 1);
        }
        return s;
    }

    public static final boolean isValidPathCharacter(char c) {
        char[] invalidCharacters = new char[]{'\"', '/', ':', '<', '>', '\\', '|'};
        if (c <= '\u001f') {
            return false;
        }
        for (int i = 0; i < invalidCharacters.length; ++i) {
            if (invalidCharacters[i] != c) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSeparator(char c) {
        for (int i = 0; i < SEPARATOR_CHARACTERS.length; ++i) {
            if (SEPARATOR_CHARACTERS[i] != c) continue;
            return true;
        }
        return false;
    }

    public static final boolean isServerPath(String path) {
        Check.notNull(path, "path");
        if (path.length() < 2) {
            return false;
        }
        return path.startsWith(ROOT) || path.startsWith("$\\");
    }

    public static final int compareTopDown(String pathA, String pathB) {
        return pathA.compareToIgnoreCase(pathB);
    }

    public static final int compareBottomUp(String pathA, String pathB) {
        return 0 - ServerPath.compareTopDown(pathA, pathB);
    }

    public static final String getFirstNode(StringBuilder path) {
        Check.notNull(path, "path");
        int i = 0;
        for (i = 0; i < path.length() && !ServerPath.isSeparator(path.charAt(i)); ++i) {
        }
        String parent = null;
        if (i == path.length()) {
            parent = path.toString();
            path.delete(0, path.length());
        } else if (i == path.length() - 1) {
            parent = path.substring(0, i);
            path.delete(0, path.length());
        } else {
            parent = path.substring(0, i);
            path.delete(0, i + 1);
        }
        return parent;
    }

    public static boolean isWildcard(String serverPath) {
        Check.notNull(serverPath, "serverPath");
        int largestIndex = -1;
        for (int i = 0; i < SEPARATOR_CHARACTERS.length; ++i) {
            largestIndex = Math.max(largestIndex, serverPath.lastIndexOf(SEPARATOR_CHARACTERS[i]));
        }
        if (largestIndex == serverPath.length() - 1) {
            return false;
        }
        return Wildcard.isWildcard(serverPath.substring(largestIndex + 1));
    }

    public static String getParent(String serverPath) {
        Check.notNull(serverPath, "serverPath");
        int largestIndex = -1;
        for (int i = 0; i < SEPARATOR_CHARACTERS.length; ++i) {
            largestIndex = Math.max(largestIndex, serverPath.lastIndexOf(SEPARATOR_CHARACTERS[i]));
        }
        if (largestIndex != -1) {
            String parent = serverPath.substring(0, largestIndex);
            if (ServerPath.equals(parent, ROOT_NAME_ONLY)) {
                return ROOT;
            }
            return parent;
        }
        return serverPath + SEPARATOR_CHARACTERS[0];
    }

    public static String getFileName(String serverPath) {
        Check.notNull(serverPath, "serverPath");
        int largestIndex = -1;
        for (int i = 0; i < SEPARATOR_CHARACTERS.length; ++i) {
            largestIndex = Math.max(largestIndex, serverPath.lastIndexOf(SEPARATOR_CHARACTERS[i]));
        }
        if (largestIndex == -1) {
            return serverPath;
        }
        if (largestIndex + 1 < serverPath.length()) {
            return serverPath.substring(largestIndex + 1);
        }
        return "";
    }

    public static boolean isDirectChild(String serverFolderPath, String serverPossibleChild) {
        Check.notNull(serverFolderPath, "serverFolderPath");
        Check.notNull(serverPossibleChild, "serverPossibleChild");
        return ServerPath.equals(serverFolderPath, ServerPath.getParent(serverPossibleChild));
    }

    public static String getTeamProject(String serverPath) {
        if (serverPath == null) {
            return null;
        }
        try {
            serverPath = ServerPath.canonicalize(serverPath);
        }
        catch (ServerPathFormatException e) {
            return null;
        }
        if (serverPath.length() <= 2) {
            return serverPath;
        }
        int seperatorPos = serverPath.indexOf(47, 2);
        if (seperatorPos < 0) {
            return serverPath;
        }
        return serverPath.substring(0, seperatorPos);
    }

    public static String[] getTeamProjects(String[] serverPaths) {
        HashSet<String> projects = new HashSet<String>();
        if (serverPaths != null) {
            for (int i = 0; i < serverPaths.length; ++i) {
                projects.add(ServerPath.getTeamProject(serverPaths[i]));
            }
        }
        return projects.toArray(new String[projects.size()]);
    }

    public static String getTeamProjectName(String serverPath) {
        String projectName = null;
        if (serverPath != null && serverPath.length() > 2) {
            String fullProject = ServerPath.getTeamProject(serverPath);
            if (fullProject == null) {
                return null;
            }
            return fullProject.substring(2);
        }
        return projectName;
    }

    public static boolean isTeamProject(String serverFolder) {
        Check.notNull(serverFolder, "item");
        return ServerPath.getFolderDepth(serverFolder, 2) == 1;
    }

    public static int getFolderDepth(String serverPath) {
        return ServerPath.getFolderDepth(serverPath, Integer.MAX_VALUE);
    }

    public static int getFolderDepth(String serverPath, int maxDepth) {
        int depth;
        Check.notNull(serverPath, "serverPath");
        if (!ServerPath.equals(serverPath, ROOT)) {
            int i = serverPath.indexOf("/");
            for (depth = 0; i != -1 && maxDepth > depth; ++depth) {
                i = serverPath.indexOf("/", i + 1);
            }
        }
        return depth;
    }

    public static String combine(String parent, String relative) {
        String combinedString;
        Check.notNullOrEmpty(parent, "parent");
        Check.notNull(relative, "relative");
        if (relative.length() == 0 || relative.length() == 1 && relative.charAt(0) == '$') {
            combinedString = parent;
        } else if (ServerPath.isSeparator(relative.charAt(0)) || relative.charAt(0) == '$' && relative.length() >= 2 && ServerPath.isSeparator(relative.charAt(1))) {
            combinedString = relative;
        } else {
            String separator = "";
            if (parent.length() > 0 && parent.charAt(parent.length() - 1) != '/') {
                separator = "/";
            }
            combinedString = relative.charAt(0) == '$' ? parent + separator + relative.substring(1) : parent + separator + relative;
        }
        return ServerPath.canonicalize(combinedString);
    }

    public static String[] split(String serverPath) {
        Check.notNull(serverPath, "serverPath");
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder currentSegment = new StringBuilder();
        int len = serverPath.length();
        for (int i = 0; i < len; ++i) {
            char c = serverPath.charAt(i);
            if (ServerPath.isSeparator(c)) {
                if (currentSegment.length() <= 0) continue;
                String s = currentSegment.toString();
                if (ROOT_NAME_ONLY.equals(s)) {
                    s = ROOT;
                }
                segments.add(s);
                currentSegment.setLength(0);
                continue;
            }
            currentSegment.append(c);
        }
        if (currentSegment.length() > 0) {
            segments.add(currentSegment.toString());
        }
        return segments.toArray(new String[segments.size()]);
    }

    public static String[] getHierarchy(String serverPath) {
        Check.notNull(serverPath, "serverPath");
        String[] segments = ServerPath.split(serverPath);
        String[] hierarchy = new String[segments.length];
        for (int i = segments.length; i > 0; --i) {
            String currentPath;
            StringBuilder currentPathBuffer = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                currentPathBuffer.append(segments[j]);
                if (j <= 0 || j >= i - 1) continue;
                currentPathBuffer.append('/');
            }
            hierarchy[i - 1] = currentPath = currentPathBuffer.toString();
        }
        return hierarchy;
    }

    public static String getCommonParent(String path1, String path2) {
        if (null == path1 && null == path2) {
            throw new IllegalArgumentException("path1");
        }
        if (null == path1) {
            return path2;
        }
        if (null == path2) {
            return path1;
        }
        String commonParent = path1;
        while (!ServerPath.isChild(commonParent, path2)) {
            commonParent = ServerPath.getParent(commonParent);
        }
        return commonParent;
    }

    public static void checkForIllegalDollarInPath(String path) {
        ItemPath.checkForIllegalDollarInPath(path);
    }
}

