/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.util.FileEncoding;
import java.util.Calendar;
import ms.tfs.versioncontrol.clientservices._03._ExtendedItem;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;

public class ExtendedItem
extends WebServiceObjectWrapper
implements Comparable {
    public ExtendedItem() {
        super(new _ExtendedItem());
    }

    public ExtendedItem(_ExtendedItem item) {
        super(item);
        String displayName = item.getLownerdisp();
        if (displayName == null || displayName.length() == 0) {
            item.setLownerdisp(item.getLowner());
        }
    }

    public ExtendedItem(LocalPendingChangesTable pc, WorkspaceLocalItem localItem, LocalPendingChange pendingChange) {
        this(new _ExtendedItem());
        this.getWebServiceObject().setEnc(localItem.getEncoding());
        this.getWebServiceObject().setItemid(localItem.getItemID());
        if (localItem.isDirectory()) {
            this.getWebServiceObject().setType(ItemType.FOLDER.getWebServiceObject());
        } else {
            this.getWebServiceObject().setType(ItemType.FILE.getWebServiceObject());
        }
        this.getWebServiceObject().setLocal(localItem.isDeleted() ? "" : localItem.getLocalItem());
        this.getWebServiceObject().setSitem(localItem.getServerItem());
        this.getWebServiceObject().setLatest(localItem.getVersion());
        this.getWebServiceObject().setLver(localItem.isDeleted() ? 0 : localItem.getVersion());
        if (pendingChange == null) {
            if (localItem.isCommitted()) {
                this.getWebServiceObject().setTitem(pc.getTargetServerItemForCommittedServerItem(localItem.getServerItem()));
            } else {
                this.getWebServiceObject().setTitem(localItem.getServerItem());
            }
            this.getWebServiceObject().setPropertyValues((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, localItem.getPropertyValues()));
        } else {
            this.getWebServiceObject().setTitem(pendingChange.getTargetServerItem());
            this.getWebServiceObject().setChg(pendingChange.getChangeType().getWebServiceObject());
            this.getWebServiceObject().setDid(pendingChange.getDeletionID());
            this.getWebServiceObject().setPropertyValues((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, pendingChange.getPropertyValues()));
        }
    }

    public _ExtendedItem getWebServiceObject() {
        return (_ExtendedItem)this.webServiceObject;
    }

    public int compareTo(Object otherItem) {
        ExtendedItem other = (ExtendedItem)otherItem;
        int res = ServerPath.compareTopDown(this.getTargetServerItem(), other.getTargetServerItem());
        if (res != 0) {
            return res;
        }
        if (this.getDeletionID() < other.getDeletionID()) {
            return -1;
        }
        if (this.getDeletionID() > other.getDeletionID()) {
            return 1;
        }
        return 0;
    }

    public int getLocalVersion() {
        return this.getWebServiceObject().getLver();
    }

    public void setLocalVersion(int version) {
        this.getWebServiceObject().setLver(version);
    }

    public int getDeletionID() {
        return this.getWebServiceObject().getDid();
    }

    public void setDeletionID(int did) {
        this.getWebServiceObject().setDid(did);
    }

    public int getLatestVersion() {
        return this.getWebServiceObject().getLatest();
    }

    public void setLatestVersion(int version) {
        this.getWebServiceObject().setLatest(version);
    }

    public ItemType getItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getType());
    }

    public void setItemType(ItemType type) {
        this.getWebServiceObject().setType(type.getWebServiceObject());
    }

    public FileEncoding getEncoding() {
        return new FileEncoding(this.getWebServiceObject().getEnc());
    }

    public void setEncoding(FileEncoding encoding) {
        this.getWebServiceObject().setEnc(encoding.getCodePage());
    }

    public int getItemID() {
        return this.getWebServiceObject().getItemid();
    }

    public void setItemID(int itemid) {
        this.getWebServiceObject().setItemid(itemid);
    }

    public String getLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getLocal());
    }

    public void setLocalItem(String item) {
        this.getWebServiceObject().setLocal(LocalPath.nativeToTFS(item));
    }

    public String getTargetServerItem() {
        return this.getWebServiceObject().getTitem();
    }

    public void setTargetServerItem(String item) {
        this.getWebServiceObject().setTitem(item);
    }

    public String getSourceServerItem() {
        return this.getWebServiceObject().getSitem();
    }

    public void setSourceServerItem(String item) {
        this.getWebServiceObject().setSitem(item);
    }

    public ChangeType getPendingChange() {
        return new ChangeType(this.getWebServiceObject().getChg(), this.getWebServiceObject().getChgEx());
    }

    public void setPendingChange(ChangeType changeType) {
        this.getWebServiceObject().setChg(changeType.getWebServiceObject());
    }

    public boolean hasOtherPendingChange() {
        return this.getWebServiceObject().isOchg();
    }

    public void setHasOtherPendingChange(boolean oChange) {
        this.getWebServiceObject().setOchg(oChange);
    }

    public LockLevel getLockLevel() {
        return LockLevel.fromWebServiceObject(this.getWebServiceObject().getLock());
    }

    public void setLockLevel(LockLevel lock) {
        this.getWebServiceObject().setLock(lock.getWebServiceObject());
    }

    public String getLockOwner() {
        return this.getWebServiceObject().getLowner();
    }

    public void setLockOwner(String owner) {
        this.getWebServiceObject().setLowner(owner);
    }

    public String getLockOwnerDisplayName() {
        return this.getWebServiceObject().getLownerdisp();
    }

    public boolean hasLocalChange() {
        ChangeType change = new ChangeType(this.getWebServiceObject().getChg(), this.getWebServiceObject().getChgEx());
        return !change.isEmpty();
    }

    public Calendar getCheckinDate() {
        return this.getWebServiceObject().getDate();
    }

    public void setCheckinDate(Calendar date) {
        this.getWebServiceObject().setDate(date);
    }

    public boolean isBranch() {
        return this.getWebServiceObject().isIsBranch();
    }

    public PropertyValue[] getPropertyValues() {
        return PropertyUtils.selectUnique((PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getPropertyValues()));
    }
}

