/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Mapping;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PathTranslation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderComparator;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderComparatorType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderType;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import ms.tfs.versioncontrol.clientservices._03._WorkingFolder;

public final class WorkingFolder
extends Mapping
implements Cloneable {
    public static final String DEPTH_ONE_STRING = "*";

    public WorkingFolder(_WorkingFolder wf) {
        super(wf);
    }

    public WorkingFolder(String serverItem, String localItem) {
        this(serverItem, localItem, WorkingFolderType.MAP);
    }

    public WorkingFolder(String serverItem, String localItem, WorkingFolderType type) {
        this(serverItem, localItem, type, RecursionType.FULL);
    }

    public WorkingFolder(String serverItem, String localItem, WorkingFolderType type, RecursionType recursion) {
        super(new _WorkingFolder(serverItem, type.getWebServiceObject(), Mapping.getDepthFromRecursion(recursion), LocalPath.nativeToTFS(localItem)));
        if (!ServerPath.isServerPath(serverItem)) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("WorkingFolder.PathIsNotValidServerPathFormat"), serverItem));
        }
    }

    public _WorkingFolder getWebServiceObject() {
        return (_WorkingFolder)this.webServiceObject;
    }

    public String getLocalItemRaw() {
        return this.getWebServiceObject().getLocal();
    }

    public String getLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getLocal());
    }

    public void setLocalItem(String item) {
        Check.notNull(item, "item");
        this.getWebServiceObject().setLocal(LocalPath.nativeToTFS(item));
    }

    @Override
    public String toString() {
        return MessageFormat.format("WorkingFolder [getServerItem()={0}, getLocalItem()={1}, getType()={2}, getDepth()={3}, isCloaked()={4}]", this.getServerItem(), this.getLocalItem(), this.getType(), this.getDepth(), this.isCloaked());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WorkingFolder)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        WorkingFolder other = (WorkingFolder)obj;
        boolean serverItemsEqual = ServerPath.equals(this.getServerItem(), other.getServerItem());
        if (this.isCloaked() && other.isCloaked()) {
            return serverItemsEqual;
        }
        if (this.isCloaked() || other.isCloaked()) {
            return false;
        }
        if (serverItemsEqual && LocalPath.equals(this.getLocalItem(), other.getLocalItem()) && this.getDepth().equals(other.getDepth())) {
            return this.getDepth() == other.getDepth();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static boolean areSetsEqual(WorkingFolder[] set1, WorkingFolder[] set2) {
        int i;
        Check.notNull(set1, "set1");
        Check.notNull(set2, "set2");
        if (set1.length != set2.length) {
            return false;
        }
        WorkingFolderComparator c = new WorkingFolderComparator(WorkingFolderComparatorType.SERVER_PATH);
        Arrays.sort(set1, c);
        Arrays.sort(set2, c);
        for (i = 0; i < set1.length && set1[i].getType() == set2[i].getType() && ServerPath.equals(set1[i].getServerItem(), set2[i].getServerItem()) && (set1[i].getType() != WorkingFolderType.MAP || LocalPath.equals(set1[i].getLocalItem(), set2[i].getLocalItem())); ++i) {
        }
        return i == set1.length;
    }

    public static Iterable<String> getWorkspaceRoots(WorkingFolder[] workingFolders) {
        Arrays.sort(workingFolders, new WorkingFolderComparator(WorkingFolderComparatorType.LOCAL_PATH));
        ArrayList<String> workspaceRoots = new ArrayList<String>();
        String currentRoot = null;
        for (WorkingFolder workingFolder : workingFolders) {
            String localItem = workingFolder.getLocalItem();
            if (null == localItem || null != currentRoot && LocalPath.isChild(currentRoot, localItem)) continue;
            if (null != currentRoot) {
                workspaceRoots.add(currentRoot);
            }
            currentRoot = workingFolder.getLocalItem();
        }
        if (null != currentRoot) {
            workspaceRoots.add(currentRoot);
        }
        return workspaceRoots;
    }

    public String translateServerItemToLocalItem(String serverItem) {
        if (null == this.getLocalItem()) {
            return null;
        }
        WorkingFolder[] folders = new WorkingFolder[]{this};
        PathTranslation translation = WorkingFolder.translateServerItemToLocalItem(serverItem, folders, false);
        if (translation == null) {
            return this.getLocalItem();
        }
        return translation.getTranslatedPath();
    }

    public String translateLocalItemToServerItem(String localItem) {
        if (null == this.getLocalItem()) {
            return null;
        }
        WorkingFolder[] folders = new WorkingFolder[]{this};
        PathTranslation translation = WorkingFolder.translateLocalItemToServerItem(localItem, folders);
        if (translation == null) {
            return this.getServerItem();
        }
        return translation.getTranslatedPath();
    }

    public Object clone() {
        return new WorkingFolder(this.getServerItem(), this.getLocalItem(), this.getType(), this.getDepth());
    }

    public static WorkingFolder[] clone(WorkingFolder[] folders) {
        if (folders == null) {
            return null;
        }
        WorkingFolder[] ret = new WorkingFolder[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            ret[i] = new WorkingFolder(folders[i].getServerItem(), folders[i].getLocalItem(), folders[i].getType(), folders[i].getDepth());
        }
        return ret;
    }

    public static String[] extractMappedPaths(WorkingFolder[] workingFolders) {
        if (workingFolders == null) {
            return new String[0];
        }
        ArrayList<String> mappedPaths = new ArrayList<String>(workingFolders.length);
        for (WorkingFolder wf : workingFolders) {
            if (wf.getType() != WorkingFolderType.MAP) continue;
            mappedPaths.add(wf.getLocalItem());
        }
        return mappedPaths.toArray(new String[mappedPaths.size()]);
    }

    public static String getLocalItemForServerItem(String serverItem, WorkingFolder[] folders) {
        return WorkingFolder.getLocalItemForServerItem(serverItem, folders, true);
    }

    public static String getLocalItemForServerItem(String serverItem, WorkingFolder[] folders, boolean detectImplicitCloak) {
        String reverseServer;
        if (serverItem == null) {
            return null;
        }
        PathTranslation translation = WorkingFolder.translateServerItemToLocalItem(serverItem, folders, false);
        if (translation == null || translation.isCloaked()) {
            return null;
        }
        String localItem = translation.getTranslatedPath();
        if (detectImplicitCloak && null != localItem && ((reverseServer = WorkingFolder.getServerItemForLocalItem(localItem, folders)) == null || !ServerPath.equals(reverseServer, serverItem))) {
            return null;
        }
        return localItem;
    }

    public static String getServerItemForLocalItem(String localItem, WorkingFolder[] folders) {
        if (localItem == null) {
            return null;
        }
        PathTranslation translation = WorkingFolder.translateLocalItemToServerItem(localItem, folders);
        if (translation == null || translation.isCloaked()) {
            return null;
        }
        return translation.getTranslatedPath();
    }

    public static PathTranslation translateLocalItemToServerItem(String localPath, WorkingFolder[] folders) {
        Check.notNullOrEmpty(localPath, "localPath");
        Check.notNull(folders, "folders");
        int localItemDepth = -1;
        int mappingLength = 0;
        WorkingFolder mapping = null;
        RecursionType depth = RecursionType.FULL;
        for (WorkingFolder wf : folders) {
            String wfLocalItem;
            if (wf == null || wf.isCloaked() || !LocalPath.isChild(wfLocalItem = wf.getLocalItem(), localPath) || wfLocalItem.length() <= mappingLength) continue;
            mapping = wf;
            mappingLength = wfLocalItem.length();
            depth = wf.getDepth();
            if (wf.getDepth() != RecursionType.ONE_LEVEL) continue;
            int mappingDepth = LocalPath.getFolderDepth(wfLocalItem);
            if (localItemDepth < 0) {
                localItemDepth = LocalPath.getFolderDepth(localPath);
            }
            if (mappingDepth + 1 == localItemDepth) {
                depth = RecursionType.NONE;
                continue;
            }
            if (mappingDepth == localItemDepth) continue;
            mapping = null;
        }
        if (mapping != null) {
            String mappingLocalItem = mapping.getLocalItem();
            String mappingServerItem = mapping.getServerItem();
            String serverPath = LocalPath.makeServer(localPath, mappingLocalItem, mappingServerItem);
            boolean isCloaked = false;
            int mappingServerPathLength = mappingServerItem.length();
            for (WorkingFolder wf : folders) {
                String wfServerItem;
                if (wf == null || !wf.isCloaked() || (wfServerItem = wf.getServerItem()).length() <= mappingServerPathLength || !ServerPath.isChild(wfServerItem, serverPath)) continue;
                isCloaked = true;
                break;
            }
            return new PathTranslation(localPath, serverPath, isCloaked, depth);
        }
        return null;
    }

    public static PathTranslation translateServerItemToLocalItem(String serverPath, WorkingFolder[] folders, boolean interpretOneLevelMappingsNormally) {
        boolean isCloaked;
        Check.notNullOrEmpty(serverPath, "serverPath");
        Check.notNull(folders, "folders");
        int serverItemDepth = -1;
        int mappingLength = 0;
        Mapping mapping = null;
        RecursionType depth = RecursionType.FULL;
        for (WorkingFolder wf : folders) {
            if (wf == null || !ServerPath.isChild(wf.getServerItem(), serverPath) || wf.getServerItem().length() <= mappingLength) continue;
            mapping = wf;
            mappingLength = wf.getServerItem().length();
            RecursionType recursionType = depth = interpretOneLevelMappingsNormally ? wf.getDepth() : RecursionType.FULL;
            if (wf.getDepth() != RecursionType.ONE_LEVEL || !interpretOneLevelMappingsNormally) continue;
            int mappingDepth = ServerPath.getFolderDepth(wf.getServerItem());
            if (serverItemDepth < 0) {
                serverItemDepth = ServerPath.getFolderDepth(serverPath);
            }
            if (mappingDepth + 1 == serverItemDepth) {
                depth = RecursionType.NONE;
                continue;
            }
            if (mappingDepth == serverItemDepth) continue;
            mapping = null;
        }
        boolean bl = isCloaked = mapping != null ? mapping.isCloaked() : false;
        if (mapping != null) {
            String localPath = isCloaked ? null : ServerPath.makeLocal(serverPath, mapping.getServerItem(), ((WorkingFolder)mapping).getLocalItem());
            return new PathTranslation(serverPath, localPath, isCloaked, depth);
        }
        return null;
    }
}

