/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import java.text.MessageFormat;

public class InternalWorkspaceConflictInfo {
    public static final InternalWorkspaceConflictInfo[] EMPTY_ARRAY = new InternalWorkspaceConflictInfo[0];
    private final WorkspaceInfo primaryWorkspace;
    private final WorkspaceInfo secondaryWorkspace;
    private final String conflictingPath;

    public InternalWorkspaceConflictInfo(WorkspaceInfo primaryWorkspace, WorkspaceInfo secondaryWorkspace, String conflictingPath) {
        this.primaryWorkspace = primaryWorkspace;
        this.secondaryWorkspace = secondaryWorkspace;
        this.conflictingPath = conflictingPath;
    }

    public WorkspaceInfo getPrimaryWorkspace() {
        return this.primaryWorkspace;
    }

    public WorkspaceInfo getSecondaryWorkspace() {
        return this.secondaryWorkspace;
    }

    public String getConflictingPath() {
        return this.conflictingPath;
    }

    public String getWarningUI() {
        return MessageFormat.format(Messages.getString("InternalWorkspaceConflictInfo.ConflictingWorkspaceInTheCacheFormat"), this.conflictingPath, this.primaryWorkspace.getDisplayName(), this.primaryWorkspace.getServerURI(), this.secondaryWorkspace.getDisplayName(), this.secondaryWorkspace.getServerURI());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InternalWorkspaceConflictInfo)) {
            return false;
        }
        InternalWorkspaceConflictInfo other = (InternalWorkspaceConflictInfo)obj;
        return this.primaryWorkspace.equals(other.primaryWorkspace) && this.secondaryWorkspace.equals(other.secondaryWorkspace) && LocalPath.equals(this.conflictingPath, other.conflictingPath);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.primaryWorkspace.hashCode();
        result = result * 37 + this.secondaryWorkspace.hashCode();
        result = result * 37 + LocalPath.hashCode(this.conflictingPath);
        return result;
    }
}

