/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal;

import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.util.Check;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class CheckinItem {
    private final int itemID;
    private final String serverItem;

    public CheckinItem(String serverItem, int itemID) {
        Check.notNull(serverItem, "serverItem");
        this.serverItem = serverItem;
        this.itemID = itemID;
    }

    public static Map<String, CheckinItem> fromPendingChanges(PendingChange[] pendingChanges) {
        if (pendingChanges == null || pendingChanges.length == 0) {
            return CheckinItem.newMap();
        }
        TreeMap<String, CheckinItem> checkinItems = CheckinItem.newMap();
        for (PendingChange change : pendingChanges) {
            checkinItems.put(change.getServerItem(), new CheckinItem(change.getServerItem(), change.getItemID()));
        }
        return checkinItems;
    }

    public static Map<String, CheckinItem> fromServerPaths(Collection<String> serverPaths) {
        if (serverPaths == null || serverPaths.size() == 0) {
            return CheckinItem.newMap();
        }
        TreeMap<String, CheckinItem> checkinItems = CheckinItem.newMap();
        for (String serverItem : serverPaths) {
            checkinItems.put(serverItem, new CheckinItem(serverItem, 0));
        }
        return checkinItems;
    }

    public static Map<String, CheckinItem> fromCheckinItems(Map<String, CheckinItem> sourceCheckinItems) {
        if (sourceCheckinItems == null || sourceCheckinItems.size() == 0) {
            return CheckinItem.newMap();
        }
        TreeMap<String, CheckinItem> checkinItems = CheckinItem.newMap();
        for (String serverItem : sourceCheckinItems.keySet()) {
            checkinItems.put(serverItem, sourceCheckinItems.get(serverItem));
        }
        return checkinItems;
    }

    private static TreeMap<String, CheckinItem> newMap() {
        return new TreeMap<String, CheckinItem>(ServerPath.TOP_DOWN_COMPARATOR);
    }

    public int getItemID() {
        return this.itemID;
    }

    public String getServerItem() {
        return this.serverItem;
    }
}

