/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.form;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.form.WIFormElement;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLink;
import com.microsoft.tfs.core.clients.workitem.form.WIFormParam;
import com.microsoft.tfs.core.clients.workitem.internal.MacroHelpers;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormElementImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormParseHandler;
import java.net.URLEncoder;
import org.xml.sax.Attributes;

public class WIFormLinkImpl
extends WIFormElementImpl
implements WIFormLink {
    private String urlRoot;
    private String urlPath;

    @Override
    void startLoading(Attributes attributes) {
        this.urlRoot = WIFormParseHandler.readStringValue(attributes, "UrlRoot");
        this.urlPath = WIFormParseHandler.readStringValue(attributes, "UrlPath");
        this.setAttributes(attributes);
    }

    public String getURLRoot() {
        return this.urlRoot;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    @Override
    public String getURL(WorkItem workItem) {
        String resolvedRoot = this.urlRoot == null ? "" : this.urlRoot;
        String resolvedPath = this.urlPath == null ? "" : this.urlPath;
        WIFormElement[] children = this.getChildElements();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof WIFormParam)) continue;
            WIFormParam param = (WIFormParam)children[i];
            String token = param.getSubstitutionToken();
            String replacement = param.getSubstitutionValue(workItem);
            replacement = URLEncoder.encode(replacement);
            resolvedPath = resolvedPath.replaceAll(token, replacement);
        }
        if (MacroHelpers.isMacro(resolvedRoot)) {
            resolvedRoot = MacroHelpers.resolveURIMacros(workItem, resolvedRoot);
        }
        if (resolvedRoot.endsWith("/") || resolvedPath.startsWith("/")) {
            return resolvedRoot + resolvedPath;
        }
        return resolvedRoot + "/" + resolvedPath;
    }
}

