/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.IConstantSet;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.Metadata;
import com.microsoft.tfs.core.clients.workitem.internal.rules.MatchPattern;
import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.internal.db.DBTask;
import com.microsoft.tfs.core.internal.db.ResultHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConstantSet
implements IConstantSet {
    private static final Log log = LogFactory.getLog(ConstantSet.class);
    private Set<Integer> distinctConstantSetIds;
    private final Set<String> values = new HashSet<String>();
    private final Set<Integer> constIds = new HashSet<Integer>();
    private int queryCount;

    public static ConstantSet newSingletonSet(int constId, String value) {
        return new ConstantSet(new String[]{value}, new int[]{constId}, -1);
    }

    public static ConstantSet newSet(int[] constIds, String[] values) {
        return new ConstantSet(values, constIds, -1);
    }

    public ConstantSet(Metadata metadata, int rootId, boolean oneLevel, boolean twoPlusLevels, boolean leaf, boolean interior) {
        this(metadata, new int[]{rootId}, oneLevel, twoPlusLevels, leaf, interior);
    }

    public ConstantSet(Metadata metadata, final int[] rootIds, final boolean oneLevel, final boolean twoPlusLevels, final boolean leaf, final boolean interior) {
        this.distinctConstantSetIds = metadata.getDistinctConstantSetIDs();
        metadata.getConnectionPool().executeWithPooledConnection(new DBTask(){

            @Override
            public void performTask(DBConnection connection) {
                ConstantSet.this.populate(connection, rootIds, oneLevel, twoPlusLevels, leaf, interior);
            }
        });
    }

    private ConstantSet(String[] values, int[] constIds, int queryCount) {
        this.values.addAll(Arrays.asList(values));
        for (int i = 0; i < constIds.length; ++i) {
            this.constIds.add(new Integer(constIds[i]));
        }
        this.queryCount = queryCount;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public int getQueryCount() {
        return this.queryCount;
    }

    @Override
    public String[] toArray() {
        return this.values.toArray(new String[this.values.size()]);
    }

    private void populate(DBConnection connection, int[] startingRootIds, boolean oneLevel, boolean twoPlusLevels, boolean leaf, boolean interior) {
        int i;
        StringBuffer sb;
        if (log.isDebugEnabled()) {
            sb = new StringBuffer("[");
            for (i = 0; i < startingRootIds.length; ++i) {
                sb.append(i);
                if (i >= startingRootIds.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            log.debug((Object)MessageFormat.format("populate ConstantSet startingRootIds={0} oneLevel={1} twoPlusLevels={2} leaf={3} interior={4}", sb.toString(), oneLevel, twoPlusLevels, leaf, interior));
        }
        if (!oneLevel && !twoPlusLevels) {
            sb = new StringBuffer("(");
            for (i = 0; i < startingRootIds.length; ++i) {
                sb.append(startingRootIds[i]);
                if (i >= startingRootIds.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            String SQL = "select ConstID, String, DisplayName from Constants where ConstID in " + sb.toString();
            ++this.queryCount;
            connection.createStatement(SQL).executeQuery(new ResultHandler(){

                @Override
                public void handleRow(ResultSet rset) throws SQLException {
                    int constId = rset.getInt(1);
                    String string = rset.getString(2);
                    String displayName = rset.getString(3);
                    ConstantSet.this.values.add(displayName != null ? displayName : string);
                    ConstantSet.this.constIds.add(new Integer(constId));
                }
            });
        } else {
            HashSet<Integer> allParentIds = new HashSet<Integer>();
            Set<Integer> rootIds = new HashSet<Integer>();
            for (int i2 = 0; i2 < startingRootIds.length; ++i2) {
                rootIds.add(new Integer(startingRootIds[i2]));
            }
            allParentIds.addAll(rootIds);
            rootIds = this.query(connection, rootIds, oneLevel && leaf, oneLevel && interior, twoPlusLevels);
            rootIds.removeAll(allParentIds);
            allParentIds.addAll(rootIds);
            while (rootIds.size() > 0) {
                rootIds = this.query(connection, rootIds, leaf, interior, true);
                rootIds.removeAll(allParentIds);
                allParentIds.addAll(rootIds);
            }
        }
    }

    private Set<Integer> getChildIDs(DBConnection connection, Set<Integer> parentIds) {
        StringBuffer sb = new StringBuffer("(");
        Iterator<Integer> it = parentIds.iterator();
        while (it.hasNext()) {
            Integer id = it.next();
            sb.append(id);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        String SELECT_CHILDREN_IDS = "select ConstID from ConstantSets where ParentID in " + sb.toString();
        final HashSet<Integer> childIds = new HashSet<Integer>();
        connection.createStatement(SELECT_CHILDREN_IDS).executeQuery(new ResultHandler(){

            @Override
            public void handleRow(ResultSet rset) throws SQLException {
                int constId = rset.getInt(1);
                childIds.add(new Integer(constId));
            }
        });
        return childIds;
    }

    private Set<Integer> query(DBConnection connection, Set<Integer> rootIds, boolean addLeaf, boolean addNonLeaf, boolean needChildren) {
        Set<Integer> childIds = this.getChildIDs(connection, rootIds);
        HashSet<Integer> selfContainedIds = new HashSet<Integer>(rootIds);
        selfContainedIds.retainAll(childIds);
        childIds.removeAll(selfContainedIds);
        HashSet<Integer> idsToAdd = new HashSet<Integer>();
        HashSet<Integer> nonLeafChildIds = new HashSet();
        if (addLeaf) {
            HashSet<Integer> leafIds = new HashSet<Integer>(childIds);
            leafIds.removeAll(this.distinctConstantSetIds);
            leafIds.addAll(selfContainedIds);
            idsToAdd.addAll(leafIds);
        }
        if (addNonLeaf | needChildren) {
            nonLeafChildIds = new HashSet<Integer>(childIds);
            nonLeafChildIds.retainAll(this.distinctConstantSetIds);
            if (addNonLeaf) {
                idsToAdd.addAll(nonLeafChildIds);
            }
        }
        if (idsToAdd.size() > 0) {
            StringBuffer sb = new StringBuffer("select ConstID, String, DisplayName from Constants where ConstID in (");
            Iterator it = idsToAdd.iterator();
            while (it.hasNext()) {
                Integer i = (Integer)it.next();
                sb.append(i);
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
            connection.createStatement(sb.toString()).executeQuery(new ResultHandler(){

                @Override
                public void handleRow(ResultSet rset) throws SQLException {
                    int constId = rset.getInt(1);
                    String string = rset.getString(2);
                    String displayName = rset.getString(3);
                    ConstantSet.this.values.add(displayName != null ? displayName : string);
                    ConstantSet.this.constIds.add(new Integer(constId));
                }
            });
        }
        if (needChildren) {
            return nonLeafChildIds;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean patternMatch(Object input, String debuggingInfo) {
        if (input == null) {
            return false;
        }
        if (!(input instanceof String)) {
            throw new IllegalStateException(MessageFormat.format("pattern match not possible for value of type [{0}] ({1})", input.getClass().getName(), debuggingInfo));
        }
        String inputString = (String)input;
        boolean matched = false;
        Iterator<String> it = this.values.iterator();
        while (!matched && it.hasNext()) {
            String patternString = it.next();
            matched = new MatchPattern(patternString).matches(inputString);
        }
        return matched;
    }

    @Override
    public boolean contains(String valueToTest) {
        for (String valueInSet : this.values) {
            if (!valueInSet.equalsIgnoreCase(valueToTest)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public boolean containsConstID(int constId) {
        return this.constIds.contains(new Integer(constId));
    }
}

