/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;

public class HTMLWriterRowSetHandler
implements RowSetParseHandler {
    private PrintWriter out;
    private final String filename;
    private int colCount;
    private int rowCount;

    public HTMLWriterRowSetHandler(String filename) {
        this.filename = filename;
    }

    @Override
    public void handleBeginParsing() {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(this.filename);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.out = new PrintWriter(fos);
        this.colCount = 0;
        this.rowCount = 0;
    }

    @Override
    public void handleFinishedColumns() {
        this.out.println("</tr>");
    }

    @Override
    public void handleEndParsing() {
        this.out.println("</table>");
        this.out.println(MessageFormat.format("{0}: {1}", Messages.getString("HTMLWriterRowSetHandler.ColumnsCountSummaryText"), Integer.toString(this.colCount)));
        this.out.println("<br/>");
        this.out.println(MessageFormat.format("{0}: {1}", Messages.getString("HTMLWriterRowSetHandler.RowsCountSummaryText"), Integer.toString(this.rowCount)));
        this.out.println("</body></html>");
        this.out.close();
    }

    @Override
    public void handleTableName(String tableName) {
        this.out.println(MessageFormat.format("<html><head><title>{0}: {1}</title>", Messages.getString("HTMLWriterRowSetHandler.TableTitleText"), tableName));
        this.out.println("<style type=\"text/css\">");
        this.out.println("body {font-family: Verdana, Arial, Helvetica, sans-serif}");
        this.out.println("table {font-size: 10px;}");
        this.out.println("</style>");
        this.out.println("<body>");
        this.out.println(MessageFormat.format("{0}: {1}", Messages.getString("HTMLWriterRowSetHandler.CurrentTimeText"), new Date()));
        this.out.println("<br/><br/>");
        this.out.println("<table border=\"1\">");
        this.out.println("<tr>");
    }

    @Override
    public void handleColumn(String name, String type) {
        this.out.println("<th>");
        this.out.println(name);
        this.out.println("<br/>");
        this.out.println(type);
        this.out.println("</th>");
        ++this.colCount;
    }

    @Override
    public void handleRow(String[] rowValues) {
        this.out.println("<tr>");
        for (int i = 0; i < rowValues.length; ++i) {
            this.out.println("<td>");
            String value = rowValues[i];
            this.out.println(value == null || value.trim().length() == 0 ? "&nbsp;" : value);
            this.out.println("</td>");
        }
        this.out.println("</tr>");
        ++this.rowCount;
    }
}

