/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rules;

import com.microsoft.tfs.core.clients.workitem.internal.rules.Rule;
import java.util.Comparator;

public class ValueProvidingRuleComparator
implements Comparator<Rule> {
    private static final Integer R1_GREATER = new Integer(1);
    private static final Integer R2_GREATER = new Integer(-1);

    @Override
    public int compare(Rule r1, Rule r2) {
        int diff;
        Integer compareValue = this.compareByScopingRule(r1.getFld4ID(), r1.getFld4IsConstID(), r1.getFld4WasConstID(), r2.getFld4ID(), r2.getFld4IsConstID(), r2.getFld4WasConstID());
        if (compareValue == null) {
            compareValue = this.compareByScopingRule(r1.getFld3ID(), r1.getFld3IsConstID(), r1.getFld3WasConstID(), r2.getFld3ID(), r2.getFld3IsConstID(), r2.getFld3WasConstID());
        }
        if (compareValue == null) {
            compareValue = this.compareByScopingRule(r1.getFld2ID(), r1.getFld2IsConstID(), r1.getFld2WasConstID(), r2.getFld2ID(), r2.getFld2IsConstID(), r2.getFld2WasConstID());
        }
        if (compareValue == null) {
            compareValue = this.compareByScopingRule(r1.getFld1ID(), r1.getFld1IsConstID(), r1.getFld1WasConstID(), r2.getFld1ID(), r2.getFld1IsConstID(), r2.getFld1WasConstID());
        }
        if (compareValue != null) {
            return compareValue;
        }
        if (r1.getIfFldID() != 0 && r2.getIfFldID() == 0) {
            return 1;
        }
        if (r2.getIfFldID() != 0 && r1.getIfFldID() == 0) {
            return -1;
        }
        if (r1.getIfFldID() != 0 && r2.getIfFldID() != 0 && (diff = this.getConditionTypeRanking(r1) - this.getConditionTypeRanking(r2)) != 0) {
            return diff;
        }
        boolean r1Default = this.hasDefaultEnforcingCondition(r1);
        boolean r2Default = this.hasDefaultEnforcingCondition(r2);
        if (r1Default && !r2Default) {
            return -1;
        }
        if (!r1Default && r2Default) {
            return 1;
        }
        return 0;
    }

    private Integer compareByScopingRule(int r1FldId, int r1IsConstId, int r1WasConstId, int r2Fldid, int r2IsConstId, int r2WasConstId) {
        int r2Count;
        int r1Count;
        if (r1FldId != 0 && r2Fldid == 0) {
            return R1_GREATER;
        }
        if (r1FldId == 0 && r2Fldid != 0) {
            return R2_GREATER;
        }
        if (r1FldId != 0 && r2Fldid != 0 && (r1Count = (r1IsConstId != 0 ? 1 : 0) + (r1WasConstId != 0 ? 1 : 0)) != (r2Count = (r2IsConstId != 0 ? 1 : 0) + (r2WasConstId != 0 ? 1 : 0))) {
            return new Integer(r1Count - r2Count);
        }
        return null;
    }

    private int getConditionTypeRanking(Rule rule) {
        if (this.hasWhenChangedCondition(rule)) {
            return 3;
        }
        if (rule.isFlagIfNot()) {
            return 2;
        }
        return 1;
    }

    private boolean hasWhenChangedCondition(Rule rule) {
        return rule.getIfConstID() == -10001;
    }

    private boolean hasDefaultEnforcingCondition(Rule rule) {
        int thenFldId = rule.getThenFldID();
        return rule.getFld1ID() == thenFldId && rule.getFld1IsConstID() == -10000 || rule.getFld2ID() == thenFldId && rule.getFld2IsConstID() == -10000 || rule.getFld3ID() == thenFldId && rule.getFld3IsConstID() == -10000 || rule.getFld4ID() == thenFldId && rule.getFld4IsConstID() == -10000;
    }
}

