/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DateTime;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Parser;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import com.microsoft.tfs.util.GUID;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class Tools {
    public static void ensureSyntax(boolean condition, SyntaxError syntaxError, Node node) {
        if (!condition) {
            throw new SyntaxException(node, syntaxError);
        }
    }

    public static void AppendName(StringBuffer b, String s) {
        boolean flag = s.length() == 0 || !Character.isLetter(s.charAt(0));
        int length = s.length();
        for (int i = 0; i < length && !flag; ++i) {
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            flag = true;
        }
        if (flag) {
            s = "[" + s + "]";
        }
        b.append(s);
    }

    public static void AppendString(StringBuffer sb, String s) {
        String[] parts = s.split("\\'");
        sb.append("'");
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= parts.length - 1) continue;
            sb.append("''");
        }
        sb.append("'");
    }

    public static String formatString(String s) {
        String[] parts = s.split("\\'");
        StringBuffer sb = new StringBuffer("'");
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= parts.length - 1) continue;
            sb.append("''");
        }
        sb.append("'");
        return sb.toString();
    }

    public static String formatName(String name) {
        boolean needToEscapeWithBrackets = name.length() == 0 || !Character.isLetter(name.charAt(0));
        for (int i = 0; i < name.length() && !needToEscapeWithBrackets; ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            needToEscapeWithBrackets = true;
        }
        if (needToEscapeWithBrackets) {
            name = "[" + name + "]";
        }
        return name;
    }

    public static boolean IsGUIDString(String s) {
        try {
            new GUID(s);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNumericString(String s) {
        List<Node> list = Parser.parseLexems(s);
        if (list.size() == 1) {
            return ((NodeItem)list.get(0)).getNodeType() == NodeType.NUMBER;
        }
        return false;
    }

    public static boolean isDateString(String s, Locale locale) {
        try {
            DateTime.parse(s, locale, TimeZone.getDefault());
            return true;
        }
        catch (DateTime.UncheckedParseException ex) {
            return false;
        }
    }

    public static Boolean TranslateBoolToken(String val) {
        if ((val = val.toLowerCase()).equals("true")) {
            return Boolean.TRUE;
        }
        if (val.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

