/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.auth;

import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.httpclient.ConfigurableHTTPClientFactory;
import com.microsoft.tfs.core.httpclient.JwtCredentials;
import com.microsoft.tfs.core.httpclient.PreemptiveUsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequest;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.core.ws.runtime.client.TransportRequestHandler;
import com.microsoft.tfs.core.ws.runtime.exceptions.FederatedAuthException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTransportRequestHandler
implements TransportRequestHandler {
    private static final Log log = LogFactory.getLog(DefaultTransportRequestHandler.class);
    private final ConnectionInstanceData connectionInstanceData;
    private final ConfigurableHTTPClientFactory clientFactory;

    public DefaultTransportRequestHandler(ConnectionInstanceData connectionInstanceData, ConfigurableHTTPClientFactory clientFactory) {
        Check.notNull(connectionInstanceData, "connectionInstanceData");
        Check.notNull(clientFactory, "clientFactory");
        this.connectionInstanceData = connectionInstanceData;
        this.clientFactory = clientFactory;
    }

    protected ConnectionInstanceData getConnectionInstanceData() {
        return this.connectionInstanceData;
    }

    protected ConfigurableHTTPClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public TransportRequestHandler.Status prepareRequest(SOAPService service, SOAPRequest request, AtomicBoolean cancel) {
        return TransportRequestHandler.Status.CONTINUE;
    }

    @Override
    public TransportRequestHandler.Status handleException(SOAPService service, SOAPRequest request, Exception exception, AtomicBoolean cancel) {
        if (exception instanceof FederatedAuthException) {
            return this.handleFederatedAuthentication(service, request, (FederatedAuthException)exception, cancel);
        }
        return TransportRequestHandler.Status.CONTINUE;
    }

    @Override
    public TransportRequestHandler.Status handleSuccess(SOAPService service, SOAPRequest request) {
        return TransportRequestHandler.Status.CONTINUE;
    }

    private TransportRequestHandler.Status handleFederatedAuthentication(SOAPService service, SOAPRequest request, FederatedAuthException exception, AtomicBoolean cancel) {
        if (this.connectionInstanceData.getCredentials() == null) {
            log.debug((Object)"No credentials provided for Federated authentication.");
            return TransportRequestHandler.Status.CONTINUE;
        }
        if (this.connectionInstanceData.getCredentials() instanceof PreemptiveUsernamePasswordCredentials) {
            log.debug((Object)"UsernamePassword credentials provided for Federated authentication failed.");
            return TransportRequestHandler.Status.CONTINUE;
        }
        if (this.connectionInstanceData.getCredentials() instanceof JwtCredentials) {
            log.debug((Object)"JWT credentials provided for Federated authentication failed.");
            return TransportRequestHandler.Status.CONTINUE;
        }
        boolean basic = false;
        for (String mechanism : exception.getMechanisms()) {
            String[] parts;
            if (StringUtil.isNullOrEmpty(mechanism) || !"Basic".equalsIgnoreCase((parts = mechanism.split(" ", 2))[0])) continue;
            basic = true;
            break;
        }
        if (!basic) {
            log.debug((Object)"Basic authentication is not supported by the server");
            return TransportRequestHandler.Status.CONTINUE;
        }
        if (!(this.connectionInstanceData.getCredentials() instanceof UsernamePasswordCredentials)) {
            log.debug((Object)(this.connectionInstanceData.getCredentials().getClass().getSimpleName() + " credentials can't be used for Basic authentication"));
            return TransportRequestHandler.Status.CONTINUE;
        }
        log.debug((Object)"Handling FederatedAuthException with basic credentials");
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.connectionInstanceData.getCredentials();
        PreemptiveUsernamePasswordCredentials newCredentials = PreemptiveUsernamePasswordCredentials.newFrom(credentials);
        this.connectionInstanceData.setCredentials(newCredentials);
        service.getHTTPClient().getState().setCredentials(AuthScope.ANY, newCredentials);
        return TransportRequestHandler.Status.COMPLETE;
    }
}

