/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.credentials.internal.CachedCredentialsSerializer;
import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceSecurity;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.util.ServerURIComparator;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistenceStoreCredentialsManager
implements CredentialsManager {
    private static final Log log = LogFactory.getLog(PersistenceStoreCredentialsManager.class);
    private static final String CHILD_STORE_NAME = "TEE-Servers";
    private static final String OBJECT_NAME = "Credentials.xml";
    private final PersistenceStore configurationStore;

    public PersistenceStoreCredentialsManager(PersistenceStore configurationStore) {
        Check.notNull(configurationStore, "configurationStore");
        this.configurationStore = configurationStore;
    }

    @Override
    public String getUIMechanismName() {
        return Messages.getString("PersistenceStoreCredentialsManager.PersistenceStore");
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public CachedCredentials[] getCredentials() {
        Collection<CachedCredentials> credentials = this.load().values();
        return credentials.toArray(new CachedCredentials[credentials.size()]);
    }

    @Override
    public CachedCredentials getCredentials(URI serverURI) {
        Check.notNull(serverURI, "serverURI");
        serverURI = URIUtils.removePathAndQueryParts(serverURI);
        return this.load().get(serverURI);
    }

    @Override
    public boolean setCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        URI serverURI = URIUtils.removePathAndQueryParts(cachedCredentials.getURI());
        cachedCredentials = new CachedCredentials(serverURI, cachedCredentials.getUsername(), cachedCredentials.getPassword());
        try {
            Map<URI, CachedCredentials> credentialsMap = this.load();
            credentialsMap.put(URIUtils.removeTrailingSlash(serverURI), cachedCredentials);
            this.save(credentialsMap);
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Unable to save credentials cache", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean removeCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        return this.removeCredentials(cachedCredentials.getURI());
    }

    @Override
    public boolean removeCredentials(URI uri) {
        Check.notNull(uri, "uri");
        URI serverURI = URIUtils.removePathAndQueryParts(uri);
        try {
            Map<URI, CachedCredentials> credentialsMap = this.load();
            CachedCredentials removedCredentials = credentialsMap.remove(serverURI);
            this.save(credentialsMap);
            return removedCredentials != null;
        }
        catch (Exception e) {
            log.warn((Object)"Unable to remove entry from credentials cache", (Throwable)e);
            return false;
        }
    }

    private Map<URI, CachedCredentials> load() {
        PersistenceStore currentStore = this.configurationStore.getChildStore(CHILD_STORE_NAME);
        try {
            if (!currentStore.containsItem(OBJECT_NAME)) {
                return PersistenceStoreCredentialsManager.newMap();
            }
            Map credentialsMap = (Map)currentStore.retrieveItem(OBJECT_NAME, LockMode.WAIT_FOREVER, null, new CachedCredentialsSerializer());
            if (credentialsMap == null) {
                return PersistenceStoreCredentialsManager.newMap();
            }
            return credentialsMap;
        }
        catch (Exception e) {
            log.warn((Object)"Unable to load credentials cache", (Throwable)e);
            return PersistenceStoreCredentialsManager.newMap();
        }
    }

    private boolean save(Map<URI, CachedCredentials> credentialsMap) {
        Check.notNull(credentialsMap, "credentialsMap");
        try {
            return this.configurationStore.getChildStore(CHILD_STORE_NAME).storeItem(OBJECT_NAME, credentialsMap, LockMode.WAIT_FOREVER, null, new CachedCredentialsSerializer(), PersistenceSecurity.PRIVATE);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to save credentials cache", (Throwable)e);
            return false;
        }
    }

    protected static Map<URI, CachedCredentials> newMap() {
        return new TreeMap<URI, CachedCredentials>(ServerURIComparator.INSTANCE);
    }
}

