/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.persistence;

import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.MergeHandler;
import com.microsoft.tfs.core.persistence.ObjectSerializer;
import com.microsoft.tfs.core.persistence.PersistenceSecurity;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.locking.AdvisoryFileLock;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemPersistenceStore
implements PersistenceStore {
    private static final Log log = LogFactory.getLog(FilesystemPersistenceStore.class);
    private static final String DIRECTORY_LOCK_FILE = ".lock";
    private static final String FILE_LOCK_PREFIX = ".lock-";
    private final File directory;

    public FilesystemPersistenceStore(File directory) {
        Check.notNull(directory, "directory");
        this.directory = directory;
    }

    @Override
    public PersistenceStore getChildStore(String childName) {
        Check.notNullOrEmpty(childName, "childName");
        return new FilesystemPersistenceStore(new File(this.directory, childName));
    }

    @Override
    public void initialize() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new RuntimeException(MessageFormat.format("Error creating directories up to {0}.  Possible permissions problem.", this.directory.getAbsolutePath()));
        }
    }

    @Override
    public boolean containsItem(String itemName) {
        Check.notNullOrEmpty(itemName, "itemName");
        return this.getItemFile(itemName).exists();
    }

    @Override
    public boolean deleteItem(String itemName) {
        Check.notNullOrEmpty(itemName, "itemName");
        return this.getItemFile(itemName).delete();
    }

    @Override
    public boolean storeItem(String itemName, Object object, LockMode lockMode, MergeHandler mergeHandler, ObjectSerializer serializer) throws IOException, InterruptedException {
        return this.storeItem(itemName, object, lockMode, mergeHandler, serializer, PersistenceSecurity.PUBLIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeItem(String itemName, Object object, LockMode lockMode, MergeHandler mergeHandler, ObjectSerializer serializer, PersistenceSecurity security) throws IOException, InterruptedException {
        Check.notNullOrEmpty(itemName, "itemName");
        Check.notNull(object, "object");
        Check.notNull(lockMode, "lockMode");
        Check.notNull(serializer, "serializer");
        Check.notNull(security, "security");
        log.debug((Object)("storeObject called for " + itemName));
        AdvisoryFileLock lock = null;
        try {
            if (lockMode != LockMode.NONE && (lock = this.getItemLock(itemName, lockMode == LockMode.WAIT_FOREVER)) == null) {
                log.debug((Object)MessageFormat.format("No lock available for {0}, returning", itemName));
                boolean bl = false;
                return bl;
            }
            File file = this.getItemFile(itemName);
            if (mergeHandler != null && file.exists() && mergeHandler.needsMerge(itemName, file.lastModified())) {
                log.debug((Object)MessageFormat.format("Object file {0} needs merged, performing merge", file));
                Object diskVersion = this.retrieveItem(itemName, LockMode.NONE, null, serializer);
                object = mergeHandler.merge(diskVersion, object);
            }
            this.initialize();
            OutputStream outputStream = null;
            File tempFile = PersistenceSecurity.PRIVATE.equals(security) ? FileSystemUtils.getInstance().createTempFileSecure("vvfps", ".tmp", file.getParentFile()) : File.createTempFile("vvfps", ".tmp", file.getParentFile());
            log.debug((Object)MessageFormat.format("Writing {0} to {1}", itemName, tempFile));
            try {
                outputStream = new FileOutputStream(tempFile);
                outputStream = new BufferedOutputStream(outputStream);
                serializer.serialize(object, outputStream);
            }
            catch (Exception e) {
                log.error((Object)"Error writing to temp file", (Throwable)e);
                tempFile.delete();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(MessageFormat.format("Error writing to temp file: {0}", e.getMessage()));
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (PersistenceSecurity.PRIVATE.equals(security)) {
                FileSystemAttributes attributes = FileSystemUtils.getInstance().getAttributes(tempFile.getAbsolutePath());
                attributes.setOwnerOnly(true);
                FileSystemUtils.getInstance().setAttributes(tempFile.getAbsolutePath(), attributes);
            }
            log.debug((Object)MessageFormat.format("Renaming temp file {0} to final object file {1}", tempFile, file));
            try {
                FileHelpers.rename(tempFile, file);
            }
            catch (Exception e) {
                log.error((Object)"Error renaming temp file to object file", (Throwable)e);
                tempFile.delete();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(MessageFormat.format("Could not rename temp file: {0}", e.getMessage()));
            }
            log.debug((Object)("Done saving object file " + file));
            if (mergeHandler != null) {
                mergeHandler.updateModificationStampAfterStore(itemName, file.lastModified());
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrieveItem(String itemName, LockMode lockMode, MergeHandler mergeHandler, ObjectSerializer serializer) throws IOException, InterruptedException {
        Check.notNullOrEmpty(itemName, "itemName");
        Check.notNull(lockMode, "lockMode");
        Check.notNull(serializer, "serializer");
        log.debug((Object)MessageFormat.format("retrieveObject called for {0}", itemName));
        AdvisoryFileLock lock = null;
        Object component = null;
        try {
            if (lockMode != LockMode.NONE && (lock = this.getItemLock(itemName, lockMode == LockMode.WAIT_FOREVER)) == null) {
                log.debug((Object)MessageFormat.format("No lock available for {0}, returning", itemName));
                Object var7_7 = null;
                return var7_7;
            }
            File componentFile = this.getItemFile(itemName);
            log.debug((Object)MessageFormat.format("Reading object file {0}", componentFile));
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(componentFile);
                inputStream = new BufferedInputStream(inputStream);
                component = serializer.deserialize(inputStream);
            }
            catch (Exception e) {
                log.debug((Object)MessageFormat.format("Could not read object file {0}", componentFile), (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            log.debug((Object)MessageFormat.format("Done reading object file {0}", componentFile));
            if (mergeHandler != null) {
                mergeHandler.updateModificationStampAfterRetrieve(itemName, componentFile.lastModified());
            }
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("Could not read {0}", itemName), (Throwable)e);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean migrateItem(PersistenceStore oldStore, String oldItemName, String newItemName) {
        boolean haveOldItem;
        Check.notNull(oldStore, "oldStore");
        Check.notNullOrEmpty(oldItemName, "oldItemName");
        Check.notNullOrEmpty(newItemName, "newItemName");
        if (this.containsItem(newItemName)) {
            return true;
        }
        try {
            haveOldItem = oldStore.containsItem(oldItemName);
        }
        catch (IOException e) {
            log.warn((Object)MessageFormat.format("Error testing for existence of item {0} in old store {1}", oldItemName, oldStore.toString()), (Throwable)e);
            return false;
        }
        if (haveOldItem) {
            AdvisoryFileLock oldComponentLock = null;
            AdvisoryFileLock newComponentLock = null;
            try {
                oldComponentLock = oldStore.getItemLock(oldItemName, true);
                newComponentLock = this.getItemLock(newItemName, true);
                if (oldStore.containsItem(oldItemName) && !this.containsItem(newItemName)) {
                    log.info((Object)MessageFormat.format("attempting to migrate [{0}] from old store [{1}] to new store [{2}]", oldItemName, oldStore.toString(), this.toString()));
                    if (!this.copyObjectStreams(oldStore.getItemInputStream(oldItemName), this.getItemOutputStream(newItemName))) {
                        this.deleteItem(newItemName);
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ex) {
                log.warn((Object)MessageFormat.format("problem during locking phase for migration of [{0}] from old store [{1}] to new store [{2}]", oldItemName, oldStore.toString(), this.toString()), (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (oldComponentLock != null) {
                    try {
                        oldComponentLock.release();
                    }
                    catch (IOException e) {}
                }
                if (newComponentLock != null) {
                    try {
                        newComponentLock.release();
                    }
                    catch (IOException e) {}
                }
            }
        }
        log.info((Object)MessageFormat.format("object [{0}] was not found in the store [{1}]", oldItemName, oldStore.toString()));
        return false;
    }

    @Override
    public InputStream getItemInputStream(String itemName) throws IOException {
        Check.notNullOrEmpty(itemName, "itemName");
        return new FileInputStream(this.getItemFile(itemName));
    }

    @Override
    public OutputStream getItemOutputStream(String itemName) throws IOException {
        Check.notNullOrEmpty(itemName, "itemName");
        return new FileOutputStream(this.getItemFile(itemName));
    }

    public String toString() {
        return this.directory.toString();
    }

    public File getStoreFile() {
        return this.directory;
    }

    public File getItemFile(String itemName) {
        Check.notNullOrEmpty(itemName, "itemName");
        return new File(this.directory, itemName);
    }

    @Override
    public AdvisoryFileLock getItemLock(String itemName, boolean block) throws IOException, InterruptedException {
        Check.notNullOrEmpty(itemName, "itemName");
        return this.getLockInternal(itemName, block);
    }

    @Override
    public AdvisoryFileLock getStoreLock(boolean block) throws IOException, InterruptedException {
        return this.getLockInternal(null, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyObjectStreams(InputStream source, OutputStream target) {
        Check.notNull(source, "source");
        Check.notNull(target, "target");
        BufferedInputStream input = null;
        OutputStream output = null;
        boolean errorOccurred = false;
        try {
            int len;
            input = new BufferedInputStream(source);
            output = new BufferedOutputStream(target);
            byte[] buffer = new byte[2048];
            while ((len = ((InputStream)input).read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            log.warn((Object)"unable to copy object streams for migration", (Throwable)ex);
            errorOccurred = true;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
        return !errorOccurred;
    }

    private AdvisoryFileLock getLockInternal(String itemName, boolean block) throws IOException, InterruptedException {
        File lockFile = itemName != null ? new File(this.directory, FILE_LOCK_PREFIX + itemName) : new File(this.directory, DIRECTORY_LOCK_FILE);
        this.initialize();
        lockFile.createNewFile();
        return AdvisoryFileLock.create(lockFile, block);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilesystemPersistenceStore)) {
            return false;
        }
        return this.directory.equals(((FilesystemPersistenceStore)obj).directory);
    }
}

