/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.jni.appleforked.AppleForkedUtils;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedHeader;
import com.microsoft.tfs.jni.appleforked.stream.AppleForkedDecoderStream;
import com.microsoft.tfs.jni.appleforked.stream.AppleSingleDecoderStream;
import com.microsoft.tfs.jni.appleforked.stream.AppleSingleEncoderStream;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppleSingleUtil {
    private static final Log log = LogFactory.getLog(AppleSingleUtil.class);

    public static boolean isSupportedPlatform() {
        return Platform.isCurrentPlatform(Platform.MAC_OS_X);
    }

    public static void encodeFile(File file) throws IOException {
        AppleSingleUtil.encodeFile(file, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeFile(File file, String filename) throws IOException {
        if (!Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            throw new IOException(MessageFormat.format(Messages.getString("AppleSingleUtil.NotSupportedOnPlatformFormat"), Platform.getCurrentPlatformString()));
        }
        File directory = file.getParentFile();
        File temp = File.createTempFile("teApple", ".tmp", directory);
        try {
            AppleSingleEncoderStream input = null;
            OutputStream output = null;
            try {
                input = new AppleSingleEncoderStream(file);
                input.setFilesystem("Teamprise");
                input.setFilename(filename);
                input.setDate(new Date(0L));
                output = new FileOutputStream(temp);
                AppleSingleUtil.duplicateFile(input, output);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)Messages.getString("AppleSingleUtil.CouldNotCloseAppleSingleInputStream"), (Throwable)e);
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)Messages.getString("AppleSingleUtil.CouldNotCloseAppleSingleOutputStream"), (Throwable)e);
                    }
                }
            }
            AppleSingleUtil.renameFile(temp, file);
            temp = null;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeFile(File file) throws IOException {
        if (!Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            throw new IOException(MessageFormat.format(Messages.getString("AppleSingleUtil.NotSupportedOnPlatformFormat"), Platform.getCurrentPlatformString()));
        }
        AppleForkedHeader header = AppleForkedUtils.getHeader(file);
        if (header.getMagic() != 333312 || !header.getFilesystem().equals("Teamprise")) {
            throw new IOException(Messages.getString("AppleSingleUtil.FileIsNotTFSApplieSingleFile"));
        }
        File directory = file.getParentFile();
        File temp = File.createTempFile("teApple", ".tmp", directory);
        try {
            FileInputStream input = null;
            AppleForkedDecoderStream output = null;
            try {
                input = new FileInputStream(file);
                output = new AppleSingleDecoderStream(temp);
                output.ignoreEntry(8L);
                AppleSingleUtil.duplicateFile(input, output);
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Exception e) {
                        log.warn((Object)Messages.getString("AppleSingleUtil.CouldNotCloseAppleSingleInputStream"), (Throwable)e);
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)Messages.getString("AppleSingleUtil.CouldNotCloseAppleSingleOutputStream"), (Throwable)e);
                    }
                }
            }
            AppleSingleUtil.renameFile(temp, file);
            temp = null;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private static void duplicateFile(InputStream input, OutputStream output) throws IOException {
        int readlen;
        byte[] buffer = new byte[102400];
        while ((readlen = input.read(buffer, 0, buffer.length)) > 0) {
            output.write(buffer, 0, readlen);
        }
    }

    private static void renameFile(File source, File target) throws IOException {
        if (!target.delete()) {
            String message = MessageFormat.format(Messages.getString("AppleSingleUtil.ErrorDeletingFileForReplacementFormat"), target.getAbsolutePath());
            log.error((Object)message);
            throw new IOException(message);
        }
        if (!FileHelpers.renameWithoutException(source, target)) {
            String message = MessageFormat.format(Messages.getString("AppleSingleUtil.ErrorRenamingTempFileFormat"), source.getAbsolutePath(), target.getAbsolutePath());
            log.error((Object)message);
            throw new IOException(message);
        }
    }
}

