/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist;

import com.microsoft.tfs.core.util.serverlist.ServerListCollectionEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListEntryType;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class ServerListConfigurationEntry
extends ServerListEntry
implements Comparable<ServerListConfigurationEntry> {
    private final Set<ServerListCollectionEntry> collections = new TreeSet<ServerListCollectionEntry>();

    public ServerListConfigurationEntry(String name, ServerListEntryType type, URI uri) {
        super(name, type, uri);
    }

    public Set<ServerListCollectionEntry> getCollections() {
        return this.collections;
    }

    @Override
    public int compareTo(ServerListConfigurationEntry other) {
        int result = super.compareTo(other);
        if (result != 0) {
            return result;
        }
        if (this.collections == null && other.collections != null) {
            return -1;
        }
        if (this.collections != null && other.collections == null) {
            return 1;
        }
        if (this.collections != null && other.collections != null) {
            if (this.collections.size() != other.collections.size()) {
                return this.collections.size() > other.collections.size() ? 1 : -1;
            }
            Iterator<ServerListCollectionEntry> i = this.collections.iterator();
            Iterator<ServerListCollectionEntry> j = other.collections.iterator();
            while (i.hasNext() && j.hasNext()) {
                result = i.next().compareTo(j.next());
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.collections != null) {
            for (ServerListCollectionEntry collection : this.collections) {
                result = result * 37 + collection.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerListConfigurationEntry)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ServerListConfigurationEntry other = (ServerListConfigurationEntry)o;
        if (!super.equals(other)) {
            return false;
        }
        if (this.collections != null ^ other.collections != null) {
            return false;
        }
        if (this.collections != null && other.collections != null && this.collections.size() != other.collections.size()) {
            return false;
        }
        if (this.collections != null && other.collections != null) {
            Iterator<ServerListCollectionEntry> i = this.collections.iterator();
            Iterator<ServerListCollectionEntry> j = other.collections.iterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next().equals(j.next())) continue;
                return false;
            }
        }
        return true;
    }
}

