/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.client;

import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.ws.runtime.client.SOAPMethodRequestWriter;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity11;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFault;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.net.URI;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SOAP11Service
extends SOAPService {
    public SOAP11Service(HttpClient client, URI endpoint, QName port) {
        super(client, endpoint, port);
    }

    public SOAP11Service(URI endpoint, QName port) {
        super(endpoint, port);
    }

    @Override
    protected void setRequestHeaders(HttpMethod method, String invokedMethodName) {
        super.setRequestHeaders(method, invokedMethodName);
        String namespace = this.getPort().getNamespaceURI();
        if (!namespace.endsWith("/")) {
            namespace = namespace + "/";
        }
        method.setRequestHeader(new Header("SOAPAction", "\"" + namespace + invokedMethodName + "\""));
    }

    @Override
    protected SOAPRequestEntity buildRequestEntity(String invokedMethodName, SOAPMethodRequestWriter requestWriter) {
        return new SOAPRequestEntity11(invokedMethodName, this.getPort().getNamespaceURI(), requestWriter);
    }

    @Override
    protected String getDefaultSOAPNamespace() {
        return "http://schemas.xmlsoap.org/soap/envelope/";
    }

    @Override
    protected void examineResponseDOMForFault(Document responseDOM) {
        Node node = this.getChildByName(responseDOM, "soap:Envelope");
        Node faultNode = this.getChildByName(node = this.getChildByName(node, "soap:Body"), "soap:Fault");
        if (faultNode != null) {
            String code = DOMUtils.getText(this.getChildByName(faultNode, "faultcode"));
            String message = DOMUtils.getText(this.getChildByName(faultNode, "faultstring"));
            throw new SOAPFault(message, code != null ? new QName(code) : null, null, null, null, null, null);
        }
    }
}

