/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.jni.RegistryException;
import com.microsoft.tfs.jni.RegistryValue;
import com.microsoft.tfs.jni.RootKey;
import com.microsoft.tfs.jni.ValueType;
import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.text.MessageFormat;
import java.util.ArrayList;

public class RegistryKey {
    private final RootKey root;
    private final String path;

    public RegistryKey(RootKey root, String path) {
        Check.notNull(root, "root");
        Check.notNull(path, "path");
        this.root = root;
        this.path = path;
    }

    public RootKey getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.path == null || !this.path.contains("\\")) {
            return this.path;
        }
        return this.path.substring(this.path.lastIndexOf("\\") + 1);
    }

    public void create() {
        if (this.exists()) {
            String format = Messages.getString("RegistryKey.KeyAlreadyExistsFormat");
            throw new RegistryException(MessageFormat.format(format, this.path));
        }
        RegistryKey.nativeCreate(this.root.getValue(), this.path);
    }

    public boolean exists() {
        return RegistryKey.nativeExists(this.root.getValue(), this.path);
    }

    public RegistryKey getSubkey(String name) {
        Check.notNull(name, "name");
        if (RegistryKey.nativeHasSubkey(this.root.getValue(), this.path, name)) {
            return new RegistryKey(this.root, this.createSubkeyPath(name));
        }
        return null;
    }

    public RegistryKey createSubkey(String name) {
        boolean success = RegistryKey.nativeCreateSubkey(this.root.getValue(), this.path, name);
        return success ? new RegistryKey(this.root, this.createSubkeyPath(name)) : null;
    }

    public boolean deleteSubkey(String name) {
        Check.notNull(name, "name");
        return RegistryKey.nativeDeleteSubkey(this.root.getValue(), this.path, name);
    }

    public boolean deleteSubkeyRecursive(String name) {
        Check.notNull(name, "name");
        return this.deleteSubkeyRecursive(this.root.getValue(), this.path, name);
    }

    private boolean deleteSubkeyRecursive(int rootID, String path, String name) {
        Check.notNull(path, "path");
        Check.notNull(name, "name");
        String subkeyPath = path + "\\" + name;
        String[] subSubkeyNames = (String[])RegistryKey.nativeGetSubkeys(this.root.getValue(), subkeyPath);
        if (subSubkeyNames != null) {
            for (String subSubkeyName : subSubkeyNames) {
                this.deleteSubkeyRecursive(rootID, subkeyPath, subSubkeyName);
            }
        }
        return RegistryKey.nativeDeleteSubkey(rootID, path, name);
    }

    public String getStringValue(String name, String defaultValue) {
        RegistryValue value = this.getValue(name);
        if (value == null || !value.isStringType()) {
            return defaultValue;
        }
        return value.getStringValue();
    }

    public int getIntegerValue(String name, int defaultValue) {
        RegistryValue value = this.getValue(name);
        if (value == null || !value.isIntegerType()) {
            return defaultValue;
        }
        return value.getIntegerValue();
    }

    public RegistryValue getValue(String name) {
        Check.notNull(name, "name");
        return (RegistryValue)RegistryKey.nativeGetValue(this.root.getValue(), this.path, name);
    }

    public RegistryValue getDefaultValue() {
        return this.getValue("");
    }

    public boolean deleteValue(String name) {
        Check.notNull(name, "name");
        return RegistryKey.nativeDeleteValue(this.root.getValue(), this.path, name);
    }

    public boolean hasSubkey(String name) {
        Check.notNull(name, "name");
        return RegistryKey.nativeHasSubkey(this.root.getValue(), this.path, name);
    }

    public boolean hasSubkeys() {
        return RegistryKey.nativeHasSubkeys(this.root.getValue(), this.path);
    }

    public boolean hasValue(String name) {
        Check.notNull(name, "name");
        return RegistryKey.nativeHasValue(this.root.getValue(), this.path, name);
    }

    public boolean hasValues() {
        return RegistryKey.nativeHasValues(this.root.getValue(), this.path);
    }

    public void setValue(RegistryValue value) {
        Check.notNull(value, "value");
        if (value.getType() == ValueType.REG_DWORD) {
            RegistryKey.nativeSetDwordValue(this.root.getValue(), this.path, value.getName(), (Integer)value.getValue());
        } else if (value.getType() == ValueType.REG_SZ) {
            RegistryKey.nativeSetStringValue(this.root.getValue(), this.path, value.getName(), (String)value.getValue());
        }
    }

    public RegistryKey[] subkeys() {
        String[] subkeyNames = (String[])RegistryKey.nativeGetSubkeys(this.root.getValue(), this.path);
        if (subkeyNames == null) {
            return new RegistryKey[0];
        }
        ArrayList<RegistryKey> subkeys = new ArrayList<RegistryKey>(subkeyNames.length);
        for (String subkeyName : subkeyNames) {
            subkeys.add(new RegistryKey(this.root, this.createSubkeyPath(subkeyName)));
        }
        return subkeys.toArray(new RegistryKey[subkeys.size()]);
    }

    public String toString() {
        return this.root.getName() + "\\" + this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegistryKey)) {
            return false;
        }
        RegistryKey other = (RegistryKey)obj;
        return this.root == other.root && this.path.equalsIgnoreCase(other.path);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.root.hashCode();
        result = result * 37 + LocaleInvariantStringHelpers.caseInsensitiveHashCode(this.path);
        return result;
    }

    public RegistryValue[] values() {
        return (RegistryValue[])RegistryKey.nativeGetValues(this.root.getValue(), this.path);
    }

    private String createSubkeyPath(String subkey) {
        return this.path + "\\" + subkey;
    }

    private static native void nativeCreate(int var0, String var1);

    private static native boolean nativeExists(int var0, String var1);

    private static native boolean nativeCreateSubkey(int var0, String var1, String var2);

    private static native Object nativeGetSubkeys(int var0, String var1);

    private static native boolean nativeDeleteSubkey(int var0, String var1, String var2);

    private static native Object nativeGetValue(int var0, String var1, String var2);

    private static native Object nativeGetValues(int var0, String var1);

    private static native boolean nativeHasSubkey(int var0, String var1, String var2);

    private static native boolean nativeHasSubkeys(int var0, String var1);

    private static native boolean nativeHasValue(int var0, String var1, String var2);

    private static native boolean nativeHasValues(int var0, String var1);

    private static native void nativeSetDwordValue(int var0, String var1, String var2, int var3);

    private static native void nativeSetStringValue(int var0, String var1, String var2, String var3);

    private static native boolean nativeDeleteValue(int var0, String var1, String var2);

    static {
        NativeLoader.loadLibraryAndLogError("native_registry");
    }
}

