/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.fileformat;

import com.microsoft.tfs.util.ByteArrayUtils;
import com.microsoft.tfs.util.Check;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class AppleForkedHeader {
    public static final int HEADER_SIZE = 26;
    public static final int HEADER_FILESYSTEM_SIZE = 16;
    private int magic;
    private int version;
    private int entryCount;
    private String filesystem = null;

    public AppleForkedHeader() {
    }

    public AppleForkedHeader(int magic, int version, String filesystem, int entryCount) {
        this.setMagic(magic);
        this.setVersion(version);
        this.setFilesystem(filesystem);
        this.setEntryCount(entryCount);
    }

    public AppleForkedHeader(byte[] headerBytes) {
        this.decode(headerBytes);
    }

    public int getMagic() {
        return this.magic;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getFilesystem() {
        return this.filesystem;
    }

    public void setFilesystem(String filesystem) {
        this.filesystem = filesystem;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(int entryCount) {
        Check.isTrue(entryCount >= 0, "entryCount >= 0");
        this.entryCount = entryCount;
    }

    public byte[] encode() {
        byte[] header = new byte[26];
        byte[] filesystemBytes = new byte[16];
        if (this.filesystem != null) {
            byte[] filesystemTemp = Charset.forName("US-ASCII").encode(this.filesystem).array();
            for (int i = 0; i < 16; ++i) {
                filesystemBytes[i] = i < filesystemTemp.length ? filesystemTemp[i] : 32;
            }
        }
        ByteArrayUtils.putInt32(header, 0, this.magic);
        ByteArrayUtils.putInt32(header, 4, this.version);
        ByteArrayUtils.putBytes(header, 8, filesystemBytes);
        ByteArrayUtils.putUnsignedInt16(header, 24, this.entryCount);
        return header;
    }

    public void decode(byte[] header) {
        Check.notNull(header, "header");
        Check.isTrue(header.length == 26, "header.length == HEADER_SIZE");
        this.magic = ByteArrayUtils.getInt32(header, 0);
        this.version = ByteArrayUtils.getInt32(header, 4);
        byte[] filesystemTemp = ByteArrayUtils.getBytes(header, 8, 16);
        this.entryCount = ByteArrayUtils.getUnsignedInt16(header, 24);
        int filesystemLen = 0;
        int i = 0;
        while (i < 16 && filesystemTemp[i] != 0 && filesystemTemp[i] != 32) {
            ++i;
            ++filesystemLen;
        }
        this.filesystem = filesystemLen == 0 ? null : Charset.forName("US-ASCII").decode(ByteBuffer.wrap(filesystemTemp, 0, filesystemLen)).toString();
    }

    public String toString() {
        StringBuffer value = new StringBuffer();
        if (this.magic == 333312) {
            value.append("AppleSingle");
        } else if (this.magic == 333319) {
            value.append("AppleDouble");
        } else {
            value.append("magic=0x" + Integer.toHexString(this.magic));
        }
        value.append(", ");
        if (this.version == 65536) {
            value.append("version=1");
        } else if (this.version == 131072) {
            value.append("version=2");
        } else {
            value.append("version=0x" + Integer.toHexString(this.version));
        }
        value.append(", ");
        value.append("filesystem=" + this.filesystem);
        value.append(", ");
        value.append("entryCount=" + this.entryCount);
        return value.toString();
    }
}

