/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.CollatorFactory;
import java.util.Locale;

public class LocaleInvariantStringHelpers {
    private LocaleInvariantStringHelpers() {
    }

    public static boolean caseInsensitiveEquals(String a, String b) {
        return CollatorFactory.getCaseInsensitiveCollator().equals(a, b);
    }

    public static boolean caseInsensitiveEquals(char a, char b) {
        return a == b || (a = Character.toUpperCase(a)) == (b = Character.toUpperCase(b)) || (a = Character.toLowerCase(a)) == (b = Character.toLowerCase(b));
    }

    public static int caseInsensitiveHashCode(String string) {
        Check.notNull(string, "string");
        int hash = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + Character.toUpperCase(string.charAt(i));
        }
        return hash;
    }

    public static boolean caseInsensitiveStartsWith(String string, String substring) {
        Check.notNull(string, "string");
        Check.notNull(substring, "substring");
        if (substring.length() > string.length()) {
            return false;
        }
        String stringEndingSegment = string.substring(0, substring.length());
        return CollatorFactory.getCaseInsensitiveCollator(Locale.ENGLISH).equals(stringEndingSegment, substring);
    }

    public static boolean caseInsensitiveEndsWith(String string, String substring) {
        Check.notNull(string, "string");
        Check.notNull(substring, "substring");
        if (substring.length() > string.length()) {
            return false;
        }
        String stringEndingSegment = string.substring(string.length() - substring.length(), string.length());
        return CollatorFactory.getCaseInsensitiveCollator(Locale.ENGLISH).equals(stringEndingSegment, substring);
    }
}

