/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.proxy;

import com.microsoft.tfs.util.proxy.DelegatingInvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DelayingInvocationHandler
implements DelegatingInvocationHandler {
    private final Object proxiedObject;
    private final long delayMillis;

    public DelayingInvocationHandler(Object proxiedObject, long delayMillis) {
        this.proxiedObject = proxiedObject;
        this.delayMillis = delayMillis;
    }

    @Override
    public Object getProxiedObject() {
        return this.proxiedObject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Thread.sleep(this.delayMillis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        try {
            return method.invoke(this.proxiedObject, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }
}

