/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.tasks;

import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public class FileProcessingProgressMonitorAdapter
implements TaskMonitor {
    private static final long MONITORING_TIME_INTERVAL = 5000L;
    private static String PERCENT_MESSAGE_FORMAT = "{0}/{1} ({2,number,percent})";
    private final long alreadyProcessed;
    private final long totalLength;
    private final String messageFormat;
    private final TaskMonitor parentMonitor;
    private long currentProgress;
    private long lastDisplayTime;
    private final long startTime;
    private boolean monitoringRequested = false;
    private static final DecimalFormat[] sizeFormat = new DecimalFormat[]{new DecimalFormat("#0.00"), new DecimalFormat("#0.0"), new DecimalFormat("#0")};
    private static final String[] formats = new String[]{"{0}", "{0}KB", "{0}MB", "{0}GB", "{0}TB", "{0}PB"};

    public FileProcessingProgressMonitorAdapter(TaskMonitor parentMonitor, long totalLength) {
        this(parentMonitor, 0L, totalLength, "{0}");
    }

    public FileProcessingProgressMonitorAdapter(TaskMonitor parentMonitor, long totalLength, String messageFormat) {
        this(parentMonitor, 0L, totalLength, messageFormat);
    }

    public FileProcessingProgressMonitorAdapter(TaskMonitor parentMonitor, long alreadyProcessed, long totalLength) {
        this(parentMonitor, alreadyProcessed, totalLength, "{0}");
    }

    public FileProcessingProgressMonitorAdapter(TaskMonitor parentMonitor, long alreadyProcessed, long totalLength, String messageFormat) {
        this.parentMonitor = parentMonitor;
        this.alreadyProcessed = alreadyProcessed;
        this.totalLength = totalLength;
        this.messageFormat = messageFormat;
        this.currentProgress = 0L;
        this.lastDisplayTime = System.currentTimeMillis();
        this.startTime = System.currentTimeMillis();
        this.monitoringRequested = totalLength > 0L;
    }

    @Override
    public void worked(int processed) {
        this.worked(processed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void worked(int processed, boolean forced) {
        if (this.monitoringRequested) {
            this.currentProgress += (long)processed;
            long now = System.currentTimeMillis();
            if (forced || now - this.lastDisplayTime > 5000L) {
                this.lastDisplayTime = now;
                String percent = MessageFormat.format(PERCENT_MESSAGE_FORMAT, this.size(this.alreadyProcessed + this.currentProgress), this.size(this.totalLength), Float.valueOf((float)(this.alreadyProcessed + this.currentProgress) / (float)this.totalLength));
                TaskMonitor taskMonitor = this.parentMonitor;
                synchronized (taskMonitor) {
                    this.parentMonitor.setCurrentWorkDescription(MessageFormat.format(this.messageFormat, percent));
                }
            }
        }
    }

    private String size(long amount) {
        float value;
        int idx = 0;
        for (value = (float)amount; value > 1024.0f && idx < formats.length - 1; value /= 1024.0f, ++idx) {
        }
        DecimalFormat format = idx > 0 && value < 10.0f ? sizeFormat[0] : (idx > 0 && value < 100.0f ? sizeFormat[1] : sizeFormat[2]);
        return MessageFormat.format(formats[idx], format.format(value));
    }

    @Override
    public boolean isCanceled() {
        return this.parentMonitor.isCanceled();
    }

    @Override
    public void begin(String taskName, int totalWork) {
        this.currentProgress = 0L;
        this.lastDisplayTime = System.currentTimeMillis();
    }

    @Override
    public void beginWithUnknownTotalWork(String taskName) {
    }

    @Override
    public void done() {
        this.worked(0, this.lastDisplayTime - this.startTime > 5000L);
    }

    @Override
    public void setCanceled() {
        this.parentMonitor.setCanceled();
    }

    @Override
    public void setTaskName(String taskName) {
    }

    @Override
    public void setCurrentWorkDescription(String description) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskMonitor newSubTaskMonitor(int amount) {
        TaskMonitor taskMonitor = this.parentMonitor;
        synchronized (taskMonitor) {
            return this.parentMonitor.newSubTaskMonitor(amount);
        }
    }
}

