/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.TableProperties;

public class ExternalFileIngestionInfo {
    private final String columnFamilyName;
    private final String externalFilePath;
    private final String internalFilePath;
    private final long globalSeqno;
    private final TableProperties tableProperties;

    ExternalFileIngestionInfo(String columnFamilyName, String externalFilePath, String internalFilePath, long globalSeqno, TableProperties tableProperties) {
        this.columnFamilyName = columnFamilyName;
        this.externalFilePath = externalFilePath;
        this.internalFilePath = internalFilePath;
        this.globalSeqno = globalSeqno;
        this.tableProperties = tableProperties;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public String getExternalFilePath() {
        return this.externalFilePath;
    }

    public String getInternalFilePath() {
        return this.internalFilePath;
    }

    public long getGlobalSeqno() {
        return this.globalSeqno;
    }

    public TableProperties getTableProperties() {
        return this.tableProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalFileIngestionInfo that = (ExternalFileIngestionInfo)o;
        return this.globalSeqno == that.globalSeqno && Objects.equals(this.columnFamilyName, that.columnFamilyName) && Objects.equals(this.externalFilePath, that.externalFilePath) && Objects.equals(this.internalFilePath, that.internalFilePath) && Objects.equals(this.tableProperties, that.tableProperties);
    }

    public int hashCode() {
        return Objects.hash(this.columnFamilyName, this.externalFilePath, this.internalFilePath, this.globalSeqno, this.tableProperties);
    }

    public String toString() {
        return "ExternalFileIngestionInfo{columnFamilyName='" + this.columnFamilyName + '\'' + ", externalFilePath='" + this.externalFilePath + '\'' + ", internalFilePath='" + this.internalFilePath + '\'' + ", globalSeqno=" + this.globalSeqno + ", tableProperties=" + this.tableProperties + '}';
    }
}

