/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.rocksdb.AbstractTraceWriter;
import org.rocksdb.ByteBufferGetStatus;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyMetaData;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.CompactionJobInfo;
import org.rocksdb.CompactionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.Env;
import org.rocksdb.FlushOptions;
import org.rocksdb.Holder;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.KeyMayExist;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.LogFile;
import org.rocksdb.MutableColumnFamilyOptions;
import org.rocksdb.MutableDBOptions;
import org.rocksdb.NativeLibraryLoader;
import org.rocksdb.Options;
import org.rocksdb.Range;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksEnv;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.SizeApproximationFlag;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;
import org.rocksdb.Status;
import org.rocksdb.TableProperties;
import org.rocksdb.TraceOptions;
import org.rocksdb.TransactionLogIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;
import org.rocksdb.util.Environment;

public class RocksDB
extends RocksObject {
    public static final byte[] DEFAULT_COLUMN_FAMILY = "default".getBytes(StandardCharsets.UTF_8);
    public static final int NOT_FOUND = -1;
    private static final AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);
    private final List<ColumnFamilyHandle> ownedColumnFamilyHandles = new ArrayList<ColumnFamilyHandle>();
    protected DBOptionsInterface<?> options_;
    private static Version version;

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            String tmpDir = System.getenv("ROCKSDB_SHAREDLIB_DIR");
            for (CompressionType compressionType : CompressionType.values()) {
                try {
                    if (compressionType.getLibraryName() == null) continue;
                    System.loadLibrary(compressionType.getLibraryName());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            try {
                NativeLibraryLoader.getInstance().loadLibrary(tmpDir);
            }
            catch (IOException e) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new RuntimeException("Unable to load the RocksDB shared library", e);
            }
            int encodedVersion = RocksDB.version();
            version = Version.fromEncodedVersion(encodedVersion);
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void loadLibrary(List<String> paths) {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            block6: for (CompressionType compressionType : CompressionType.values()) {
                if (compressionType.equals((Object)CompressionType.NO_COMPRESSION)) continue;
                for (String path : paths) {
                    try {
                        System.load(path + "/" + Environment.getSharedLibraryFileName(compressionType.getLibraryName()));
                        continue block6;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    }
                }
            }
            boolean success = false;
            UnsatisfiedLinkError err = null;
            for (String path : paths) {
                try {
                    System.load(path + "/" + Environment.getJniLibraryFileName("speedbjni"));
                    success = true;
                    break;
                }
                catch (UnsatisfiedLinkError e) {
                    err = e;
                }
            }
            if (!success) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw err;
            }
            int encodedVersion = RocksDB.version();
            version = Version.fromEncodedVersion(encodedVersion);
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static Version rocksdbVersion() {
        return version;
    }

    protected RocksDB(long nativeHandle) {
        super(nativeHandle);
    }

    public static RocksDB open(String path) throws RocksDBException {
        Options options = new Options();
        options.setCreateIfMissing(true);
        return RocksDB.open(options, path);
    }

    public static RocksDB open(String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        DBOptions options = new DBOptions();
        return RocksDB.open(options, path, columnFamilyDescriptors, columnFamilyHandles);
    }

    public static RocksDB open(Options options, String path) throws RocksDBException {
        RocksDB db = new RocksDB(RocksDB.open(options.nativeHandle_, path));
        db.storeOptionsInstance(options);
        return db;
    }

    public static RocksDB open(DBOptions options, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        long[] cfOptionHandles = new long[columnFamilyDescriptors.size()];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor cfDescriptor = columnFamilyDescriptors.get(i);
            cfNames[i] = cfDescriptor.getName();
            cfOptionHandles[i] = cfDescriptor.getOptions().nativeHandle_;
        }
        long[] handles = RocksDB.open(options.nativeHandle_, path, cfNames, cfOptionHandles);
        RocksDB db = new RocksDB(handles[0]);
        db.storeOptionsInstance(options);
        for (int i = 1; i < handles.length; ++i) {
            ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(db, handles[i]);
            columnFamilyHandles.add(columnFamilyHandle);
        }
        db.ownedColumnFamilyHandles.addAll(columnFamilyHandles);
        return db;
    }

    public static RocksDB openReadOnly(String path) throws RocksDBException {
        Options options = new Options();
        return RocksDB.openReadOnly(options, path);
    }

    public static RocksDB openReadOnly(Options options, String path) throws RocksDBException {
        return RocksDB.openReadOnly(options, path, false);
    }

    public static RocksDB openReadOnly(Options options, String path, boolean errorIfWalFileExists) throws RocksDBException {
        RocksDB db = new RocksDB(RocksDB.openROnly(options.nativeHandle_, path, errorIfWalFileExists));
        db.storeOptionsInstance(options);
        return db;
    }

    public static RocksDB openReadOnly(String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        DBOptions options = new DBOptions();
        return RocksDB.openReadOnly(options, path, columnFamilyDescriptors, columnFamilyHandles, false);
    }

    public static RocksDB openReadOnly(DBOptions options, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        return RocksDB.openReadOnly(options, path, columnFamilyDescriptors, columnFamilyHandles, false);
    }

    public static RocksDB openReadOnly(DBOptions options, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles, boolean errorIfWalFileExists) throws RocksDBException {
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        long[] cfOptionHandles = new long[columnFamilyDescriptors.size()];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor cfDescriptor = columnFamilyDescriptors.get(i);
            cfNames[i] = cfDescriptor.getName();
            cfOptionHandles[i] = cfDescriptor.getOptions().nativeHandle_;
        }
        long[] handles = RocksDB.openROnly(options.nativeHandle_, path, cfNames, cfOptionHandles, errorIfWalFileExists);
        RocksDB db = new RocksDB(handles[0]);
        db.storeOptionsInstance(options);
        for (int i = 1; i < handles.length; ++i) {
            ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(db, handles[i]);
            columnFamilyHandles.add(columnFamilyHandle);
        }
        db.ownedColumnFamilyHandles.addAll(columnFamilyHandles);
        return db;
    }

    public static RocksDB openAsSecondary(Options options, String path, String secondaryPath) throws RocksDBException {
        RocksDB db = new RocksDB(RocksDB.openAsSecondary(options.nativeHandle_, path, secondaryPath));
        db.storeOptionsInstance(options);
        return db;
    }

    public static RocksDB openAsSecondary(DBOptions options, String path, String secondaryPath, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        long[] cfOptionHandles = new long[columnFamilyDescriptors.size()];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor cfDescriptor = columnFamilyDescriptors.get(i);
            cfNames[i] = cfDescriptor.getName();
            cfOptionHandles[i] = cfDescriptor.getOptions().nativeHandle_;
        }
        long[] handles = RocksDB.openAsSecondary(options.nativeHandle_, path, secondaryPath, cfNames, cfOptionHandles);
        RocksDB db = new RocksDB(handles[0]);
        db.storeOptionsInstance(options);
        for (int i = 1; i < handles.length; ++i) {
            ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(db, handles[i]);
            columnFamilyHandles.add(columnFamilyHandle);
        }
        db.ownedColumnFamilyHandles.addAll(columnFamilyHandles);
        return db;
    }

    public void closeE() throws RocksDBException {
        for (ColumnFamilyHandle columnFamilyHandle : this.ownedColumnFamilyHandles) {
            columnFamilyHandle.close();
        }
        this.ownedColumnFamilyHandles.clear();
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                RocksDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public void close() {
        for (ColumnFamilyHandle columnFamilyHandle : this.ownedColumnFamilyHandles) {
            columnFamilyHandle.close();
        }
        this.ownedColumnFamilyHandles.clear();
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                RocksDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    public static List<byte[]> listColumnFamilies(Options options, String path) throws RocksDBException {
        return Arrays.asList(RocksDB.listColumnFamilies(options.nativeHandle_, path));
    }

    public ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnFamilyDescriptor) throws RocksDBException {
        ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(this, this.createColumnFamily(this.nativeHandle_, columnFamilyDescriptor.getName(), columnFamilyDescriptor.getName().length, columnFamilyDescriptor.getOptions().nativeHandle_));
        this.ownedColumnFamilyHandles.add(columnFamilyHandle);
        return columnFamilyHandle;
    }

    public List<ColumnFamilyHandle> createColumnFamilies(ColumnFamilyOptions columnFamilyOptions, List<byte[]> columnFamilyNames) throws RocksDBException {
        byte[][] cfNames = (byte[][])columnFamilyNames.toArray((T[])new byte[0][]);
        long[] cfHandles = this.createColumnFamilies(this.nativeHandle_, columnFamilyOptions.nativeHandle_, cfNames);
        ArrayList<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(cfHandles.length);
        for (long cfHandle : cfHandles) {
            ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(this, cfHandle);
            columnFamilyHandles.add(columnFamilyHandle);
        }
        this.ownedColumnFamilyHandles.addAll(columnFamilyHandles);
        return columnFamilyHandles;
    }

    public List<ColumnFamilyHandle> createColumnFamilies(List<ColumnFamilyDescriptor> columnFamilyDescriptors) throws RocksDBException {
        long[] cfOptsHandles = new long[columnFamilyDescriptors.size()];
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor columnFamilyDescriptor = columnFamilyDescriptors.get(i);
            cfOptsHandles[i] = columnFamilyDescriptor.getOptions().nativeHandle_;
            cfNames[i] = columnFamilyDescriptor.getName();
        }
        long[] cfHandles = this.createColumnFamilies(this.nativeHandle_, cfOptsHandles, (byte[][])cfNames);
        ArrayList<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(cfHandles.length);
        for (long cfHandle : cfHandles) {
            ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(this, cfHandle);
            columnFamilyHandles.add(columnFamilyHandle);
        }
        this.ownedColumnFamilyHandles.addAll(columnFamilyHandles);
        return columnFamilyHandles;
    }

    public void dropColumnFamily(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.dropColumnFamily(this.nativeHandle_, columnFamilyHandle.nativeHandle_);
    }

    public void dropColumnFamilies(List<ColumnFamilyHandle> columnFamilies) throws RocksDBException {
        long[] cfHandles = new long[columnFamilies.size()];
        for (int i = 0; i < columnFamilies.size(); ++i) {
            cfHandles[i] = columnFamilies.get((int)i).nativeHandle_;
        }
        this.dropColumnFamilies(this.nativeHandle_, cfHandles);
    }

    public void destroyColumnFamilyHandle(ColumnFamilyHandle columnFamilyHandle) {
        for (int i = 0; i < this.ownedColumnFamilyHandles.size(); ++i) {
            ColumnFamilyHandle ownedHandle = this.ownedColumnFamilyHandles.get(i);
            if (!ownedHandle.equals(columnFamilyHandle)) continue;
            columnFamilyHandle.close();
            this.ownedColumnFamilyHandles.remove(i);
            return;
        }
    }

    public void put(byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, key, 0, key.length, value, 0, value.length);
    }

    public void put(byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.put(this.nativeHandle_, key, offset, len, value, vOffset, vLen);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, key, 0, key.length, value, 0, value.length, columnFamilyHandle.nativeHandle_);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.put(this.nativeHandle_, key, offset, len, value, vOffset, vLen, columnFamilyHandle.nativeHandle_);
    }

    public void put(WriteOptions writeOpts, byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, writeOpts.nativeHandle_, key, 0, key.length, value, 0, value.length);
    }

    public void put(WriteOptions writeOpts, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.put(this.nativeHandle_, writeOpts.nativeHandle_, key, offset, len, value, vOffset, vLen);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpts, byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, writeOpts.nativeHandle_, key, 0, key.length, value, 0, value.length, columnFamilyHandle.nativeHandle_);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpts, ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        this.putDirect(this.nativeHandle_, writeOpts.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining(), columnFamilyHandle.nativeHandle_);
        key.position(key.limit());
        value.position(value.limit());
    }

    public void put(WriteOptions writeOpts, ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        this.putDirect(this.nativeHandle_, writeOpts.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining(), 0L);
        key.position(key.limit());
        value.position(value.limit());
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpts, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.put(this.nativeHandle_, writeOpts.nativeHandle_, key, offset, len, value, vOffset, vLen, columnFamilyHandle.nativeHandle_);
    }

    public void delete(byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, key, 0, key.length);
    }

    public void delete(byte[] key, int offset, int len) throws RocksDBException {
        this.delete(this.nativeHandle_, key, offset, len);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, key, 0, key.length, columnFamilyHandle.nativeHandle_);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key, int offset, int len) throws RocksDBException {
        this.delete(this.nativeHandle_, key, offset, len, columnFamilyHandle.nativeHandle_);
    }

    public void delete(WriteOptions writeOpt, byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOpt.nativeHandle_, key, 0, key.length);
    }

    public void delete(WriteOptions writeOpt, byte[] key, int offset, int len) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOpt.nativeHandle_, key, offset, len);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpt, byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOpt.nativeHandle_, key, 0, key.length, columnFamilyHandle.nativeHandle_);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpt, byte[] key, int offset, int len) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOpt.nativeHandle_, key, offset, len, columnFamilyHandle.nativeHandle_);
    }

    public int get(ReadOptions opt, ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        int result = this.getDirect(this.nativeHandle_, opt.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining(), 0L);
        if (result != -1) {
            value.limit(Math.min(value.limit(), value.position() + result));
        }
        key.position(key.limit());
        return result;
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions opt, ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        int result = this.getDirect(this.nativeHandle_, opt.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining(), columnFamilyHandle.nativeHandle_);
        if (result != -1) {
            value.limit(Math.min(value.limit(), value.position() + result));
        }
        key.position(key.limit());
        return result;
    }

    public void singleDelete(byte[] key) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, key, key.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    public void singleDelete(WriteOptions writeOpt, byte[] key) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, writeOpt.nativeHandle_, key, key.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpt, byte[] key) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, writeOpt.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteRange(byte[] beginKey, byte[] endKey) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, beginKey, 0, beginKey.length, endKey, 0, endKey.length);
    }

    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, byte[] beginKey, byte[] endKey) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, beginKey, 0, beginKey.length, endKey, 0, endKey.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteRange(WriteOptions writeOpt, byte[] beginKey, byte[] endKey) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, writeOpt.nativeHandle_, beginKey, 0, beginKey.length, endKey, 0, endKey.length);
    }

    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpt, byte[] beginKey, byte[] endKey) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, writeOpt.nativeHandle_, beginKey, 0, beginKey.length, endKey, 0, endKey.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, key, 0, key.length, value, 0, value.length);
    }

    public void merge(byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.merge(this.nativeHandle_, key, offset, len, value, vOffset, vLen);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, key, 0, key.length, value, 0, value.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.merge(this.nativeHandle_, key, offset, len, value, vOffset, vLen, columnFamilyHandle.nativeHandle_);
    }

    public void merge(WriteOptions writeOpts, byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOpts.nativeHandle_, key, 0, key.length, value, 0, value.length);
    }

    public void merge(WriteOptions writeOpts, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.merge(this.nativeHandle_, writeOpts.nativeHandle_, key, offset, len, value, vOffset, vLen);
    }

    public void delete(WriteOptions writeOpt, ByteBuffer key) throws RocksDBException {
        assert (key.isDirect());
        this.deleteDirect(this.nativeHandle_, writeOpt.nativeHandle_, key, key.position(), key.remaining(), 0L);
        key.position(key.limit());
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpt, ByteBuffer key) throws RocksDBException {
        assert (key.isDirect());
        this.deleteDirect(this.nativeHandle_, writeOpt.nativeHandle_, key, key.position(), key.remaining(), columnFamilyHandle.nativeHandle_);
        key.position(key.limit());
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpts, byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOpts.nativeHandle_, key, 0, key.length, value, 0, value.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOpts, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        this.merge(this.nativeHandle_, writeOpts.nativeHandle_, key, offset, len, value, vOffset, vLen, columnFamilyHandle.nativeHandle_);
    }

    public void write(WriteOptions writeOpts, WriteBatch updates) throws RocksDBException {
        this.write0(this.nativeHandle_, writeOpts.nativeHandle_, updates.nativeHandle_);
    }

    public void write(WriteOptions writeOpts, WriteBatchWithIndex updates) throws RocksDBException {
        this.write1(this.nativeHandle_, writeOpts.nativeHandle_, updates.nativeHandle_);
    }

    public int get(byte[] key, byte[] value) throws RocksDBException {
        return this.get(this.nativeHandle_, key, 0, key.length, value, 0, value.length);
    }

    public int get(byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        return this.get(this.nativeHandle_, key, offset, len, value, vOffset, vLen);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException, IllegalArgumentException {
        return this.get(this.nativeHandle_, key, 0, key.length, value, 0, value.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException, IllegalArgumentException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        return this.get(this.nativeHandle_, key, offset, len, value, vOffset, vLen, columnFamilyHandle.nativeHandle_);
    }

    public int get(ReadOptions opt, byte[] key, byte[] value) throws RocksDBException {
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, 0, key.length, value, 0, value.length);
    }

    public int get(ReadOptions opt, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, offset, len, value, vOffset, vLen);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions opt, byte[] key, byte[] value) throws RocksDBException {
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, 0, key.length, value, 0, value.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions opt, byte[] key, int offset, int len, byte[] value, int vOffset, int vLen) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        RocksDB.checkBounds(vOffset, vLen, value.length);
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, offset, len, value, vOffset, vLen, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(byte[] key) throws RocksDBException {
        return this.get(this.nativeHandle_, key, 0, key.length);
    }

    public byte[] get(byte[] key, int offset, int len) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        return this.get(this.nativeHandle_, key, offset, len);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        return this.get(this.nativeHandle_, key, 0, key.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] key, int offset, int len) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        return this.get(this.nativeHandle_, key, offset, len, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ReadOptions opt, byte[] key) throws RocksDBException {
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, 0, key.length);
    }

    public byte[] get(ReadOptions opt, byte[] key, int offset, int len) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, offset, len);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions opt, byte[] key) throws RocksDBException {
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, 0, key.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions opt, byte[] key, int offset, int len) throws RocksDBException {
        RocksDB.checkBounds(offset, len, key.length);
        return this.get(this.nativeHandle_, opt.nativeHandle_, key, offset, len, columnFamilyHandle.nativeHandle_);
    }

    public List<byte[]> multiGetAsList(List<byte[]> keys) throws RocksDBException {
        assert (keys.size() != 0);
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        int[] keyOffsets = new int[keysArray.length];
        int[] keyLengths = new int[keysArray.length];
        for (int i = 0; i < keyLengths.length; ++i) {
            keyLengths[i] = keysArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, keysArray, keyOffsets, keyLengths));
    }

    public List<byte[]> multiGetAsList(List<ColumnFamilyHandle> columnFamilyHandleList, List<byte[]> keys) throws RocksDBException, IllegalArgumentException {
        assert (keys.size() != 0);
        if (keys.size() != columnFamilyHandleList.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] cfHandles = new long[columnFamilyHandleList.size()];
        for (int i = 0; i < columnFamilyHandleList.size(); ++i) {
            cfHandles[i] = columnFamilyHandleList.get((int)i).nativeHandle_;
        }
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        int[] keyOffsets = new int[keysArray.length];
        int[] keyLengths = new int[keysArray.length];
        for (int i = 0; i < keyLengths.length; ++i) {
            keyLengths[i] = keysArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, keysArray, keyOffsets, keyLengths, cfHandles));
    }

    public List<byte[]> multiGetAsList(ReadOptions opt, List<byte[]> keys) throws RocksDBException {
        assert (keys.size() != 0);
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        int[] keyOffsets = new int[keysArray.length];
        int[] keyLengths = new int[keysArray.length];
        for (int i = 0; i < keyLengths.length; ++i) {
            keyLengths[i] = keysArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, opt.nativeHandle_, keysArray, keyOffsets, keyLengths));
    }

    public List<byte[]> multiGetAsList(ReadOptions opt, List<ColumnFamilyHandle> columnFamilyHandleList, List<byte[]> keys) throws RocksDBException {
        assert (keys.size() != 0);
        if (keys.size() != columnFamilyHandleList.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] cfHandles = new long[columnFamilyHandleList.size()];
        for (int i = 0; i < columnFamilyHandleList.size(); ++i) {
            cfHandles[i] = columnFamilyHandleList.get((int)i).nativeHandle_;
        }
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        int[] keyOffsets = new int[keysArray.length];
        int[] keyLengths = new int[keysArray.length];
        for (int i = 0; i < keyLengths.length; ++i) {
            keyLengths[i] = keysArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, opt.nativeHandle_, keysArray, keyOffsets, keyLengths, cfHandles));
    }

    public List<ByteBufferGetStatus> multiGetByteBuffers(List<ByteBuffer> keys, List<ByteBuffer> values) throws RocksDBException {
        ReadOptions readOptions = new ReadOptions();
        ArrayList<ColumnFamilyHandle> columnFamilyHandleList = new ArrayList<ColumnFamilyHandle>(1);
        columnFamilyHandleList.add(this.getDefaultColumnFamily());
        return this.multiGetByteBuffers(readOptions, columnFamilyHandleList, keys, values);
    }

    public List<ByteBufferGetStatus> multiGetByteBuffers(ReadOptions readOptions, List<ByteBuffer> keys, List<ByteBuffer> values) throws RocksDBException {
        ArrayList<ColumnFamilyHandle> columnFamilyHandleList = new ArrayList<ColumnFamilyHandle>(1);
        columnFamilyHandleList.add(this.getDefaultColumnFamily());
        return this.multiGetByteBuffers(readOptions, columnFamilyHandleList, keys, values);
    }

    public List<ByteBufferGetStatus> multiGetByteBuffers(List<ColumnFamilyHandle> columnFamilyHandleList, List<ByteBuffer> keys, List<ByteBuffer> values) throws RocksDBException {
        ReadOptions readOptions = new ReadOptions();
        return this.multiGetByteBuffers(readOptions, columnFamilyHandleList, keys, values);
    }

    public List<ByteBufferGetStatus> multiGetByteBuffers(ReadOptions readOptions, List<ColumnFamilyHandle> columnFamilyHandleList, List<ByteBuffer> keys, List<ByteBuffer> values) throws RocksDBException {
        assert (keys.size() != 0);
        if (keys.size() != columnFamilyHandleList.size() && columnFamilyHandleList.size() > 1) {
            throw new IllegalArgumentException("Wrong number of ColumnFamilyHandle(s) supplied. Provide 0, 1, or as many as there are key/value(s)");
        }
        if (values.size() != keys.size()) {
            throw new IllegalArgumentException("For each key there must be a corresponding value.");
        }
        for (ByteBuffer key : keys) {
            if (key.isDirect()) continue;
            throw new IllegalArgumentException("All key buffers must be direct byte buffers");
        }
        for (ByteBuffer value : values) {
            if (value.isDirect()) continue;
            throw new IllegalArgumentException("All value buffers must be direct byte buffers");
        }
        int numCFHandles = columnFamilyHandleList.size();
        long[] cfHandles = new long[numCFHandles];
        for (int i = 0; i < numCFHandles; ++i) {
            cfHandles[i] = columnFamilyHandleList.get((int)i).nativeHandle_;
        }
        int numValues = keys.size();
        ByteBuffer[] keysArray = keys.toArray(new ByteBuffer[0]);
        int[] keyOffsets = new int[numValues];
        int[] keyLengths = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            keyOffsets[i] = keysArray[i].position();
            keyLengths[i] = keysArray[i].limit();
        }
        ByteBuffer[] valuesArray = values.toArray(new ByteBuffer[0]);
        int[] valuesSizeArray = new int[numValues];
        Status[] statusArray = new Status[numValues];
        this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, cfHandles, keysArray, keyOffsets, keyLengths, valuesArray, valuesSizeArray, statusArray);
        ArrayList<ByteBufferGetStatus> results = new ArrayList<ByteBufferGetStatus>();
        for (int i = 0; i < numValues; ++i) {
            Status status = statusArray[i];
            if (status.getCode() == Status.Code.Ok) {
                ByteBuffer value = valuesArray[i];
                value.position(Math.min(valuesSizeArray[i], value.capacity()));
                value.flip();
                results.add(new ByteBufferGetStatus(status, valuesSizeArray[i], value));
                continue;
            }
            results.add(new ByteBufferGetStatus(status));
        }
        return results;
    }

    public boolean keyMayExist(byte[] key, Holder<byte[]> valueHolder) {
        return this.keyMayExist(key, 0, key.length, valueHolder);
    }

    public boolean keyMayExist(byte[] key, int offset, int len, Holder<byte[]> valueHolder) {
        return this.keyMayExist((ColumnFamilyHandle)null, key, offset, len, valueHolder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, byte[] key, Holder<byte[]> valueHolder) {
        return this.keyMayExist(columnFamilyHandle, key, 0, key.length, valueHolder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, byte[] key, int offset, int len, Holder<byte[]> valueHolder) {
        return this.keyMayExist(columnFamilyHandle, null, key, offset, len, valueHolder);
    }

    public boolean keyMayExist(ReadOptions readOptions, byte[] key, Holder<byte[]> valueHolder) {
        return this.keyMayExist(readOptions, key, 0, key.length, valueHolder);
    }

    public boolean keyMayExist(ReadOptions readOptions, byte[] key, int offset, int len, Holder<byte[]> valueHolder) {
        return this.keyMayExist(null, readOptions, key, offset, len, valueHolder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] key, Holder<byte[]> valueHolder) {
        return this.keyMayExist(columnFamilyHandle, readOptions, key, 0, key.length, valueHolder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] key, int offset, int len, Holder<byte[]> valueHolder) {
        RocksDB.checkBounds(offset, len, key.length);
        if (valueHolder == null) {
            return this.keyMayExist(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, readOptions == null ? 0L : readOptions.nativeHandle_, key, offset, len);
        }
        byte[][] result = this.keyMayExistFoundValue(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, readOptions == null ? 0L : readOptions.nativeHandle_, key, offset, len);
        if (result[0][0] == 0) {
            valueHolder.setValue(null);
            return false;
        }
        if (result[0][0] == 1) {
            valueHolder.setValue(null);
            return true;
        }
        valueHolder.setValue(result[1]);
        return true;
    }

    public boolean keyMayExist(ByteBuffer key) {
        return this.keyMayExist(null, (ReadOptions)null, key);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, ByteBuffer key) {
        return this.keyMayExist(columnFamilyHandle, (ReadOptions)null, key);
    }

    public boolean keyMayExist(ReadOptions readOptions, ByteBuffer key) {
        return this.keyMayExist(null, readOptions, key);
    }

    public KeyMayExist keyMayExist(ByteBuffer key, ByteBuffer value) {
        return this.keyMayExist(null, null, key, value);
    }

    public KeyMayExist keyMayExist(ColumnFamilyHandle columnFamilyHandle, ByteBuffer key, ByteBuffer value) {
        return this.keyMayExist(columnFamilyHandle, null, key, value);
    }

    public KeyMayExist keyMayExist(ReadOptions readOptions, ByteBuffer key, ByteBuffer value) {
        return this.keyMayExist(null, readOptions, key, value);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, ByteBuffer key) {
        assert (key != null) : "key ByteBuffer parameter cannot be null";
        assert (key.isDirect()) : "key parameter must be a direct ByteBuffer";
        return this.keyMayExistDirect(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, readOptions == null ? 0L : readOptions.nativeHandle_, key, key.position(), key.limit());
    }

    public KeyMayExist keyMayExist(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, ByteBuffer key, ByteBuffer value) {
        assert (key != null) : "key ByteBuffer parameter cannot be null";
        assert (key.isDirect()) : "key parameter must be a direct ByteBuffer";
        assert (value != null) : "value ByteBuffer parameter cannot be null. If you do not need the value, use a different version of the method";
        assert (value.isDirect()) : "value parameter must be a direct ByteBuffer";
        int[] result = this.keyMayExistDirectFoundValue(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, readOptions == null ? 0L : readOptions.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining());
        int valueLength = result[1];
        value.limit(value.position() + Math.min(valueLength, value.remaining()));
        return new KeyMayExist(KeyMayExist.KeyMayExistEnum.values()[result[0]], valueLength);
    }

    public RocksIterator newIterator() {
        return new RocksIterator(this, this.iterator(this.nativeHandle_));
    }

    public RocksIterator newIterator(ReadOptions readOptions) {
        return new RocksIterator(this, this.iterator(this.nativeHandle_, readOptions.nativeHandle_));
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle) {
        return new RocksIterator(this, this.iteratorCF(this.nativeHandle_, columnFamilyHandle.nativeHandle_));
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions) {
        return new RocksIterator(this, this.iteratorCF(this.nativeHandle_, columnFamilyHandle.nativeHandle_, readOptions.nativeHandle_));
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> columnFamilyHandleList) throws RocksDBException {
        return this.newIterators(columnFamilyHandleList, new ReadOptions());
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> columnFamilyHandleList, ReadOptions readOptions) throws RocksDBException {
        long[] columnFamilyHandles = new long[columnFamilyHandleList.size()];
        for (int i = 0; i < columnFamilyHandleList.size(); ++i) {
            columnFamilyHandles[i] = columnFamilyHandleList.get((int)i).nativeHandle_;
        }
        long[] iteratorRefs = this.iterators(this.nativeHandle_, columnFamilyHandles, readOptions.nativeHandle_);
        ArrayList<RocksIterator> iterators = new ArrayList<RocksIterator>(columnFamilyHandleList.size());
        for (int i = 0; i < columnFamilyHandleList.size(); ++i) {
            iterators.add(new RocksIterator(this, iteratorRefs[i]));
        }
        return iterators;
    }

    public Snapshot getSnapshot() {
        long snapshotHandle = this.getSnapshot(this.nativeHandle_);
        if (snapshotHandle != 0L) {
            return new Snapshot(snapshotHandle);
        }
        return null;
    }

    public void releaseSnapshot(Snapshot snapshot) {
        if (snapshot != null) {
            this.releaseSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        }
    }

    public String getProperty(ColumnFamilyHandle columnFamilyHandle, String property) throws RocksDBException {
        return this.getProperty(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, property, property.length());
    }

    public String getProperty(String property) throws RocksDBException {
        return this.getProperty(null, property);
    }

    public Map<String, String> getMapProperty(String property) throws RocksDBException {
        return this.getMapProperty(null, property);
    }

    public Map<String, String> getMapProperty(ColumnFamilyHandle columnFamilyHandle, String property) throws RocksDBException {
        return this.getMapProperty(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, property, property.length());
    }

    public long getLongProperty(String property) throws RocksDBException {
        return this.getLongProperty(null, property);
    }

    public long getLongProperty(ColumnFamilyHandle columnFamilyHandle, String property) throws RocksDBException {
        return this.getLongProperty(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, property, property.length());
    }

    public void resetStats() throws RocksDBException {
        this.resetStats(this.nativeHandle_);
    }

    public long getAggregatedLongProperty(String property) throws RocksDBException {
        return this.getAggregatedLongProperty(this.nativeHandle_, property, property.length());
    }

    public long[] getApproximateSizes(ColumnFamilyHandle columnFamilyHandle, List<Range> ranges, SizeApproximationFlag ... sizeApproximationFlags) {
        byte flags = 0;
        for (SizeApproximationFlag sizeApproximationFlag : sizeApproximationFlags) {
            flags = (byte)(flags | sizeApproximationFlag.getValue());
        }
        return this.getApproximateSizes(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, RocksDB.toRangeSliceHandles(ranges), flags);
    }

    public long[] getApproximateSizes(List<Range> ranges, SizeApproximationFlag ... sizeApproximationFlags) {
        return this.getApproximateSizes(null, ranges, sizeApproximationFlags);
    }

    public CountAndSize getApproximateMemTableStats(ColumnFamilyHandle columnFamilyHandle, Range range) {
        long[] result = this.getApproximateMemTableStats(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, range.start.getNativeHandle(), range.limit.getNativeHandle());
        return new CountAndSize(result[0], result[1]);
    }

    public CountAndSize getApproximateMemTableStats(Range range) {
        return this.getApproximateMemTableStats(null, range);
    }

    public void compactRange() throws RocksDBException {
        this.compactRange(null);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.compactRange(this.nativeHandle_, null, -1, null, -1, 0L, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(byte[] begin, byte[] end) throws RocksDBException {
        this.compactRange(null, begin, end);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] begin, byte[] end) throws RocksDBException {
        this.compactRange(this.nativeHandle_, begin, begin == null ? -1 : begin.length, end, end == null ? -1 : end.length, 0L, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] begin, byte[] end, CompactRangeOptions compactRangeOptions) throws RocksDBException {
        this.compactRange(this.nativeHandle_, begin, begin == null ? -1 : begin.length, end, end == null ? -1 : end.length, compactRangeOptions.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public void setOptions(ColumnFamilyHandle columnFamilyHandle, MutableColumnFamilyOptions mutableColumnFamilyOptions) throws RocksDBException {
        this.setOptions(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, mutableColumnFamilyOptions.getKeys(), mutableColumnFamilyOptions.getValues());
    }

    public MutableColumnFamilyOptions.MutableColumnFamilyOptionsBuilder getOptions(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        String optionsString = this.getOptions(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
        return MutableColumnFamilyOptions.parse(optionsString, true);
    }

    public MutableColumnFamilyOptions.MutableColumnFamilyOptionsBuilder getOptions() throws RocksDBException {
        return this.getOptions(null);
    }

    public MutableDBOptions.MutableDBOptionsBuilder getDBOptions() throws RocksDBException {
        String optionsString = this.getDBOptions(this.nativeHandle_);
        return MutableDBOptions.parse(optionsString, true);
    }

    public void setOptions(MutableColumnFamilyOptions mutableColumnFamilyOptions) throws RocksDBException {
        this.setOptions(null, mutableColumnFamilyOptions);
    }

    public void setDBOptions(MutableDBOptions mutableDBoptions) throws RocksDBException {
        this.setDBOptions(this.nativeHandle_, mutableDBoptions.getKeys(), mutableDBoptions.getValues());
    }

    public List<String> compactFiles(CompactionOptions compactionOptions, List<String> inputFileNames, int outputLevel, int outputPathId, CompactionJobInfo compactionJobInfo) throws RocksDBException {
        return this.compactFiles(compactionOptions, null, inputFileNames, outputLevel, outputPathId, compactionJobInfo);
    }

    public List<String> compactFiles(CompactionOptions compactionOptions, ColumnFamilyHandle columnFamilyHandle, List<String> inputFileNames, int outputLevel, int outputPathId, CompactionJobInfo compactionJobInfo) throws RocksDBException {
        return Arrays.asList(this.compactFiles(this.nativeHandle_, compactionOptions.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, inputFileNames.toArray(new String[0]), outputLevel, outputPathId, compactionJobInfo == null ? 0L : compactionJobInfo.nativeHandle_));
    }

    public void cancelAllBackgroundWork(boolean wait) {
        this.cancelAllBackgroundWork(this.nativeHandle_, wait);
    }

    public void pauseBackgroundWork() throws RocksDBException {
        this.pauseBackgroundWork(this.nativeHandle_);
    }

    public void continueBackgroundWork() throws RocksDBException {
        this.continueBackgroundWork(this.nativeHandle_);
    }

    public void enableAutoCompaction(List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        this.enableAutoCompaction(this.nativeHandle_, this.toNativeHandleList(columnFamilyHandles));
    }

    public int numberLevels() {
        return this.numberLevels(null);
    }

    public int numberLevels(ColumnFamilyHandle columnFamilyHandle) {
        return this.numberLevels(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public int maxMemCompactionLevel() {
        return this.maxMemCompactionLevel(null);
    }

    public int maxMemCompactionLevel(ColumnFamilyHandle columnFamilyHandle) {
        return this.maxMemCompactionLevel(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public int level0StopWriteTrigger() {
        return this.level0StopWriteTrigger(null);
    }

    public int level0StopWriteTrigger(ColumnFamilyHandle columnFamilyHandle) {
        return this.level0StopWriteTrigger(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public String getName() {
        return this.getName(this.nativeHandle_);
    }

    public Env getEnv() {
        long envHandle = this.getEnv(this.nativeHandle_);
        if (envHandle == Env.getDefault().nativeHandle_) {
            return Env.getDefault();
        }
        RocksEnv env = new RocksEnv(envHandle);
        env.disOwnNativeHandle();
        return env;
    }

    public void flush(FlushOptions flushOptions) throws RocksDBException {
        this.flush(flushOptions, (List<ColumnFamilyHandle>)null);
    }

    public void flush(FlushOptions flushOptions, ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.flush(flushOptions, columnFamilyHandle == null ? null : Collections.singletonList(columnFamilyHandle));
    }

    public void flush(FlushOptions flushOptions, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        this.flush(this.nativeHandle_, flushOptions.nativeHandle_, this.toNativeHandleList(columnFamilyHandles));
    }

    public void flushWal(boolean sync) throws RocksDBException {
        this.flushWal(this.nativeHandle_, sync);
    }

    public void syncWal() throws RocksDBException {
        this.syncWal(this.nativeHandle_);
    }

    public long getLatestSequenceNumber() {
        return this.getLatestSequenceNumber(this.nativeHandle_);
    }

    public void disableFileDeletions() throws RocksDBException {
        this.disableFileDeletions(this.nativeHandle_);
    }

    public void enableFileDeletions(boolean force) throws RocksDBException {
        this.enableFileDeletions(this.nativeHandle_, force);
    }

    public LiveFiles getLiveFiles() throws RocksDBException {
        return this.getLiveFiles(true);
    }

    public LiveFiles getLiveFiles(boolean flushMemtable) throws RocksDBException {
        String[] result = this.getLiveFiles(this.nativeHandle_, flushMemtable);
        if (result == null) {
            return null;
        }
        String[] files = Arrays.copyOf(result, result.length - 1);
        long manifestFileSize = Long.parseLong(result[result.length - 1]);
        return new LiveFiles(manifestFileSize, Arrays.asList(files));
    }

    public List<LogFile> getSortedWalFiles() throws RocksDBException {
        LogFile[] logFiles = this.getSortedWalFiles(this.nativeHandle_);
        return Arrays.asList(logFiles);
    }

    public TransactionLogIterator getUpdatesSince(long sequenceNumber) throws RocksDBException {
        return new TransactionLogIterator(this.getUpdatesSince(this.nativeHandle_, sequenceNumber));
    }

    public void deleteFile(String name) throws RocksDBException {
        this.deleteFile(this.nativeHandle_, name);
    }

    public List<LiveFileMetaData> getLiveFilesMetaData() {
        return Arrays.asList(this.getLiveFilesMetaData(this.nativeHandle_));
    }

    public ColumnFamilyMetaData getColumnFamilyMetaData(ColumnFamilyHandle columnFamilyHandle) {
        return this.getColumnFamilyMetaData(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public ColumnFamilyMetaData getColumnFamilyMetaData() {
        return this.getColumnFamilyMetaData(null);
    }

    public void ingestExternalFile(List<String> filePathList, IngestExternalFileOptions ingestExternalFileOptions) throws RocksDBException {
        this.ingestExternalFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, filePathList.toArray(new String[0]), filePathList.size(), ingestExternalFileOptions.nativeHandle_);
    }

    public void ingestExternalFile(ColumnFamilyHandle columnFamilyHandle, List<String> filePathList, IngestExternalFileOptions ingestExternalFileOptions) throws RocksDBException {
        this.ingestExternalFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, filePathList.toArray(new String[0]), filePathList.size(), ingestExternalFileOptions.nativeHandle_);
    }

    public void verifyChecksum() throws RocksDBException {
        this.verifyChecksum(this.nativeHandle_);
    }

    public ColumnFamilyHandle getDefaultColumnFamily() {
        ColumnFamilyHandle cfHandle = new ColumnFamilyHandle(this, this.getDefaultColumnFamily(this.nativeHandle_));
        cfHandle.disOwnNativeHandle();
        return cfHandle;
    }

    public Map<String, TableProperties> getPropertiesOfAllTables(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        return this.getPropertiesOfAllTables(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public Map<String, TableProperties> getPropertiesOfAllTables() throws RocksDBException {
        return this.getPropertiesOfAllTables(null);
    }

    public Map<String, TableProperties> getPropertiesOfTablesInRange(ColumnFamilyHandle columnFamilyHandle, List<Range> ranges) throws RocksDBException {
        return this.getPropertiesOfTablesInRange(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, RocksDB.toRangeSliceHandles(ranges));
    }

    public Map<String, TableProperties> getPropertiesOfTablesInRange(List<Range> ranges) throws RocksDBException {
        return this.getPropertiesOfTablesInRange(null, ranges);
    }

    public Range suggestCompactRange(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        long[] rangeSliceHandles = this.suggestCompactRange(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
        return new Range(new Slice(rangeSliceHandles[0]), new Slice(rangeSliceHandles[1]));
    }

    public Range suggestCompactRange() throws RocksDBException {
        return this.suggestCompactRange(null);
    }

    public void promoteL0(ColumnFamilyHandle columnFamilyHandle, int targetLevel) throws RocksDBException {
        this.promoteL0(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, targetLevel);
    }

    public void promoteL0(int targetLevel) throws RocksDBException {
        this.promoteL0(null, targetLevel);
    }

    public void startTrace(TraceOptions traceOptions, AbstractTraceWriter traceWriter) throws RocksDBException {
        this.startTrace(this.nativeHandle_, traceOptions.getMaxTraceFileSize(), traceWriter.nativeHandle_);
        traceWriter.disOwnNativeHandle();
    }

    public void endTrace() throws RocksDBException {
        this.endTrace(this.nativeHandle_);
    }

    public void tryCatchUpWithPrimary() throws RocksDBException {
        this.tryCatchUpWithPrimary(this.nativeHandle_);
    }

    public void deleteFilesInRanges(ColumnFamilyHandle columnFamily, List<byte[]> ranges, boolean includeEnd) throws RocksDBException {
        if (ranges.size() == 0) {
            return;
        }
        if (ranges.size() % 2 != 0) {
            throw new IllegalArgumentException("Ranges size needs to be multiple of 2 (from1, to1, from2, to2, ...), but is " + ranges.size());
        }
        byte[][] rangesArray = (byte[][])ranges.toArray((T[])new byte[ranges.size()][]);
        this.deleteFilesInRanges(this.nativeHandle_, columnFamily == null ? 0L : columnFamily.nativeHandle_, rangesArray, includeEnd);
    }

    public static void destroyDB(String path, Options options) throws RocksDBException {
        RocksDB.destroyDB(path, options.nativeHandle_);
    }

    private long[] toNativeHandleList(List<? extends RocksObject> objectList) {
        if (objectList == null) {
            return null;
        }
        int len = objectList.size();
        long[] handleList = new long[len];
        for (int i = 0; i < len; ++i) {
            handleList[i] = objectList.get((int)i).nativeHandle_;
        }
        return handleList;
    }

    private static long[] toRangeSliceHandles(List<Range> ranges) {
        long[] rangeSliceHandles = new long[ranges.size() * 2];
        int j = 0;
        for (int i = 0; i < ranges.size(); ++i) {
            Range range = ranges.get(i);
            rangeSliceHandles[j++] = range.start.getNativeHandle();
            rangeSliceHandles[j++] = range.limit.getNativeHandle();
        }
        return rangeSliceHandles;
    }

    protected void storeOptionsInstance(DBOptionsInterface<?> options) {
        this.options_ = options;
    }

    private static void checkBounds(int offset, int len, int size) {
        if ((offset | len | offset + len | size - (offset + len)) < 0) {
            throw new IndexOutOfBoundsException(String.format("offset(%d), len(%d), size(%d)", offset, len, size));
        }
    }

    private static int computeCapacityHint(int estimatedNumberOfItems) {
        return (int)Math.ceil((double)estimatedNumberOfItems * 1.5 + 1.0);
    }

    private static native long open(long var0, String var2) throws RocksDBException;

    private static native long[] open(long var0, String var2, byte[][] var3, long[] var4) throws RocksDBException;

    private static native long openROnly(long var0, String var2, boolean var3) throws RocksDBException;

    private static native long[] openROnly(long var0, String var2, byte[][] var3, long[] var4, boolean var5) throws RocksDBException;

    private static native long openAsSecondary(long var0, String var2, String var3) throws RocksDBException;

    private static native long[] openAsSecondary(long var0, String var2, String var3, byte[][] var4, long[] var5) throws RocksDBException;

    @Override
    protected native void disposeInternal(long var1);

    private static native void closeDatabase(long var0) throws RocksDBException;

    private static native byte[][] listColumnFamilies(long var0, String var2) throws RocksDBException;

    private native long createColumnFamily(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    private native long[] createColumnFamilies(long var1, long var3, byte[][] var5) throws RocksDBException;

    private native long[] createColumnFamilies(long var1, long[] var3, byte[][] var4) throws RocksDBException;

    private native void dropColumnFamily(long var1, long var3) throws RocksDBException;

    private native void dropColumnFamilies(long var1, long[] var3) throws RocksDBException;

    private native void put(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native void put(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native void put(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native void put(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4, int var5) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4, int var5, long var6) throws RocksDBException;

    private native void delete(long var1, long var3, byte[] var5, int var6, int var7) throws RocksDBException;

    private native void delete(long var1, long var3, byte[] var5, int var6, int var7, long var8) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    private native void singleDelete(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    private native void singleDelete(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    private native void deleteRange(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native void deleteRange(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native void deleteRange(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native void deleteRange(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native void merge(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native void merge(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native void write0(long var1, long var3, long var5) throws RocksDBException;

    private native void write1(long var1, long var3, long var5) throws RocksDBException;

    private native int get(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native int get(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native int get(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native int get(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native byte[] get(long var1, byte[] var3, int var4, int var5) throws RocksDBException;

    private native byte[] get(long var1, byte[] var3, int var4, int var5, long var6) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6, int var7) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6, int var7, long var8) throws RocksDBException;

    private native byte[][] multiGet(long var1, byte[][] var3, int[] var4, int[] var5);

    private native byte[][] multiGet(long var1, byte[][] var3, int[] var4, int[] var5, long[] var6);

    private native byte[][] multiGet(long var1, long var3, byte[][] var5, int[] var6, int[] var7);

    private native byte[][] multiGet(long var1, long var3, byte[][] var5, int[] var6, int[] var7, long[] var8);

    private native void multiGet(long var1, long var3, long[] var5, ByteBuffer[] var6, int[] var7, int[] var8, ByteBuffer[] var9, int[] var10, Status[] var11);

    private native boolean keyMayExist(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    private native byte[][] keyMayExistFoundValue(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    private native void putDirect(long var1, long var3, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, long var11) throws RocksDBException;

    private native long iterator(long var1);

    private native long iterator(long var1, long var3);

    private native long iteratorCF(long var1, long var3);

    private native long iteratorCF(long var1, long var3, long var5);

    private native long[] iterators(long var1, long[] var3, long var4) throws RocksDBException;

    private native long getSnapshot(long var1);

    private native void releaseSnapshot(long var1, long var3);

    private native String getProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    private native Map<String, String> getMapProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    private native int getDirect(long var1, long var3, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, long var11) throws RocksDBException;

    private native boolean keyMayExistDirect(long var1, long var3, long var5, ByteBuffer var7, int var8, int var9);

    private native int[] keyMayExistDirectFoundValue(long var1, long var3, long var5, ByteBuffer var7, int var8, int var9, ByteBuffer var10, int var11, int var12);

    private native void deleteDirect(long var1, long var3, ByteBuffer var5, int var6, int var7, long var8) throws RocksDBException;

    private native long getLongProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    private native void resetStats(long var1) throws RocksDBException;

    private native long getAggregatedLongProperty(long var1, String var3, int var4) throws RocksDBException;

    private native long[] getApproximateSizes(long var1, long var3, long[] var5, byte var6);

    private native long[] getApproximateMemTableStats(long var1, long var3, long var5, long var7);

    private native void compactRange(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7, long var9) throws RocksDBException;

    private native void setOptions(long var1, long var3, String[] var5, String[] var6) throws RocksDBException;

    private native String getOptions(long var1, long var3);

    private native void setDBOptions(long var1, String[] var3, String[] var4) throws RocksDBException;

    private native String getDBOptions(long var1);

    private native String[] compactFiles(long var1, long var3, long var5, String[] var7, int var8, int var9, long var10) throws RocksDBException;

    private native void cancelAllBackgroundWork(long var1, boolean var3);

    private native void pauseBackgroundWork(long var1) throws RocksDBException;

    private native void continueBackgroundWork(long var1) throws RocksDBException;

    private native void enableAutoCompaction(long var1, long[] var3) throws RocksDBException;

    private native int numberLevels(long var1, long var3);

    private native int maxMemCompactionLevel(long var1, long var3);

    private native int level0StopWriteTrigger(long var1, long var3);

    private native String getName(long var1);

    private native long getEnv(long var1);

    private native void flush(long var1, long var3, long[] var5) throws RocksDBException;

    private native void flushWal(long var1, boolean var3) throws RocksDBException;

    private native void syncWal(long var1) throws RocksDBException;

    private native long getLatestSequenceNumber(long var1);

    private native void disableFileDeletions(long var1) throws RocksDBException;

    private native void enableFileDeletions(long var1, boolean var3) throws RocksDBException;

    private native String[] getLiveFiles(long var1, boolean var3) throws RocksDBException;

    private native LogFile[] getSortedWalFiles(long var1) throws RocksDBException;

    private native long getUpdatesSince(long var1, long var3) throws RocksDBException;

    private native void deleteFile(long var1, String var3) throws RocksDBException;

    private native LiveFileMetaData[] getLiveFilesMetaData(long var1);

    private native ColumnFamilyMetaData getColumnFamilyMetaData(long var1, long var3);

    private native void ingestExternalFile(long var1, long var3, String[] var5, int var6, long var7) throws RocksDBException;

    private native void verifyChecksum(long var1) throws RocksDBException;

    private native long getDefaultColumnFamily(long var1);

    private native Map<String, TableProperties> getPropertiesOfAllTables(long var1, long var3) throws RocksDBException;

    private native Map<String, TableProperties> getPropertiesOfTablesInRange(long var1, long var3, long[] var5);

    private native long[] suggestCompactRange(long var1, long var3) throws RocksDBException;

    private native void promoteL0(long var1, long var3, int var5) throws RocksDBException;

    private native void startTrace(long var1, long var3, long var5) throws RocksDBException;

    private native void endTrace(long var1) throws RocksDBException;

    private native void tryCatchUpWithPrimary(long var1) throws RocksDBException;

    private native void deleteFilesInRanges(long var1, long var3, byte[][] var5, boolean var6) throws RocksDBException;

    private static native void destroyDB(String var0, long var1) throws RocksDBException;

    private static native int version();

    static {
        RocksDB.loadLibrary();
    }

    public static class Version {
        private final byte major;
        private final byte minor;
        private final byte patch;

        public Version(byte major, byte minor, byte patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public String toString() {
            return this.getMajor() + "." + this.getMinor() + "." + this.getPatch();
        }

        private static Version fromEncodedVersion(int encodedVersion) {
            byte patch = (byte)(encodedVersion & 0xFF);
            byte minor = (byte)((encodedVersion >>= 8) & 0xFF);
            byte major = (byte)((encodedVersion >>= 8) & 0xFF);
            return new Version(major, minor, patch);
        }
    }

    public static class LiveFiles {
        public final long manifestFileSize;
        public final List<String> files;

        LiveFiles(long manifestFileSize, List<String> files) {
            this.manifestFileSize = manifestFileSize;
            this.files = files;
        }
    }

    public static class CountAndSize {
        public final long count;
        public final long size;

        public CountAndSize(long count, long size) {
            this.count = count;
            this.size = size;
        }
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

