/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.RocksObject;

public class SharedOptions
extends RocksObject {
    public SharedOptions(long capacity, long total_threads) {
        super(SharedOptions.newSharedOptions(capacity, total_threads));
    }

    public SharedOptions(long capacity, long total_threads, long delayed_write_rate, long bucket_size, boolean use_merge) {
        super(SharedOptions.newSharedOptions(capacity, total_threads, delayed_write_rate, bucket_size, use_merge));
    }

    public long getMaxWriteBufferManagerSize() {
        assert (this.isOwningHandle());
        return SharedOptions.getMaxWriteBufferManagerSize(this.nativeHandle_);
    }

    public long getTotalThreads() {
        assert (this.isOwningHandle());
        return SharedOptions.getTotalThreads(this.nativeHandle_);
    }

    public long getTotalRamSizeBytes() {
        assert (this.isOwningHandle());
        return SharedOptions.getTotalRamSizeBytes(this.nativeHandle_);
    }

    public long getDelayedWriteRate() {
        assert (this.isOwningHandle());
        return SharedOptions.getDelayedWriteRate(this.nativeHandle_);
    }

    public long getBucketSize() {
        assert (this.isOwningHandle());
        return SharedOptions.getBucketSize(this.nativeHandle_);
    }

    public boolean isMergeMemtableSupported() {
        assert (this.isOwningHandle());
        return SharedOptions.isMergeMemtableSupported(this.nativeHandle_);
    }

    private static native long newSharedOptions(long var0, long var2, long var4, long var6, boolean var8);

    private static native long newSharedOptions(long var0, long var2);

    @Override
    protected final native void disposeInternal(long var1);

    private static native long getMaxWriteBufferManagerSize(long var0);

    private static native long getTotalThreads(long var0);

    private static native long getTotalRamSizeBytes(long var0);

    private static native long getDelayedWriteRate(long var0);

    private static native long getBucketSize(long var0);

    private static native boolean isMergeMemtableSupported(long var0);
}

