/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.ollama;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.ai.ollama.OllamaClient;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="ai-engine.ollama", name="Ollama Provider", visibilityFeatureToggle=EFeatureToggle.AI_SUPPORT, type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AI, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class OllamaEngineProviderOption
extends AiEngineProviderOptionBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="model")
    @OptionFieldDescription(name="The name of the Ollama model to use, such as 'codellama:7b-instruct'")
    public String model;
    @JsonProperty(value="baseUrl")
    @OptionFieldDescription(name="The base URL to reach the Ollama engine")
    public String baseUrl;

    @Override
    public String getInternalName() {
        return "ollama." + this.model;
    }

    @Override
    public String getDisplayName() {
        return "Ollama (" + this.model + ")";
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            new OllamaClient(this.baseUrl, this.model, this.temperature).complete(new LlmPrompt("", new String[0]));
        }
        catch (ServiceCallException e) {
            return e.getMessage();
        }
        return super.validate(storageInfo, instanceConfiguration);
    }

    @Override
    public Optional<ILlmCompleter> createCompleter(@Nullable BiConsumer<String, Long> usageReporter) {
        return Optional.of(new OllamaClient(this.baseUrl, this.model, this.temperature));
    }
}

