/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class RepositoryNeedsRollbackException
extends RepositoryException {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> rollbackTo;
    private final UUID rollbackId;

    public RepositoryNeedsRollbackException(String message, Map<String, Long> rollbackTo) {
        this(message, rollbackTo, UUID.randomUUID());
    }

    public RepositoryNeedsRollbackException(String message, Throwable cause, Map<String, Long> rollbackTo) {
        this(message, cause, rollbackTo, UUID.randomUUID());
    }

    public RepositoryNeedsRollbackException(String message, Map<String, Long> rollbackTo, UUID rollbackId) {
        super(message);
        this.rollbackTo = rollbackTo;
        this.rollbackId = rollbackId;
    }

    public RepositoryNeedsRollbackException(String message, Throwable cause, Map<String, Long> rollbackTo, UUID rollbackId) {
        super(message, cause);
        this.rollbackTo = rollbackTo;
        this.rollbackId = rollbackId;
    }

    public List<CommitDescriptor> getRollbackToAsSchedulingHints() {
        return CollectionUtils.map(this.rollbackTo.entrySet(), entry -> new CommitDescriptor((String)entry.getKey(), ((Long)entry.getValue()).longValue()));
    }

    public UUID getRollbackId() {
        return this.rollbackId;
    }
}

